/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.config;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.utils.OraxenYaml;
import io.th0rgal.oraxen.utils.ReflectionUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.customarmor.CustomArmorType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ResourcesManager {
    final JavaPlugin plugin;
    private Map.Entry<File, YamlConfiguration> settings;
    private Map.Entry<File, YamlConfiguration> mechanics;

    public ResourcesManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public YamlConfiguration getSettings() {
        return this.getSettingsEntry().getValue();
    }

    public Map.Entry<File, YamlConfiguration> getSettingsEntry() {
        return this.settings != null ? this.settings : (this.settings = this.getEntry("settings.yml"));
    }

    public YamlConfiguration getMechanics() {
        return this.getMechanicsEntry().getValue();
    }

    public Map.Entry<File, YamlConfiguration> getMechanicsEntry() {
        return this.mechanics != null ? this.mechanics : (this.mechanics = this.getEntry("mechanics.yml"));
    }

    public Map.Entry<File, YamlConfiguration> getEntry(String fileName) {
        File file = this.extractConfiguration(fileName);
        return new AbstractMap.SimpleEntry<File, YamlConfiguration>(file, OraxenYaml.loadConfiguration(file));
    }

    public File extractConfiguration(String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            this.plugin.saveResource(fileName, false);
        }
        return file;
    }

    public void extractConfigsInFolder(String folder, String fileExtension) {
        ZipInputStream zip = ResourcesManager.browse();
        try {
            this.extractConfigsInFolder(zip, folder, fileExtension);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void extractConfigsInFolder(ZipInputStream zip, String folder, String fileExtension) throws IOException {
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            this.extractFileAccordingToExtension(entry, folder, fileExtension);
            entry = zip.getNextEntry();
        }
        zip.closeEntry();
        zip.close();
    }

    public void extractFileIfTrue(ZipEntry entry, boolean isSuitable) {
        if (entry.isDirectory() || !isSuitable) {
            return;
        }
        if (entry.getName().startsWith("pack/textures/models/armor/")) {
            CustomArmorType customArmorType = CustomArmorType.getSetting();
            if (OraxenPlugin.get().getDataFolder().toPath().resolve("pack/" + entry.getName()).toFile().exists()) {
                return;
            }
            if (customArmorType != CustomArmorType.SHADER) {
                return;
            }
            if (!Settings.CUSTOM_ARMOR_SHADER_GENERATE_CUSTOM_TEXTURES.toBool().booleanValue() && entry.getName().startsWith("pack/textures/models/armor/leather_layer")) {
                return;
            }
        }
        if (entry.getName().startsWith("items/")) {
            this.extractVersionSpecificItemConfig(entry);
        } else {
            this.plugin.saveResource(entry.getName(), true);
        }
    }

    private void extractVersionSpecificItemConfig(ZipEntry entry) {
        if (!entry.getName().startsWith("items/")) {
            return;
        }
        if (!entry.getName().endsWith(".yml")) {
            return;
        }
        if (!VersionUtil.atOrAbove("1.20.5")) {
            this.plugin.saveResource(entry.getName(), true);
            return;
        }
        try (InputStream inputStream = this.plugin.getResource(entry.getName());){
            YamlConfiguration itemYaml = OraxenYaml.loadConfiguration((Reader)new InputStreamReader(inputStream));
            for (String itemId : itemYaml.getKeys(false)) {
                ConfigurationSection mechanicSection;
                ConfigurationSection itemSection = itemYaml.getConfigurationSection(itemId);
                if (itemSection == null || (mechanicSection = itemSection.getConfigurationSection("Mechanics")) == null) continue;
                ConfigurationSection componentSection = itemSection.getConfigurationSection("Components");
                if (componentSection == null) {
                    componentSection = itemSection.createSection("Components");
                }
                Object durability = mechanicSection.get("durability.value");
                mechanicSection.set("durability", null);
                componentSection.set("durability", durability);
                if (mechanicSection.getKeys(false).isEmpty()) {
                    itemSection.set("Mechanics", null);
                }
                if (!componentSection.getKeys(false).isEmpty()) continue;
                itemSection.set("Components", null);
            }
            File itemFile = this.plugin.getDataFolder().toPath().resolve(entry.getName()).toFile();
            if (VersionUtil.atOrAbove("1.20.5")) {
                FileUtils.writeStringToFile((File)itemFile, (String)itemYaml.saveToString().replace("displayname", "itemname"), (Charset)StandardCharsets.UTF_8);
            } else {
                itemYaml.save(itemFile);
            }
        }
        catch (Exception e) {
            this.plugin.saveResource(entry.getName(), true);
        }
    }

    private void extractFileAccordingToExtension(ZipEntry entry, String folder, String fileExtension) {
        boolean isSuitable = entry.getName().startsWith(folder + "/") && entry.getName().endsWith("." + fileExtension);
        this.extractFileIfTrue(entry, isSuitable);
    }

    public static ZipInputStream browse() {
        return ReflectionUtils.getJarStream(OraxenPlugin.class).orElseThrow(() -> {
            Message.ZIP_BROWSE_ERROR.log(new TagResolver[0]);
            return new RuntimeException("OraxenResources not found!");
        });
    }
}

