/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.model;

import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.base.Axis3D;
import team.unnamed.creative.base.Vector3Float;

public class ElementRotation
implements Examinable {
    public static final boolean DEFAULT_RESCALE = false;
    private final Vector3Float origin;
    private final Axis3D axis;
    private final float angle;
    private final boolean rescale;

    private ElementRotation(Vector3Float origin, Axis3D axis, float angle, boolean rescale) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.axis = Objects.requireNonNull(axis, "axis");
        this.angle = angle;
        this.rescale = rescale;
        this.validate();
    }

    private void validate() {
        float absAngle = Math.abs(this.angle);
        if (this.angle != 0.0f && absAngle != 22.5f && absAngle != 45.0f) {
            throw new IllegalArgumentException("Angle must be multiple of 22.5, in range of -45 to 45");
        }
    }

    public Vector3Float origin() {
        return this.origin;
    }

    public Axis3D axis() {
        return this.axis;
    }

    public float angle() {
        return this.angle;
    }

    public boolean rescale() {
        return this.rescale;
    }

    public ElementRotation origin(Vector3Float origin) {
        return new ElementRotation(origin, this.axis, this.angle, this.rescale);
    }

    public ElementRotation axis(Axis3D axis) {
        return new ElementRotation(this.origin, axis, this.angle, this.rescale);
    }

    public ElementRotation angle(float angle) {
        return new ElementRotation(this.origin, this.axis, angle, this.rescale);
    }

    public ElementRotation rescale(boolean rescale) {
        return new ElementRotation(this.origin, this.axis, this.angle, rescale);
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"origin", (Object)this.origin), ExaminableProperty.of((String)"axis", (Object)((Object)this.axis)), ExaminableProperty.of((String)"angle", (float)this.angle), ExaminableProperty.of((String)"rescale", (boolean)this.rescale));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementRotation that = (ElementRotation)o;
        return Float.compare(that.angle, this.angle) == 0 && this.rescale == that.rescale && this.origin.equals(that.origin) && this.axis == that.axis;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.origin, this.axis, Float.valueOf(this.angle), this.rescale});
    }

    public static ElementRotation of(Vector3Float origin, Axis3D axis, float angle, boolean rescale) {
        return new ElementRotation(origin, axis, angle, rescale);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Vector3Float origin;
        private Axis3D axis;
        private float angle;
        private boolean rescale = false;

        private Builder() {
        }

        public Builder origin(Vector3Float origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            return this;
        }

        public Builder axis(Axis3D axis) {
            this.axis = Objects.requireNonNull(axis, "axis");
            return this;
        }

        public Builder angle(float angle) {
            this.angle = Objects.requireNonNull(Float.valueOf(angle), "angle").floatValue();
            return this;
        }

        public Builder rescale(boolean rescale) {
            this.rescale = rescale;
            return this;
        }

        public ElementRotation build() {
            return new ElementRotation(this.origin, this.axis, this.angle, this.rescale);
        }
    }
}

