/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.filter;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.base.KeyPattern;
import team.unnamed.creative.metadata.MetadataPart;
import team.unnamed.creative.metadata.filter.FilterMeta;
import team.unnamed.creative.util.MoreCollections;

final class FilterMetaImpl
implements FilterMeta {
    private final List<KeyPattern> patterns;

    FilterMetaImpl(@NotNull List<KeyPattern> patterns) {
        this.patterns = MoreCollections.immutableListOf(Objects.requireNonNull(patterns, "patterns"));
        this.validate();
    }

    private void validate() {
        if (this.patterns.isEmpty()) {
            throw new IllegalArgumentException("Patterns list is empty!");
        }
        for (KeyPattern pattern : this.patterns) {
            if (pattern != null) continue;
            throw new NullPointerException("An element in the patterns list is null");
        }
    }

    @Override
    @NotNull
    public Class<? extends MetadataPart> type() {
        return FilterMeta.class;
    }

    @Override
    @NotNull
    public @Unmodifiable List<KeyPattern> patterns() {
        return this.patterns;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"patterns", this.patterns));
    }

    @NotNull
    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterMetaImpl that = (FilterMetaImpl)o;
        return this.patterns.equals(that.patterns);
    }

    public int hashCode() {
        return Objects.hash(this.patterns);
    }
}

