/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.util.actions.components;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.gabytm.util.actions.components.Component;
import me.gabytm.util.actions.components.implementations.MathComponent;
import me.gabytm.util.actions.components.implementations.RandomDoubleComponent;
import me.gabytm.util.actions.components.implementations.RandomElementComponent;
import me.gabytm.util.actions.components.implementations.RandomLongComponent;
import me.gabytm.util.actions.components.implementations.StringComponent;
import me.gabytm.util.actions.placeholders.PlaceholderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentParser {
    private static final Pattern COMPONENT_PATTERN = Pattern.compile("~?(?<id>[a-zA-Z]+):\\{(?<data>[^}]+)}");
    private final Table<String, Class<?>, Component.Supplier<?, ?>> registeredComponents = HashBasedTable.create();
    private final PlaceholderManager placeholderManager;

    public ComponentParser(PlaceholderManager placeholderManager) {
        this.placeholderManager = placeholderManager;
    }

    @Nullable
    private <T> Component<T, ?> createComponent(@NotNull Class<T> clazz, @NotNull String id, @NotNull String value) {
        Component.Supplier supplier = (Component.Supplier)this.registeredComponents.get((Object)id.toLowerCase(), clazz);
        if (supplier == null) {
            return null;
        }
        return supplier.run(value, this.placeholderManager);
    }

    public <T, R> void register(@NotNull Class<T> clazz, @NotNull String id, @NotNull Component.Supplier<T, R> supplier) {
        this.registeredComponents.put((Object)id.toLowerCase(), clazz, supplier);
    }

    public <T> void registerDefaults(@NotNull Class<T> clazz) {
        this.register(clazz, "math", MathComponent::new);
        this.register(clazz, "random", RandomDoubleComponent::new);
        this.register(clazz, "randomL", RandomLongComponent::new);
        this.register(clazz, "randomE", RandomElementComponent::new);
    }

    @NotNull
    public <T> List<Component<T, ?>> parseComponents(@NotNull Class<T> clazz, @NotNull String data) {
        Matcher matcher = COMPONENT_PATTERN.matcher(data);
        ArrayList foundComponents = new ArrayList();
        int lastMatchEnd = 0;
        while (matcher.find()) {
            int matchStart = matcher.start();
            String id = matcher.group("id").toLowerCase();
            Component<T, ?> node = this.createComponent(clazz, id, matcher.group("data"));
            if (node == null) {
                foundComponents.add(new StringComponent(data.substring(lastMatchEnd, matcher.end()), this.placeholderManager));
                lastMatchEnd = matcher.end();
                continue;
            }
            if (matchStart != 0 && matchStart != lastMatchEnd) {
                foundComponents.add(new StringComponent(data.substring(lastMatchEnd, matchStart), this.placeholderManager));
            }
            foundComponents.add(node);
            lastMatchEnd = matcher.end();
        }
        if (lastMatchEnd != data.length()) {
            foundComponents.add(new StringComponent(data.substring(lastMatchEnd), this.placeholderManager));
        }
        return foundComponents;
    }
}

