/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.drops.Drop;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    public static boolean isEmpty(ItemStack itemStack) {
        return itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() == 0;
    }

    public static void subtract(ItemStack itemStack, int amount) {
        itemStack.setAmount(Math.max(0, itemStack.getAmount() - amount));
    }

    public static void dyeItem(ItemStack itemStack, Color color) {
        ItemUtils.editItemMeta(itemStack, meta -> {
            if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
                leatherArmorMeta.setColor(color);
            } else if (meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                potionMeta.setColor(color);
            } else if (meta instanceof MapMeta) {
                MapMeta mapMeta = (MapMeta)meta;
                mapMeta.setColor(color);
            }
        });
    }

    public static void editItemMeta(ItemStack itemStack, Consumer<ItemMeta> function) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return;
        }
        function.accept(meta);
        itemStack.setItemMeta(meta);
    }

    public static void damageItem(Player player, Drop drop, ItemStack itemStack) {
        if (drop == null) {
            return;
        }
        boolean isToolEnough = drop.isToolEnough(itemStack);
        int damage = isToolEnough ? 1 : 2;
        int n = damage = ItemUtils.isTool(itemStack) ? damage : 0;
        if (damage == 0) {
            return;
        }
        if (VersionUtil.isPaperServer() && VersionUtil.atOrAbove("1.19")) {
            player.damageItemStack(itemStack, damage);
        } else {
            int finalDamage = damage;
            ItemUtils.editItemMeta(itemStack, meta -> {
                if (meta instanceof Damageable) {
                    Damageable damageable = (Damageable)meta;
                    if (EventUtils.callEvent((Event)new PlayerItemDamageEvent(player, itemStack, finalDamage))) {
                        damageable.setDamage(damageable.getDamage() + 1);
                    }
                }
            });
        }
    }

    public static boolean isTool(@NotNull ItemStack itemStack) {
        return ItemUtils.isTool(itemStack.getType());
    }

    public static boolean isTool(@NotNull Material material) {
        if (VersionUtil.atOrAbove("1.19.4") && !VersionUtil.atOrAbove("1.20.5")) {
            return Tag.ITEMS_TOOLS.isTagged((Keyed)material);
        }
        return material.toString().endsWith("_AXE") || material.toString().endsWith("_PICKAXE") || material.toString().endsWith("_SHOVEL") || material.toString().endsWith("_HOE") || material.toString().endsWith("_SWORD") || material == Material.TRIDENT;
    }

    public static boolean isSkull(Material material) {
        return switch (material) {
            case Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD, Material.SKELETON_SKULL, Material.SKELETON_WALL_SKULL, Material.WITHER_SKELETON_SKULL, Material.WITHER_SKELETON_WALL_SKULL, Material.ZOMBIE_HEAD, Material.ZOMBIE_WALL_HEAD, Material.CREEPER_HEAD, Material.CREEPER_WALL_HEAD, Material.DRAGON_HEAD, Material.DRAGON_WALL_HEAD, Material.PIGLIN_HEAD, Material.PIGLIN_WALL_HEAD -> true;
            default -> false;
        };
    }

    public static boolean hasInventoryParent(Material material) {
        return Tag.WALLS.isTagged((Keyed)material) || Tag.FENCES.isTagged((Keyed)material) || Tag.BUTTONS.isTagged((Keyed)material) || material == Material.PISTON || material == Material.STICKY_PISTON || VersionUtil.atOrAbove("1.20") && material == Material.CHISELED_BOOKSHELF || material == Material.BROWN_MUSHROOM_BLOCK || material == Material.RED_MUSHROOM_BLOCK || material == Material.MUSHROOM_STEM;
    }

    public static boolean isMusicDisc(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (VersionUtil.atOrAbove("1.21") && itemStack.hasItemMeta() && itemStack.getItemMeta().hasJukeboxPlayable()) {
            return true;
        }
        return itemStack.getType().name().startsWith("MUSIC_DISC");
    }

    @Nullable
    public static ItemStack getUsingConvertsTo(ItemMeta itemMeta) {
        if (!VersionUtil.atOrAbove("1.21") || itemMeta == null) {
            return null;
        }
        if (VersionUtil.atOrAbove("1.21.2")) {
            return itemMeta.hasUseRemainder() ? itemMeta.getUseRemainder() : null;
        }
        try {
            return (ItemStack)FoodComponent.class.getMethod("getUsingConvertsTo", new Class[0]).invoke((Object)itemMeta.getFood(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

