/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.gui.type;

import com.github.stefvanschie.inventoryframework.HumanEntityCache;
import com.github.stefvanschie.inventoryframework.abstraction.SmithingTableInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.InventoryBased;
import com.github.stefvanschie.inventoryframework.gui.type.util.NamedGui;
import com.github.stefvanschie.inventoryframework.util.version.Version;
import com.github.stefvanschie.inventoryframework.util.version.VersionMatcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Deprecated
public class SmithingTableGui
extends NamedGui
implements InventoryBased {
    @NotNull
    private InventoryComponent firstItemComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent secondItemComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent resultComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent playerInventoryComponent = new InventoryComponent(9, 4);
    @NotNull
    private final SmithingTableInventory smithingTableInventory = VersionMatcher.newSmithingTableInventory(Version.getVersion(), this);

    public SmithingTableGui(@NotNull String title) {
        super(title);
    }

    public SmithingTableGui(@NotNull TextHolder title) {
        super(title);
    }

    public SmithingTableGui(@NotNull String title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    public SmithingTableGui(@NotNull TextHolder title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (!(humanEntity instanceof Player)) {
            throw new IllegalArgumentException("Smithing tables can only be opened by players");
        }
        if (this.isDirty()) {
            this.inventory = this.createInventory();
            this.markChanges();
        }
        this.getInventory().clear();
        this.getFirstItemComponent().display(this.getInventory(), 0);
        this.getSecondItemComponent().display(this.getInventory(), 1);
        this.getResultComponent().display(this.getInventory(), 2);
        this.getPlayerInventoryComponent().display();
        if (this.getPlayerInventoryComponent().hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (!humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            this.getPlayerInventoryComponent().placeItems(humanEntity.getInventory(), 0);
        }
        humanEntity.openInventory(this.getInventory());
        this.smithingTableInventory.openInventory((Player)humanEntity, this.getTitleHolder(), this.getTopItems());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public SmithingTableGui copy() {
        SmithingTableGui gui = new SmithingTableGui(this.getTitleHolder(), this.plugin);
        gui.firstItemComponent = this.firstItemComponent.copy();
        gui.secondItemComponent = this.secondItemComponent.copy();
        gui.resultComponent = this.resultComponent.copy();
        gui.playerInventoryComponent = this.playerInventoryComponent.copy();
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        if (rawSlot == 0) {
            this.getFirstItemComponent().click(this, event, 0);
        } else if (rawSlot == 1) {
            this.getSecondItemComponent().click(this, event, 0);
        } else if (rawSlot == 2) {
            this.getResultComponent().click(this, event, 0);
        } else {
            this.getPlayerInventoryComponent().click(this, event, rawSlot - 3);
        }
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    @Contract(pure=true)
    public boolean isPlayerInventoryUsed() {
        return this.getPlayerInventoryComponent().hasItem();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        return this.getTitleHolder().asInventoryTitle((InventoryHolder)this, InventoryType.SMITHING);
    }

    public void handleClickEvent(@NotNull InventoryClickEvent event) {
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        if (slot >= 3 && slot <= 38) {
            this.smithingTableInventory.sendItems(player, this.getTopItems(), event.getCurrentItem());
        } else if (slot == 0 || slot == 1) {
            if (event.isCancelled()) {
                if (slot == 0) {
                    this.smithingTableInventory.sendFirstItem(player, this.getFirstItemComponent().getItem(0, 0));
                } else {
                    this.smithingTableInventory.sendSecondItem(player, this.getSecondItemComponent().getItem(0, 0));
                }
                this.smithingTableInventory.clearCursor(player);
            }
            this.smithingTableInventory.sendResultItem(player, this.getResultComponent().getItem(0, 0));
        } else if (slot == 2 && !event.isCancelled()) {
            this.smithingTableInventory.clearResultItem(player);
            ItemStack resultItem = this.getResultComponent().getItem(0, 0);
            if (resultItem != null) {
                this.smithingTableInventory.setCursor(player, resultItem);
            }
        }
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getFirstItemComponent() {
        return this.firstItemComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getSecondItemComponent() {
        return this.secondItemComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getResultComponent() {
        return this.resultComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getPlayerInventoryComponent() {
        return this.playerInventoryComponent;
    }

    @Nullable
    @Contract(pure=true)
    private ItemStack[] getTopItems() {
        return new ItemStack[]{this.getFirstItemComponent().getItem(0, 0), this.getSecondItemComponent().getItem(0, 0), this.getResultComponent().getItem(0, 0)};
    }

    @Nullable
    @Contract(pure=true)
    public static SmithingTableGui load(@NotNull Object instance, @NotNull InputStream inputStream, @NotNull Plugin plugin) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            return SmithingTableGui.load(instance, documentElement, plugin);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static SmithingTableGui load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        if (!element.hasAttribute("title")) {
            throw new XMLLoadException("Provided XML element's gui tag doesn't have the mandatory title attribute set");
        }
        SmithingTableGui smithingTableGui = new SmithingTableGui(element.getAttribute("title"), plugin);
        smithingTableGui.initializeOrThrow(instance, element);
        if (element.hasAttribute("populate")) {
            return smithingTableGui;
        }
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            InventoryComponent component;
            Node item = childNodes.item(index);
            if (item.getNodeType() != 1) continue;
            Element componentElement = (Element)item;
            if (!componentElement.getTagName().equalsIgnoreCase("component")) {
                throw new XMLLoadException("Gui element contains non-component tags");
            }
            if (!componentElement.hasAttribute("name")) {
                throw new XMLLoadException("Component tag does not have a name specified");
            }
            switch (componentElement.getAttribute("name")) {
                case "first-item": {
                    component = smithingTableGui.getFirstItemComponent();
                    break;
                }
                case "second-item": {
                    component = smithingTableGui.getSecondItemComponent();
                    break;
                }
                case "result": {
                    component = smithingTableGui.getResultComponent();
                    break;
                }
                case "player-inventory": {
                    component = smithingTableGui.getPlayerInventoryComponent();
                    break;
                }
                default: {
                    throw new XMLLoadException("Unknown component name");
                }
            }
            component.load(instance, componentElement, plugin);
        }
        return smithingTableGui;
    }

    @Nullable
    @Contract(pure=true)
    public static SmithingTableGui load(@NotNull Object instance, @NotNull InputStream inputStream) {
        return SmithingTableGui.load(instance, inputStream, (Plugin)JavaPlugin.getProvidingPlugin(SmithingTableGui.class));
    }

    @NotNull
    public static SmithingTableGui load(@NotNull Object instance, @NotNull Element element) {
        return SmithingTableGui.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(SmithingTableGui.class));
    }
}

