/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.sound;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.overlay.ResourceContainer;
import team.unnamed.creative.part.ResourcePackPart;
import team.unnamed.creative.sound.Sound;
import team.unnamed.creative.sound.SoundEntry;
import team.unnamed.creative.sound.SoundEventImpl;

@ApiStatus.NonExtendable
public interface SoundEvent
extends ResourcePackPart,
Sound.Type,
Examinable {
    public static final boolean DEFAULT_REPLACE = false;

    @NotNull
    public static SoundEvent soundEvent(@NotNull Key key, boolean replace, @Nullable String subtitle, @NotNull List<SoundEntry> sounds) {
        return new SoundEventImpl(key, replace, subtitle, sounds);
    }

    @NotNull
    public static Builder soundEvent() {
        return new SoundEventImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static SoundEvent of(@NotNull Key key, boolean replace, @Nullable String subtitle, @NotNull List<SoundEntry> sounds) {
        return new SoundEventImpl(key, replace, subtitle, sounds);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Builder builder() {
        return new SoundEventImpl.BuilderImpl();
    }

    @NotNull
    public Key key();

    public boolean replace();

    @Nullable
    public String subtitle();

    public @Unmodifiable @NotNull List<SoundEntry> sounds();

    @Override
    default public void addTo(@NotNull ResourceContainer resourceContainer) {
        resourceContainer.soundEvent(this);
    }

    @Contract(value="-> new")
    @NotNull
    public Builder toBuilder();

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull Key var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder replace(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder subtitle(@Nullable String var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder sounds(@NotNull List<SoundEntry> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder addSound(@NotNull SoundEntry var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder addSound(@NotNull Sound sound) {
            return this.addSound(SoundEntry.soundEntry(sound));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder addSound(@NotNull SoundEvent soundEvent) {
            return this.addSound(SoundEntry.soundEntry(soundEvent));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder sounds(SoundEntry ... sounds) {
            Objects.requireNonNull(sounds, "sounds");
            return this.sounds(Arrays.asList(sounds));
        }

        @NotNull
        public SoundEvent build();
    }
}

