/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.model;

import net.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.base.Vector3Float;
import team.unnamed.creative.model.ItemTransformImpl;

public interface ItemTransform
extends Examinable {
    public static final float MIN_TRANSLATION = -80.0f;
    public static final float MAX_TRANSLATION = 80.0f;
    public static final float MIN_SCALE = -4.0f;
    public static final float MAX_SCALE = 4.0f;
    public static final Vector3Float DEFAULT_ROTATION = Vector3Float.ZERO;
    public static final Vector3Float DEFAULT_TRANSLATION = Vector3Float.ZERO;
    public static final Vector3Float DEFAULT_SCALE = Vector3Float.ONE;

    @NotNull
    public Vector3Float rotation();

    @NotNull
    public Vector3Float translation();

    @NotNull
    public Vector3Float scale();

    @NotNull
    public static ItemTransform transform(@NotNull Vector3Float rotation, @NotNull Vector3Float translation, @NotNull Vector3Float scale) {
        return new ItemTransformImpl(rotation, translation, scale);
    }

    @NotNull
    public static Builder transform() {
        return new ItemTransformImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static ItemTransform of(@NotNull Vector3Float rotation, @NotNull Vector3Float translation, @NotNull Vector3Float scale) {
        return new ItemTransformImpl(rotation, translation, scale);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Builder builder() {
        return new ItemTransformImpl.BuilderImpl();
    }

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder rotation(@NotNull Vector3Float var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder translation(@NotNull Vector3Float var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder scale(@NotNull Vector3Float var1);

        @Contract(value="-> this")
        @NotNull
        public ItemTransform build();
    }

    public static enum Type {
        THIRDPERSON_RIGHTHAND,
        THIRDPERSON_LEFTHAND,
        FIRSTPERSON_RIGHTHAND,
        FIRSTPERSON_LEFTHAND,
        GUI,
        HEAD,
        GROUND,
        FIXED;

    }
}

