/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.base.CubeFace;
import team.unnamed.creative.base.Vector3Float;
import team.unnamed.creative.model.Element;
import team.unnamed.creative.model.ElementFace;
import team.unnamed.creative.model.ElementRotation;
import team.unnamed.creative.util.MoreCollections;

final class ElementImpl
implements Element {
    private final Vector3Float from;
    private final Vector3Float to;
    private final ElementRotation rotation;
    private final boolean shade;
    private final Map<CubeFace, ElementFace> faces;

    ElementImpl(@NotNull Vector3Float from, @NotNull Vector3Float to, @Nullable ElementRotation rotation, boolean shade, @NotNull Map<CubeFace, ElementFace> faces) {
        this.from = Objects.requireNonNull(from, "from");
        this.to = Objects.requireNonNull(to, "to");
        this.rotation = rotation;
        this.shade = shade;
        this.faces = MoreCollections.immutableMapOf(Objects.requireNonNull(faces, "faces"));
        this.validate();
    }

    private void validateBound(float value, String axisName) {
        if (value < -16.0f || value > 32.0f) {
            throw new IllegalArgumentException("Value at " + axisName + " axis (" + value + ") is out of bounds");
        }
    }

    private void validateBound(Vector3Float vec) {
        this.validateBound(vec.x(), "X");
        this.validateBound(vec.y(), "Y");
        this.validateBound(vec.z(), "Z");
    }

    private void validate() {
        this.validateBound(this.from);
        this.validateBound(this.to);
        if (this.faces.size() < 1 || this.faces.size() > 6) {
            throw new IllegalArgumentException("Invalid amount of faces (" + this.faces.size() + ")");
        }
    }

    @Override
    @NotNull
    public Vector3Float from() {
        return this.from;
    }

    @Override
    @NotNull
    public Vector3Float to() {
        return this.to;
    }

    @Override
    @NotNull
    public ElementRotation rotation() {
        return this.rotation;
    }

    @Override
    public boolean shade() {
        return this.shade;
    }

    @Override
    public @Unmodifiable @NotNull Map<CubeFace, ElementFace> faces() {
        return this.faces;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"from", (Object)this.from), ExaminableProperty.of((String)"to", (Object)this.to), ExaminableProperty.of((String)"rotation", (Object)this.rotation), ExaminableProperty.of((String)"shade", (boolean)this.shade), ExaminableProperty.of((String)"faces", this.faces));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementImpl element = (ElementImpl)o;
        return this.from.equals(element.from) && this.to.equals(element.to) && Objects.equals(this.rotation, element.rotation) && this.shade == element.shade && this.faces.equals(element.faces);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.rotation, this.shade, this.faces);
    }

    static final class BuilderImpl
    implements Element.Builder {
        private Vector3Float from;
        private Vector3Float to;
        private ElementRotation rotation = null;
        private boolean shade = true;
        private Map<CubeFace, ElementFace> faces = new LinkedHashMap<CubeFace, ElementFace>();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public Element.Builder from(@NotNull Vector3Float from) {
            this.from = Objects.requireNonNull(from, "from");
            return this;
        }

        @Override
        @NotNull
        public Element.Builder to(@NotNull Vector3Float to) {
            this.to = Objects.requireNonNull(to, "to");
            return this;
        }

        @Override
        @NotNull
        public Element.Builder rotation(@Nullable ElementRotation rotation) {
            this.rotation = rotation;
            return this;
        }

        @Override
        @NotNull
        public Element.Builder shade(boolean shade) {
            this.shade = shade;
            return this;
        }

        @Override
        @NotNull
        public Element.Builder faces(@NotNull Map<CubeFace, ElementFace> faces) {
            this.faces = new LinkedHashMap<CubeFace, ElementFace>(Objects.requireNonNull(faces, "faces"));
            return this;
        }

        @Override
        @NotNull
        public Element.Builder addFace(@NotNull CubeFace type, @NotNull ElementFace face) {
            Objects.requireNonNull(type, "type");
            Objects.requireNonNull(face, "face");
            this.faces.put(type, face);
            return this;
        }

        @Override
        @NotNull
        public Element build() {
            return new ElementImpl(this.from, this.to, this.rotation, this.shade, this.faces);
        }
    }
}

