/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.lang;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.lang.Language;

final class LanguageImpl
implements Language {
    private final Key key;
    private final Map<String, String> translations;

    LanguageImpl(@NotNull Key key, @NotNull Map<String, String> translations) {
        this.key = Objects.requireNonNull(key, "key");
        this.translations = Objects.requireNonNull(translations, "translations");
        this.validate();
    }

    private void validate() {
        this.translations.forEach((key, value) -> {
            Objects.requireNonNull(key, "Translation key cannot be null");
            Objects.requireNonNull(value, "Translation cannot be null");
        });
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    @NotNull
    public Map<String, String> translations() {
        return this.translations;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"key", (Object)this.key), ExaminableProperty.of((String)"translations", this.translations));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageImpl that = (LanguageImpl)o;
        return this.key.equals(that.key) && this.translations.equals(that.translations);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.translations);
    }

    static final class BuilderImpl
    implements Language.Builder {
        private Key key;
        private Map<String, String> translations;

        BuilderImpl() {
        }

        @Override
        @NotNull
        public Language.Builder key(@NotNull Key key) {
            this.key = Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        @NotNull
        public Language.Builder translations(@NotNull Map<String, String> translations) {
            this.translations = Objects.requireNonNull(translations, "translations");
            return this;
        }

        @Override
        @NotNull
        public Language.Builder translation(@NotNull String key, @NotNull String value) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            if (this.translations == null) {
                this.translations = new LinkedHashMap<String, String>();
            }
            this.translations.put(key, value);
            return this;
        }

        @Override
        @NotNull
        public Language build() {
            return new LanguageImpl(this.key, this.translations);
        }
    }
}

