/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.component.functional;

import dev.triumphteam.gui.click.handler.ClickHandler;
import dev.triumphteam.gui.click.handler.CompletableFutureClickHandler;
import dev.triumphteam.gui.click.handler.SimpleClickHandler;
import dev.triumphteam.gui.component.functional.BaseFunctionalGuiComponent;
import dev.triumphteam.nova.MutableState;
import dev.triumphteam.nova.State;
import dev.triumphteam.nova.builtin.EmptyState;
import dev.triumphteam.nova.builtin.SimpleMutableState;
import dev.triumphteam.nova.policy.StateMutationPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFunctionalGuiComponent<P>
implements BaseFunctionalGuiComponent<P> {
    private final List<State> states = new ArrayList<State>();
    private ClickHandler<P> clickHandler = null;

    @NotNull
    public State state() {
        return this.state((State)new EmptyState());
    }

    @NotNull
    public <S extends State> S state(@NotNull S state) {
        this.states.add(state);
        return state;
    }

    @NotNull
    public <T> @NotNull MutableState<@NotNull T> state(@NotNull T value) {
        return this.state(value, StateMutationPolicy.StructuralEquality.INSTANCE);
    }

    @NotNull
    public <T> @NotNull MutableState<@NotNull T> state(@NotNull T value, @NotNull StateMutationPolicy mutationPolicy) {
        SimpleMutableState state = new SimpleMutableState(value, mutationPolicy);
        this.states.add((State)state);
        return state;
    }

    public <T> @NotNull MutableState<@Nullable T> nullableState(@Nullable T value) {
        return this.nullableState(value, StateMutationPolicy.StructuralEquality.INSTANCE);
    }

    public <T> @NotNull MutableState<@Nullable T> nullableState(@Nullable T value, @NotNull StateMutationPolicy mutationPolicy) {
        SimpleMutableState state = new SimpleMutableState(value, mutationPolicy);
        this.states.add((State)state);
        return state;
    }

    @Override
    public void withClickHandler(@Nullable ClickHandler<P> clickHandler) {
        this.clickHandler = clickHandler;
    }

    @Override
    public void withSimpleClickHandler() {
        this.clickHandler = new SimpleClickHandler();
    }

    @Override
    public void withCompletableFutureClickHandler() {
        this.clickHandler = new CompletableFutureClickHandler();
    }

    @Override
    public void withCompletableFutureClickHandler(long timeout, @NotNull TimeUnit unit) {
        this.clickHandler = new CompletableFutureClickHandler(timeout, unit);
    }

    @Nullable
    public ClickHandler<P> getClickHandler() {
        return this.clickHandler;
    }

    @NotNull
    protected List<State> getStates() {
        return this.states;
    }
}

