/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.soulbound;

import com.jeff_media.morepersistentdatatypes.DataType;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.provided.misc.soulbound.SoulBoundMechanic;
import io.th0rgal.oraxen.mechanics.provided.misc.soulbound.SoulBoundMechanicFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;

public class SoulBoundMechanicListener
implements Listener {
    private final SoulBoundMechanicFactory factory;

    public SoulBoundMechanicListener(SoulBoundMechanicFactory factory) {
        this.factory = factory;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (event.getKeepInventory()) {
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack drop : event.getDrops()) {
            String itemID = OraxenItems.getIdByItem(drop);
            if (itemID == null || this.factory.isNotImplementedIn(itemID)) continue;
            SoulBoundMechanic mechanic = (SoulBoundMechanic)this.factory.getMechanic(itemID);
            if (!((double)((Random)random).nextInt(100) >= mechanic.getLoseChance() * 100.0)) continue;
            items.add(drop);
        }
        if (!items.isEmpty()) {
            Player player = event.getEntity();
            PersistentDataContainer pdc = player.getPersistentDataContainer();
            pdc.set(SoulBoundMechanic.NAMESPACED_KEY, DataType.ITEM_STACK_ARRAY, (Object)((ItemStack[])items.toArray(ItemStack[]::new)));
            event.getDrops().removeAll(items);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        if (!pdc.has(SoulBoundMechanic.NAMESPACED_KEY, DataType.ITEM_STACK_ARRAY)) {
            return;
        }
        ItemStack[] items = (ItemStack[])pdc.getOrDefault(SoulBoundMechanic.NAMESPACED_KEY, DataType.ITEM_STACK_ARRAY, (Object)new ItemStack[0]);
        Collection remainingItems = player.getInventory().addItem(items).values();
        for (ItemStack item : remainingItems) {
            player.getWorld().dropItem(player.getLocation(), item);
        }
        pdc.remove(SoulBoundMechanic.NAMESPACED_KEY);
    }
}

