/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.jeff_media.morepersistentdatatypes.DataType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.compatibilities.provided.ecoitems.WrappedEcoItem;
import io.th0rgal.oraxen.compatibilities.provided.mmoitems.WrappedMMOItem;
import io.th0rgal.oraxen.compatibilities.provided.mythiccrucible.WrappedCrucibleItem;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.items.OraxenMeta;
import io.th0rgal.oraxen.items.PersistentDataSpace;
import io.th0rgal.oraxen.nms.NMSHandlers;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.OraxenYaml;
import io.th0rgal.oraxen.utils.PotionUtils;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.VersionUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.components.UseCooldownComponent;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder {
    public static final NamespacedKey UNSTACKABLE_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "unstackable");
    public static final NamespacedKey ORIGINAL_NAME_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "original_name");
    private final ItemStack itemStack;
    private final Map<PersistentDataSpace, Object> persistentDataMap = new HashMap<PersistentDataSpace, Object>();
    private final PersistentDataContainer persistentDataContainer;
    private final Map<Enchantment, Integer> enchantments;
    private OraxenMeta oraxenMeta;
    private Material type;
    private int amount;
    private Color color;
    private Key trimPattern;
    private PotionType potionType;
    private List<PotionEffect> potionEffects;
    private OfflinePlayer owningPlayer;
    private DyeColor bodyColor;
    private TropicalFish.Pattern pattern;
    private DyeColor patternColor;
    private String displayName;
    private boolean unbreakable;
    private boolean unstackable;
    private Set<ItemFlag> itemFlags;
    private boolean hasAttributeModifiers;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    @Nullable
    private Integer customModelData;
    private List<String> lore;
    private ItemStack finalItemStack;
    @Nullable
    private FoodComponent foodComponent;
    @Nullable
    private Object consumableComponent;
    @Nullable
    private ToolComponent toolComponent;
    @Nullable
    private Boolean enchantmentGlintOverride;
    @Nullable
    private Integer maxStackSize;
    @Nullable
    private String itemName;
    @Nullable
    private Boolean fireResistant;
    @Nullable
    private Boolean hideToolTip;
    @Nullable
    private ItemRarity rarity;
    @Nullable
    private Integer durability;
    private boolean damagedOnBlockBreak;
    private boolean damagedOnEntityHit;
    @Nullable
    private JukeboxPlayableComponent jukeboxPlayable;
    @Nullable
    private EquippableComponent equippableComponent;
    @Nullable
    private Boolean isGlider;
    @Nullable
    private UseCooldownComponent useCooldownComponent;
    @Nullable
    private ItemStack useRemainder;
    @Nullable
    private Tag<DamageType> damageResistant;
    @Nullable
    private NamespacedKey tooltipStyle;
    @Nullable
    private NamespacedKey itemModel;
    @Nullable
    private Integer enchantable;

    public ItemBuilder(Material material) {
        this(new ItemStack(material));
    }

    public ItemBuilder(WrappedMMOItem wrapped) {
        this(wrapped.build());
    }

    public ItemBuilder(WrappedCrucibleItem wrapped) {
        this(wrapped.build());
    }

    public ItemBuilder(WrappedEcoItem wrapped) {
        this(wrapped.build());
    }

    public ItemBuilder(@NotNull ItemStack itemStack) {
        TropicalFishBucketMeta tropicalFishBucketMeta;
        ArmorMeta armorMeta;
        this.itemStack = itemStack;
        this.type = itemStack.getType();
        this.amount = itemStack.getAmount();
        ItemMeta itemMeta = itemStack.getItemMeta();
        assert (itemMeta != null);
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            this.color = leatherArmorMeta.getColor();
        }
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            this.color = potionMeta.getColor();
            this.potionType = PotionUtils.getPotionType(potionMeta);
            this.potionEffects = new ArrayList<PotionEffect>(potionMeta.getCustomEffects());
        }
        if (itemMeta instanceof MapMeta) {
            MapMeta mapMeta = (MapMeta)itemMeta;
            this.color = mapMeta.getColor();
        }
        if (itemMeta instanceof FireworkEffectMeta) {
            FireworkEffectMeta effectMeta = (FireworkEffectMeta)itemMeta;
            Color color = this.color = effectMeta.hasEffect() ? Utils.getOrDefault(effectMeta.getEffect().getColors(), 0, Color.WHITE) : Color.WHITE;
        }
        if (VersionUtil.atOrAbove("1.20") && itemMeta instanceof ArmorMeta && (armorMeta = (ArmorMeta)itemMeta).hasTrim()) {
            this.trimPattern = armorMeta.getTrim().getMaterial().key();
        }
        if (itemMeta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            this.owningPlayer = skullMeta.getOwningPlayer();
        }
        if (itemMeta instanceof TropicalFishBucketMeta && (tropicalFishBucketMeta = (TropicalFishBucketMeta)itemMeta).hasVariant()) {
            this.bodyColor = tropicalFishBucketMeta.getBodyColor();
            this.pattern = tropicalFishBucketMeta.getPattern();
            this.patternColor = tropicalFishBucketMeta.getPatternColor();
        }
        if (itemMeta.hasDisplayName()) {
            this.displayName = VersionUtil.isPaperServer() ? (String)AdventureUtils.MINI_MESSAGE.serialize(itemMeta.displayName()) : itemMeta.getDisplayName();
        }
        this.unbreakable = itemMeta.isUnbreakable();
        this.unstackable = itemMeta.getPersistentDataContainer().has(UNSTACKABLE_KEY, DataType.UUID);
        if (!itemMeta.getItemFlags().isEmpty()) {
            this.itemFlags = itemMeta.getItemFlags();
        }
        this.hasAttributeModifiers = itemMeta.hasAttributeModifiers();
        if (this.hasAttributeModifiers) {
            this.attributeModifiers = itemMeta.getAttributeModifiers();
        }
        Integer n = this.customModelData = itemMeta.hasCustomModelData() ? Integer.valueOf(itemMeta.getCustomModelData()) : null;
        if (itemMeta.hasLore()) {
            this.lore = VersionUtil.isPaperServer() ? itemMeta.lore().stream().map(arg_0 -> ((MiniMessage)AdventureUtils.MINI_MESSAGE).serialize(arg_0)).toList() : itemMeta.getLore();
        }
        this.persistentDataContainer = itemMeta.getPersistentDataContainer();
        this.enchantments = new HashMap<Enchantment, Integer>();
        if (VersionUtil.atOrAbove("1.20.5")) {
            Damageable damageable;
            this.itemName = itemMeta.hasItemName() ? (VersionUtil.isPaperServer() ? (String)AdventureUtils.MINI_MESSAGE.serialize(itemMeta.itemName()) : itemMeta.getItemName()) : null;
            this.durability = itemMeta instanceof Damageable && (damageable = (Damageable)itemMeta).hasMaxDamage() ? Integer.valueOf(damageable.getMaxDamage()) : null;
            this.fireResistant = itemMeta.isFireResistant() ? Boolean.valueOf(true) : null;
            this.hideToolTip = itemMeta.isHideTooltip() ? Boolean.valueOf(true) : null;
            this.foodComponent = itemMeta.hasFood() ? itemMeta.getFood() : null;
            this.toolComponent = itemMeta.hasTool() ? itemMeta.getTool() : null;
            this.enchantmentGlintOverride = itemMeta.hasEnchantmentGlintOverride() ? itemMeta.getEnchantmentGlintOverride() : null;
            this.rarity = itemMeta.hasRarity() ? itemMeta.getRarity() : null;
            Integer n2 = this.maxStackSize = itemMeta.hasMaxStackSize() ? Integer.valueOf(itemMeta.getMaxStackSize()) : null;
            if (this.maxStackSize != null && this.maxStackSize == 1) {
                this.unstackable = true;
            }
        }
        if (VersionUtil.atOrAbove("1.21")) {
            JukeboxPlayableComponent jukeboxPlayableComponent = this.jukeboxPlayable = itemMeta.hasJukeboxPlayable() ? itemMeta.getJukeboxPlayable() : null;
        }
        if (VersionUtil.atOrAbove("1.21.2")) {
            this.equippableComponent = itemMeta.hasEquippable() ? itemMeta.getEquippable() : null;
            this.useCooldownComponent = itemMeta.hasUseCooldown() ? itemMeta.getUseCooldown() : null;
            this.useRemainder = itemMeta.hasUseRemainder() ? itemMeta.getUseRemainder() : null;
            this.damageResistant = itemMeta.hasDamageResistant() ? itemMeta.getDamageResistant() : null;
            this.itemModel = itemMeta.hasItemModel() ? itemMeta.getItemModel() : null;
            this.enchantable = itemMeta.hasEnchantable() ? Integer.valueOf(itemMeta.getEnchantable()) : null;
            this.isGlider = itemMeta.isGlider() ? Boolean.valueOf(true) : null;
        }
    }

    public Material getType() {
        return this.type;
    }

    public ItemBuilder setType(Material type) {
        this.type = type;
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        if (amount > this.type.getMaxStackSize()) {
            amount = this.type.getMaxStackSize();
        }
        this.amount = amount;
        return this;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    public ItemBuilder setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public boolean hasItemName() {
        return this.itemName != null;
    }

    @Nullable
    public String getItemName() {
        return this.itemName;
    }

    public ItemBuilder setItemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    public boolean hasLores() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public List<String> getLore() {
        return this.lore != null ? this.lore : new ArrayList<String>();
    }

    public ItemBuilder setLore(List<String> lore) {
        this.lore = lore;
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    public boolean isUnstackable() {
        return this.unstackable;
    }

    public ItemBuilder setUnstackable(boolean unstackable) {
        this.unstackable = unstackable;
        if (unstackable && VersionUtil.atOrAbove("1.20.5")) {
            this.maxStackSize = 1;
        }
        return this;
    }

    @Nullable
    public Integer getDurability() {
        return this.durability;
    }

    public ItemBuilder setDurability(@Nullable Integer durability) {
        this.durability = durability;
        return this;
    }

    public boolean isDamagedOnBlockBreak() {
        return this.damagedOnBlockBreak;
    }

    public void setDamagedOnBlockBreak(boolean damagedOnBlockBreak) {
        this.damagedOnBlockBreak = damagedOnBlockBreak;
    }

    public boolean isDamagedOnEntityHit() {
        return this.damagedOnEntityHit;
    }

    public void setDamagedOnEntityHit(boolean damagedOnEntityHit) {
        this.damagedOnEntityHit = damagedOnEntityHit;
    }

    public boolean hasColor() {
        return this.color != null && !this.color.equals((Object)Bukkit.getItemFactory().getDefaultLeatherColor());
    }

    public Color getColor() {
        return this.color;
    }

    public ItemBuilder setColor(Color color) {
        this.color = color;
        return this;
    }

    public boolean hasTrimPattern() {
        return VersionUtil.atOrAbove("1.20") && this.trimPattern != null && this.getTrimPattern() != null;
    }

    @Nullable
    public Key getTrimPatternKey() {
        if (!VersionUtil.atOrAbove("1.20")) {
            return null;
        }
        if (!Tag.ITEMS_TRIMMABLE_ARMOR.isTagged((Keyed)this.type)) {
            return null;
        }
        return this.trimPattern;
    }

    @Nullable
    public TrimPattern getTrimPattern() {
        if (!VersionUtil.atOrAbove("1.20")) {
            return null;
        }
        if (!Tag.ITEMS_TRIMMABLE_ARMOR.isTagged((Keyed)this.type)) {
            return null;
        }
        if (this.trimPattern == null) {
            return null;
        }
        NamespacedKey key = NamespacedKey.fromString((String)this.trimPattern.asString());
        if (key == null) {
            return null;
        }
        return (TrimPattern)Registry.TRIM_PATTERN.get(key);
    }

    public ItemBuilder setTrimPattern(Key trimKey) {
        if (!VersionUtil.atOrAbove("1.20")) {
            return this;
        }
        if (!Tag.ITEMS_TRIMMABLE_ARMOR.isTagged((Keyed)this.type)) {
            return this;
        }
        this.trimPattern = trimKey;
        return this;
    }

    public boolean hasItemModel() {
        return VersionUtil.atOrAbove("1.21.2") && this.itemModel != null;
    }

    @Nullable
    public NamespacedKey getItemModel() {
        return this.itemModel;
    }

    public ItemBuilder setItemModel(NamespacedKey itemModel) {
        this.itemModel = itemModel;
        return this;
    }

    public boolean hasTooltipStyle() {
        return VersionUtil.atOrAbove("1.21.2") && this.tooltipStyle != null;
    }

    public NamespacedKey getTooltipStyle() {
        return this.tooltipStyle;
    }

    public ItemBuilder setTooltipStyle(NamespacedKey tooltipStyle) {
        this.tooltipStyle = tooltipStyle;
        return this;
    }

    public boolean hasEnchantable() {
        return VersionUtil.atOrAbove("1.21.2") && this.enchantable != null;
    }

    @Nullable
    public Integer getEnchantable() {
        return this.enchantable;
    }

    public ItemBuilder setEnchantable(Integer enchantable) {
        this.enchantable = enchantable;
        return this;
    }

    public boolean hasDamageResistant() {
        return VersionUtil.atOrAbove("1.21.2") && this.damageResistant != null;
    }

    public Tag<DamageType> getDamageResistant() {
        return this.damageResistant;
    }

    public ItemBuilder setDamageResistant(Tag<DamageType> damageResistant) {
        this.damageResistant = damageResistant;
        return this;
    }

    public ItemBuilder setGlider(boolean glider) {
        this.isGlider = glider;
        return this;
    }

    public boolean hasUseRemainder() {
        return VersionUtil.atOrAbove("1.21.2") && this.useRemainder != null;
    }

    @Nullable
    public ItemStack getUseRemainder() {
        return this.useRemainder;
    }

    public ItemBuilder setUseRemainder(@Nullable ItemStack itemStack) {
        this.useRemainder = itemStack;
        return this;
    }

    public boolean hasUseCooldownComponent() {
        return VersionUtil.atOrAbove("1.21.2") && this.useCooldownComponent != null;
    }

    @Nullable
    public UseCooldownComponent getUseCooldownComponent() {
        return this.useCooldownComponent;
    }

    public ItemBuilder setUseCooldownComponent(@Nullable UseCooldownComponent useCooldownComponent) {
        this.useCooldownComponent = useCooldownComponent;
        return this;
    }

    public boolean hasEquippableComponent() {
        return VersionUtil.atOrAbove("1.21.2") && this.equippableComponent != null;
    }

    @Nullable
    public EquippableComponent getEquippableComponent() {
        return this.equippableComponent;
    }

    public ItemBuilder setEquippableComponent(@Nullable EquippableComponent equippableComponent) {
        this.equippableComponent = equippableComponent;
        return this;
    }

    public boolean hasFoodComponent() {
        return VersionUtil.atOrAbove("1.20.5") && this.foodComponent != null;
    }

    @Nullable
    public FoodComponent getFoodComponent() {
        return this.foodComponent;
    }

    public ItemBuilder setFoodComponent(@Nullable FoodComponent foodComponent) {
        this.foodComponent = foodComponent;
        return this;
    }

    public boolean hasConsumableComponent() {
        return VersionUtil.atOrAbove("1.21.2") && this.consumableComponent != null;
    }

    @Nullable
    public Object getConsumableComponent() {
        return this.consumableComponent;
    }

    public <V> ItemBuilder setConsumableComponent(@Nullable V consumableComponent) {
        this.consumableComponent = consumableComponent;
        return this;
    }

    public boolean hasToolComponent() {
        return VersionUtil.atOrAbove("1.20.5") && this.toolComponent != null;
    }

    @Nullable
    public ToolComponent getToolComponent() {
        return this.toolComponent;
    }

    public ItemBuilder setToolComponent(@Nullable ToolComponent toolComponent) {
        this.toolComponent = toolComponent;
        return this;
    }

    public boolean hasJukeboxPlayable() {
        return VersionUtil.atOrAbove("1.21") && this.jukeboxPlayable != null;
    }

    @Nullable
    public JukeboxPlayableComponent getJukeboxPlayable() {
        return this.jukeboxPlayable;
    }

    public ItemBuilder setJukeboxPlayable(@Nullable JukeboxPlayableComponent jukeboxPlayable) {
        this.jukeboxPlayable = jukeboxPlayable;
        return this;
    }

    public boolean hasEnchantmentGlindOverride() {
        return VersionUtil.atOrAbove("1.20.5") && this.enchantmentGlintOverride != null;
    }

    @Nullable
    public Boolean getEnchantmentGlindOverride() {
        return this.enchantmentGlintOverride;
    }

    public ItemBuilder setEnchantmentGlindOverride(@Nullable Boolean enchantmentGlintOverride) {
        this.enchantmentGlintOverride = enchantmentGlintOverride;
        return this;
    }

    public boolean hasRarity() {
        return VersionUtil.atOrAbove("1.20.5") && this.rarity != null;
    }

    @Nullable
    public ItemRarity getRarity() {
        return this.rarity;
    }

    public ItemBuilder setRarity(@Nullable ItemRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public ItemBuilder setFireResistant(boolean fireResistant) {
        this.fireResistant = fireResistant;
        return this;
    }

    public ItemBuilder setHideToolTip(boolean hideToolTip) {
        this.hideToolTip = hideToolTip;
        return this;
    }

    public boolean hasMaxStackSize() {
        return VersionUtil.atOrAbove("1.20.5") && this.maxStackSize != null;
    }

    @Nullable
    public Integer getMaxStackSize() {
        return this.maxStackSize;
    }

    public ItemBuilder setMaxStackSize(@Nullable Integer maxStackSize) {
        this.maxStackSize = maxStackSize;
        this.setUnstackable(maxStackSize != null && maxStackSize == 1);
        return this;
    }

    public ItemBuilder setBasePotionType(PotionType potionType) {
        this.potionType = potionType;
        return this;
    }

    public ItemBuilder addPotionEffect(PotionEffect potionEffect) {
        if (this.potionEffects == null) {
            this.potionEffects = new ArrayList<PotionEffect>();
        }
        this.potionEffects.add(potionEffect);
        return this;
    }

    public ItemBuilder setOwningPlayer(OfflinePlayer owningPlayer) {
        this.owningPlayer = owningPlayer;
        return this;
    }

    public <T, Z> ItemBuilder setCustomTag(NamespacedKey namespacedKey, PersistentDataType<T, Z> dataType, Z data) {
        this.persistentDataMap.put(new PersistentDataSpace<T, Z>(namespacedKey, dataType), data);
        return this;
    }

    public <T, Z> Z getCustomTag(NamespacedKey namespacedKey, PersistentDataType<T, Z> dataType) {
        for (Map.Entry<PersistentDataSpace, Object> dataSpace : this.persistentDataMap.entrySet()) {
            if (!dataSpace.getKey().namespacedKey().equals((Object)namespacedKey) || !dataSpace.getKey().dataType().equals(dataType)) continue;
            return (Z)dataSpace.getValue();
        }
        return null;
    }

    public boolean hasCustomTag() {
        return !this.persistentDataContainer.isEmpty();
    }

    public <T, Z> void addCustomTag(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        this.persistentDataMap.put(new PersistentDataSpace<T, Z>(key, type), value);
    }

    public ItemBuilder removeCustomTag(NamespacedKey key) {
        this.persistentDataContainer.remove(key);
        return this;
    }

    public ItemBuilder setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... itemFlags) {
        if (this.itemFlags == null) {
            this.itemFlags = new HashSet<ItemFlag>();
        }
        this.itemFlags.addAll(Arrays.asList(itemFlags));
        return this;
    }

    public List<ItemFlag> getItemFlags() {
        return this.itemFlags != null ? new ArrayList<ItemFlag>(this.itemFlags) : new ArrayList();
    }

    public ItemBuilder addAttributeModifiers(Attribute attribute, AttributeModifier attributeModifier) {
        if (!this.hasAttributeModifiers) {
            this.hasAttributeModifiers = true;
            this.attributeModifiers = HashMultimap.create();
        }
        this.attributeModifiers.put((Object)attribute, (Object)attributeModifier);
        return this;
    }

    public ItemBuilder addAllAttributeModifiers(Multimap<Attribute, AttributeModifier> attributeModifiers) {
        if (!this.hasAttributeModifiers) {
            this.hasAttributeModifiers = true;
        }
        this.attributeModifiers.putAll(attributeModifiers);
        return this;
    }

    public ItemBuilder setTropicalFishBucketBodyColor(DyeColor bodyColor) {
        this.bodyColor = bodyColor;
        return this;
    }

    public ItemBuilder setTropicalFishBucketPattern(TropicalFish.Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public ItemBuilder setTropicalFishBucketPatternColor(DyeColor patternColor) {
        this.patternColor = patternColor;
        return this;
    }

    public ItemBuilder addEnchant(Enchantment enchant, int level) {
        this.enchantments.put(enchant, level);
        return this;
    }

    public ItemBuilder addEnchants(Map<Enchantment, Integer> enchants) {
        for (Map.Entry<Enchantment, Integer> enchant : enchants.entrySet()) {
            this.addEnchant(enchant.getKey(), enchant.getValue());
        }
        return this;
    }

    public boolean hasOraxenMeta() {
        return this.oraxenMeta != null;
    }

    public OraxenMeta getOraxenMeta() {
        return this.oraxenMeta;
    }

    public ItemBuilder setOraxenMeta(OraxenMeta itemResources) {
        this.oraxenMeta = itemResources;
        return this;
    }

    public ItemStack getReferenceClone() {
        return this.itemStack.clone();
    }

    public ItemBuilder clone() {
        return new ItemBuilder(this.itemStack.clone());
    }

    public ItemBuilder regen() {
        ItemStack itemStack = this.itemStack;
        if (this.type != null) {
            itemStack.setType(this.type);
        }
        if (this.amount != itemStack.getAmount()) {
            itemStack.setAmount(this.amount);
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (VersionUtil.atOrAbove("1.20.5")) {
            if (itemMeta instanceof Damageable) {
                Damageable damageable = (Damageable)itemMeta;
                damageable.setMaxDamage(this.durability);
            }
            if (this.hasItemName()) {
                if (VersionUtil.isPaperServer()) {
                    itemMeta.itemName(AdventureUtils.MINI_MESSAGE.deserialize((Object)this.itemName));
                } else {
                    itemMeta.setItemName(this.itemName);
                }
            }
            if (this.hasMaxStackSize()) {
                itemMeta.setMaxStackSize(this.maxStackSize);
            }
            if (this.hasEnchantmentGlindOverride()) {
                itemMeta.setEnchantmentGlintOverride(this.enchantmentGlintOverride);
            }
            if (this.hasRarity()) {
                itemMeta.setRarity(this.rarity);
            }
            if (this.hasFoodComponent()) {
                itemMeta.setFood(this.foodComponent);
            }
            if (this.hasToolComponent()) {
                itemMeta.setTool(this.toolComponent);
            }
            if (this.fireResistant != null) {
                itemMeta.setFireResistant(this.fireResistant.booleanValue());
            }
            if (this.hideToolTip != null) {
                itemMeta.setHideTooltip(this.hideToolTip.booleanValue());
            }
        }
        if (VersionUtil.atOrAbove("1.21") && this.hasJukeboxPlayable()) {
            itemMeta.setJukeboxPlayable(this.jukeboxPlayable);
        }
        if (VersionUtil.atOrAbove("1.21.2")) {
            if (this.hasEquippableComponent()) {
                itemMeta.setEquippable(this.equippableComponent);
            }
            if (this.hasUseCooldownComponent()) {
                itemMeta.setUseCooldown(this.useCooldownComponent);
            }
            if (this.hasDamageResistant()) {
                itemMeta.setDamageResistant(this.damageResistant);
            }
            if (this.hasTooltipStyle()) {
                itemMeta.setTooltipStyle(this.tooltipStyle);
            }
            if (this.hasUseRemainder()) {
                itemMeta.setUseRemainder(this.useRemainder);
            }
            if (this.hasEnchantable()) {
                itemMeta.setEnchantable(this.enchantable);
            }
            if (this.itemModel != null) {
                itemMeta.setItemModel(this.itemModel);
            }
            if (this.isGlider != null) {
                itemMeta.setGlider(this.isGlider.booleanValue());
            }
        }
        this.handleVariousMeta(itemMeta);
        itemMeta.setUnbreakable(this.unbreakable);
        PersistentDataContainer pdc = itemMeta.getPersistentDataContainer();
        if (this.displayName != null) {
            if (!VersionUtil.atOrAbove("1.20.5")) {
                pdc.set(ORIGINAL_NAME_KEY, DataType.STRING, (Object)this.displayName);
            }
            if (VersionUtil.isPaperServer()) {
                Object displayName = AdventureUtils.MINI_MESSAGE.deserialize((Object)this.displayName);
                displayName = displayName.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE).colorIfAbsent((TextColor)NamedTextColor.WHITE);
                itemMeta.displayName((Component)displayName);
            } else {
                itemMeta.setDisplayName(this.displayName);
            }
        }
        if (this.itemFlags != null) {
            itemMeta.addItemFlags(this.itemFlags.toArray(new ItemFlag[0]));
        }
        if (this.enchantments.size() > 0) {
            for (Map.Entry entry : this.enchantments.entrySet()) {
                if (entry.getKey() == null) continue;
                int lvl = entry.getValue() != null ? (Integer)entry.getValue() : 1;
                itemMeta.addEnchant((Enchantment)entry.getKey(), lvl, true);
            }
        }
        if (this.hasAttributeModifiers) {
            itemMeta.setAttributeModifiers(this.attributeModifiers);
        }
        itemMeta.setCustomModelData(this.customModelData);
        if (!this.persistentDataMap.isEmpty()) {
            for (Map.Entry entry : this.persistentDataMap.entrySet()) {
                pdc.set(((PersistentDataSpace)entry.getKey()).namespacedKey(), ((PersistentDataSpace)entry.getKey()).dataType(), entry.getValue());
            }
        }
        if (VersionUtil.isPaperServer()) {
            List<Object> loreLines = this.lore != null ? this.lore.stream().map(arg_0 -> ((MiniMessage)AdventureUtils.MINI_MESSAGE).deserialize(arg_0)).toList() : new ArrayList();
            loreLines = loreLines.stream().map(c -> c.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE)).toList();
            itemMeta.lore(this.lore != null ? loreLines : null);
        } else {
            itemMeta.setLore(this.lore);
        }
        itemStack.setItemMeta(itemMeta);
        this.finalItemStack = NMSHandlers.getHandler().consumableComponent(itemStack, this.consumableComponent);
        return this;
    }

    public void save() {
        this.regen();
        OraxenItems.getMap().entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsValue(this)).findFirst().ifPresent(entry -> {
            block6: {
                YamlConfiguration yamlConfiguration = OraxenYaml.loadConfiguration((File)entry.getKey());
                String itemId = OraxenItems.getIdByItem(this);
                if (this.hasColor()) {
                    String color = this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue();
                    yamlConfiguration.set(itemId + ".color", (Object)color);
                }
                if (this.hasTrimPattern()) {
                    String trimPattern = this.getTrimPatternKey().asString();
                    yamlConfiguration.set(itemId + ".trim_pattern", (Object)trimPattern);
                }
                if (!this.getItemFlags().isEmpty()) {
                    yamlConfiguration.set(itemId + ".ItemFlags", this.itemFlags.stream().map(Enum::name).toList());
                }
                if (this.hasEquippableComponent()) {
                    yamlConfiguration.set(itemId + ".Components.equippable.slot", (Object)this.equippableComponent.getSlot().name());
                    yamlConfiguration.set(itemId + ".Components.equippable.model", (Object)this.equippableComponent.getModel().toString());
                }
                try {
                    yamlConfiguration.save((File)entry.getKey());
                }
                catch (IOException e) {
                    if (!Settings.DEBUG.toBool().booleanValue()) break block6;
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleVariousMeta(ItemMeta itemMeta) {
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            if (this.color != null && !this.color.equals((Object)leatherArmorMeta.getColor())) {
                leatherArmorMeta.setColor(this.color);
                return;
            }
        }
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            this.handlePotionMeta(potionMeta);
            return;
        }
        if (itemMeta instanceof MapMeta) {
            MapMeta mapMeta = (MapMeta)itemMeta;
            if (this.color != null && !this.color.equals((Object)mapMeta.getColor())) {
                mapMeta.setColor(this.color);
                return;
            }
        }
        if (itemMeta instanceof FireworkEffectMeta) {
            FireworkEffect.Builder fireWorkBuilder;
            FireworkEffectMeta effectMeta = (FireworkEffectMeta)itemMeta;
            if (effectMeta.clone().hasEffect()) {
                effectMeta.getEffect();
                v0 = FireworkEffect.builder();
            } else {
                v0 = fireWorkBuilder = FireworkEffect.builder();
            }
            if (this.color != null) {
                fireWorkBuilder.withColor(this.color);
            }
            try {
                effectMeta.setEffect(fireWorkBuilder.build());
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        if (VersionUtil.atOrAbove("1.20") && itemMeta instanceof ArmorMeta) {
            ArmorMeta armorMeta = (ArmorMeta)itemMeta;
            if (this.hasTrimPattern()) {
                armorMeta.setTrim(new ArmorTrim(TrimMaterial.REDSTONE, this.getTrimPattern()));
                return;
            }
        }
        if (itemMeta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            OfflinePlayer defaultOwningPlayer = skullMeta.getOwningPlayer();
            if (Objects.equals(this.owningPlayer, defaultOwningPlayer)) return;
            skullMeta.setOwningPlayer(this.owningPlayer);
            return;
        }
        if (!(itemMeta instanceof TropicalFishBucketMeta)) return;
        TropicalFishBucketMeta tropicalFishBucketMeta = (TropicalFishBucketMeta)itemMeta;
        if (!tropicalFishBucketMeta.hasVariant()) return;
        this.handleTropicalFishBucketMeta(tropicalFishBucketMeta);
    }

    private ItemMeta handlePotionMeta(PotionMeta potionMeta) {
        if (this.color != null && !this.color.equals((Object)potionMeta.getColor())) {
            potionMeta.setColor(this.color);
        }
        if (this.potionType != null && !this.potionType.equals((Object)PotionUtils.getPotionType(potionMeta))) {
            PotionUtils.setPotionType(potionMeta, this.potionType);
        }
        if (!this.potionEffects.equals(potionMeta.getCustomEffects())) {
            for (PotionEffect potionEffect : this.potionEffects) {
                potionMeta.addCustomEffect(potionEffect, true);
            }
        }
        return potionMeta;
    }

    private ItemMeta handleTropicalFishBucketMeta(TropicalFishBucketMeta tropicalFishBucketMeta) {
        DyeColor defaultPatternColor;
        TropicalFish.Pattern defaultPattern;
        DyeColor defaultColor = tropicalFishBucketMeta.getBodyColor();
        if (!this.bodyColor.equals((Object)defaultColor)) {
            tropicalFishBucketMeta.setBodyColor(this.bodyColor);
        }
        if (!this.pattern.equals((Object)(defaultPattern = tropicalFishBucketMeta.getPattern()))) {
            tropicalFishBucketMeta.setPattern(this.pattern);
        }
        if (!this.patternColor.equals((Object)(defaultPatternColor = tropicalFishBucketMeta.getPatternColor()))) {
            tropicalFishBucketMeta.setPatternColor(this.patternColor);
        }
        return tropicalFishBucketMeta;
    }

    public ItemStack[] buildArray(int amount) {
        ItemStack built = this.build();
        int max = this.hasMaxStackSize() ? this.maxStackSize : (this.type != null ? this.type.getMaxStackSize() : this.itemStack.getType().getMaxStackSize());
        int rest = max == amount ? amount : amount % max;
        int iterations = amount > max ? (amount - rest) / max : 0;
        ItemStack[] output = new ItemStack[iterations + (rest > 0 ? 1 : 0)];
        for (int index = 0; index < iterations; ++index) {
            ItemStack clone = built.clone();
            clone.setAmount(max);
            if (this.unstackable) {
                clone = this.handleUnstackable(clone);
            }
            output[index] = ItemUpdater.updateItem(clone);
        }
        if (rest != 0) {
            ItemStack clone = built.clone();
            clone.setAmount(rest);
            if (this.unstackable) {
                clone = this.handleUnstackable(clone);
            }
            output[iterations] = ItemUpdater.updateItem(clone);
        }
        return output;
    }

    public ItemStack build() {
        if (this.finalItemStack == null) {
            this.regen();
        }
        if (this.unstackable) {
            return this.handleUnstackable(this.finalItemStack);
        }
        return this.finalItemStack.clone();
    }

    private ItemStack handleUnstackable(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null || VersionUtil.atOrAbove("1.20.5")) {
            return item;
        }
        meta.getPersistentDataContainer().set(UNSTACKABLE_KEY, DataType.UUID, (Object)UUID.randomUUID());
        item.setItemMeta(meta);
        item.setAmount(1);
        return item;
    }

    public String toString() {
        return super.toString();
    }
}

