/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.texture;

import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.base.Writable;
import team.unnamed.creative.metadata.Metadata;
import team.unnamed.creative.texture.Texture;

final class TextureImpl
implements Texture {
    private final Key key;
    private final Writable data;
    private final Metadata meta;

    TextureImpl(@NotNull Key key, @NotNull Writable data, @NotNull Metadata meta) {
        this.key = Objects.requireNonNull(key, "key");
        this.data = Objects.requireNonNull(data, "data");
        this.meta = Objects.requireNonNull(meta, "meta");
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    @NotNull
    public Writable data() {
        return this.data;
    }

    @Override
    @NotNull
    public Metadata meta() {
        return this.meta;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"key", (Object)this.key), ExaminableProperty.of((String)"data", (Object)this.data), ExaminableProperty.of((String)"meta", (Object)this.meta));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextureImpl texture = (TextureImpl)o;
        return this.key.equals(texture.key) && this.data.equals(texture.data) && this.meta.equals(texture.meta);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.data, this.meta);
    }

    static final class BuilderImpl
    implements Texture.Builder {
        private Key key;
        private Writable data;
        private Metadata meta = Metadata.empty();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public Texture.Builder key(@NotNull Key key) {
            this.key = Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        @Nullable
        public Key key() {
            return this.key;
        }

        @Override
        @NotNull
        public Texture.Builder data(@NotNull Writable data) {
            this.data = Objects.requireNonNull(data, "data");
            return this;
        }

        @Override
        @Nullable
        public Writable data() {
            return this.data;
        }

        @Override
        @NotNull
        public Texture.Builder meta(@NotNull Metadata meta) {
            this.meta = Objects.requireNonNull(meta, "meta");
            return this;
        }

        @Override
        @NotNull
        public Metadata meta() {
            return this.meta;
        }

        @Override
        @NotNull
        public Texture build() {
            return new TextureImpl(this.key, this.data, this.meta);
        }
    }
}

