/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.animation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.metadata.MetadataPart;
import team.unnamed.creative.metadata.animation.AnimationFrame;
import team.unnamed.creative.metadata.animation.AnimationMetaImpl;

@ApiStatus.NonExtendable
public interface AnimationMeta
extends MetadataPart {
    public static final int DEFAULT_FRAMETIME = 1;
    public static final int DEFAULT_WIDTH = -1;
    public static final int DEFAULT_HEIGHT = -1;
    public static final boolean DEFAULT_INTERPOLATE = false;

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static AnimationMeta animation(boolean interpolate, int width, int height, int frameTime, @NotNull List<AnimationFrame> frames) {
        return new AnimationMetaImpl(interpolate, width, height, frameTime, frames);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static AnimationMeta of(boolean interpolate, int width, int height, int frameTime, @NotNull List<AnimationFrame> frames) {
        return AnimationMeta.animation(interpolate, width, height, frameTime, frames);
    }

    @Contract(value="-> new")
    @NotNull
    public static Builder animation() {
        return new AnimationMetaImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @Contract(value="-> new")
    @NotNull
    public static Builder builder() {
        return AnimationMeta.animation();
    }

    public boolean interpolate();

    public int width();

    public int height();

    public int frameTime();

    @NotNull
    public @Unmodifiable List<AnimationFrame> frames();

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder interpolate(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder width(int var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder height(int var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder frameTime(int var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder frames(@NotNull List<AnimationFrame> var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder frames(AnimationFrame ... frames) {
            Objects.requireNonNull(frames, "frames");
            return this.frames(Arrays.asList(frames));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder frames(int ... indexes) {
            Objects.requireNonNull(indexes, "indexes");
            ArrayList<AnimationFrame> frames = new ArrayList<AnimationFrame>();
            for (int index : indexes) {
                frames.add(AnimationFrame.frame(index));
            }
            return this.frames(frames);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder addFrame(@NotNull AnimationFrame var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder addFrame(int index) {
            return this.addFrame(AnimationFrame.frame(index));
        }

        @Contract(value="_, _ -> this")
        @NotNull
        default public Builder addFrame(int index, int frameTime) {
            return this.addFrame(AnimationFrame.frame(index, frameTime));
        }

        @Contract(value="-> new")
        @NotNull
        public AnimationMeta build();
    }
}

