/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.atlas;

import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.atlas.AtlasImpl;
import team.unnamed.creative.atlas.AtlasSource;
import team.unnamed.creative.overlay.ResourceContainer;
import team.unnamed.creative.part.ResourcePackPart;

@ApiStatus.NonExtendable
public interface Atlas
extends ResourcePackPart,
Keyed,
Examinable {
    public static final Key BLOCKS = Key.key((String)"blocks");
    public static final Key BANNER_PATTERNS = Key.key((String)"banner_patterns");
    public static final Key BEDS = Key.key((String)"beds");
    public static final Key CHESTS = Key.key((String)"chests");
    public static final Key SHIELD_PATTERNS = Key.key((String)"shield_patterns");
    public static final Key SHULKER_BOXES = Key.key((String)"shulker_boxes");
    public static final Key SIGNS = Key.key((String)"signs");
    public static final Key MOB_EFFECTS = Key.key((String)"mob_effects");
    public static final Key PAINTINGS = Key.key((String)"paintings");
    public static final Key PARTICLES = Key.key((String)"particles");
    public static final Key ARMOR_TRIMS = Key.key((String)"armor_trims");
    public static final Key DECORATED_POT = Key.key((String)"decorated_pot");
    public static final Key GUI = Key.key((String)"gui");

    @NotNull
    public Key key();

    public @Unmodifiable @NotNull List<AtlasSource> sources();

    @Contract(value="-> new")
    @NotNull
    public Builder toBuilder();

    @Override
    default public void addTo(@NotNull ResourceContainer resourceContainer) {
        resourceContainer.atlas(this);
    }

    @NotNull
    public static Atlas atlas(@NotNull Key key, @NotNull List<AtlasSource> sources) {
        return new AtlasImpl(key, sources);
    }

    @NotNull
    public static Builder atlas() {
        return new AtlasImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Atlas of(@NotNull Key key, @NotNull List<AtlasSource> sources) {
        return new AtlasImpl(key, sources);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Builder builder() {
        return new AtlasImpl.BuilderImpl();
    }

    public static interface Builder {
        @Nullable
        public Key key();

        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull Key var1);

        @Nullable
        public List<AtlasSource> sources();

        @Contract(value="_ -> this")
        @NotNull
        public Builder sources(@NotNull List<AtlasSource> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder sources(AtlasSource ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder addSource(@NotNull AtlasSource var1);

        @Contract(value="-> new")
        @NotNull
        public Atlas build();
    }
}

