/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.items;

import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class OraxenMeta {
    private int customModelData;
    private String modelName;
    private String blockingModel;
    private String blockingTexture;
    private List<String> pullingModels;
    private List<String> pullingTextures;
    private String chargedModel;
    private String chargedTexture;
    private String fireworkModel;
    private String fireworkTexture;
    private String castModel;
    private String castTexture;
    private List<String> damagedModels;
    private List<String> damagedTextures;
    private List<String> layers;
    private Map<String, String> layersMap;
    private String parentModel;
    private String generatedModelPath;
    private boolean generate_model;
    private boolean hasPackInfos = false;
    private boolean excludedFromInventory = false;
    private boolean excludedFromCommands = false;
    private boolean noUpdate = false;
    private boolean disableEnchanting = false;

    public void setExcludedFromInventory(boolean excluded) {
        this.excludedFromInventory = excluded;
    }

    public boolean isExcludedFromInventory() {
        return this.excludedFromInventory;
    }

    public void setExcludedFromCommands(boolean excluded) {
        this.excludedFromCommands = excluded;
    }

    public boolean isExcludedFromCommands() {
        return this.excludedFromCommands;
    }

    public void setPackInfos(ConfigurationSection section) {
        this.hasPackInfos = true;
        this.modelName = this.readModelName(section, "model");
        this.blockingModel = this.readModelName(section, "blocking_model");
        this.castModel = this.readModelName(section, "cast_model");
        this.chargedModel = this.readModelName(section, "charged_model");
        this.fireworkModel = this.readModelName(section, "firework_model");
        this.pullingModels = section.isList("pulling_models") ? section.getStringList("pulling_models") : null;
        List<String> list = this.damagedModels = section.isList("damaged_models") ? section.getStringList("damaged_models") : null;
        if (this.pullingModels == null && section.isList("pulling_textures")) {
            this.pullingTextures = section.getStringList("pulling_textures").stream().map(texture -> texture.replace(".png", "")).toList();
            this.pullingModels = this.pullingTextures;
        }
        if (this.chargedModel == null && section.isString("charged_texture")) {
            this.chargedModel = this.chargedTexture = section.getString("charged_texture").replace(".png", "");
        }
        if (this.fireworkModel == null && section.isString("firework_texture")) {
            this.fireworkModel = this.fireworkTexture = section.getString("firework_texture").replace(".png", "");
        }
        if (this.castModel == null && section.isString("cast_texture")) {
            this.castModel = this.castTexture = section.getString("cast_texture").replace(".png", "");
        }
        if (this.blockingModel == null && section.isString("blocking_texture")) {
            this.blockingModel = this.blockingTexture = section.getString("blocking_texture").replace(".png", "");
        }
        if (this.damagedModels == null && section.isList("damaged_textures")) {
            this.damagedTextures = section.getStringList("damaged_textures").stream().map(texture -> texture.replace(".png", "")).toList();
            this.damagedModels = this.damagedTextures;
        }
        if (section.isList("textures")) {
            this.layers = section.getStringList("textures");
            ArrayList<String> layers = new ArrayList<String>();
            this.layers.forEach(layer -> layers.add(this.layers.indexOf(layer), layer.replace(".png", "")));
            this.layers = layers;
        } else if (section.isConfigurationSection("textures")) {
            ConfigurationSection texturesSection = section.getConfigurationSection("textures");
            assert (texturesSection != null);
            HashMap<String, String> layersMap = new HashMap<String, String>();
            texturesSection.getKeys(false).forEach(key -> layersMap.put((String)key, texturesSection.getString(key).replace(".png", "")));
            this.layersMap = layersMap;
        }
        this.generate_model = section.getBoolean("generate_model", this.modelName.isEmpty());
        this.generatedModelPath = section.getString("generated_model_path", "");
        this.parentModel = section.getString("parent_model", "item/generated");
        if (this.generate_model && !this.modelName.matches("^[a-z0-9-_/]+$")) {
            Logs.logWarning("Item " + section.getParent().getName() + " is set to generate a model, but ItemID does not adhere to [a-z0-9-_]!");
            Logs.logWarning("This will generate a malformed model!");
        }
    }

    private String readModelName(ConfigurationSection configSection, String configString) {
        String modelName = configSection.getString(configString);
        List textures = configSection.getStringList("textures");
        ConfigurationSection parent = configSection.getParent();
        String string = modelName != null ? modelName : (modelName = Settings.GENERATE_MODEL_BASED_ON_TEXTURE_PATH.toBool() != false && !textures.isEmpty() && parent != null ? Utils.getParentDirs((String)textures.stream().findFirst().get()) + parent.getName() : null);
        if (modelName == null && configString.equals("model") && parent != null) {
            return parent.getName();
        }
        if (modelName != null) {
            return modelName.replace(".json", "");
        }
        return null;
    }

    public boolean hasPackInfos() {
        return this.hasPackInfos;
    }

    public OraxenMeta setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
        return this;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public OraxenMeta setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    public OraxenMeta setNoUpdate(boolean noUpdate) {
        this.noUpdate = noUpdate;
        return this;
    }

    public void setDisableEnchanting(boolean disableEnchanting) {
        this.disableEnchanting = disableEnchanting;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelPath() {
        String[] pathElements = this.generatedModelPath.split(":");
        Object path = pathElements.length > 1 ? "assets/" + pathElements[0] + "/models/" + pathElements[1] : "assets/minecraft/models/" + pathElements[0];
        if (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        return path;
    }

    public static String getModelPath(String model) {
        String[] pathElements = model.split(":");
        Object path = pathElements.length > 1 ? "assets/" + pathElements[0] + "/models/" + pathElements[1] : "assets/minecraft/models/" + pathElements[0];
        if (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        return path;
    }

    public boolean hasBlockingModel() {
        return this.blockingModel != null;
    }

    public String getBlockingModel() {
        return this.blockingModel;
    }

    public boolean hasBlockingTexture() {
        return this.blockingTexture != null;
    }

    public String getBlockingTexture() {
        return this.blockingTexture;
    }

    public boolean hasCastModel() {
        return this.castModel != null;
    }

    public String getCastModel() {
        return this.castModel;
    }

    public boolean hasCastTexture() {
        return this.castTexture != null;
    }

    public String getCastTexture() {
        return this.castTexture;
    }

    public boolean hasChargedModel() {
        return this.chargedModel != null;
    }

    public String getChargedModel() {
        return this.chargedModel;
    }

    public boolean hasChargedTexture() {
        return this.chargedTexture != null;
    }

    public String getChargedTexture() {
        return this.chargedTexture;
    }

    public boolean hasFireworkModel() {
        return this.fireworkModel != null;
    }

    public String getFireworkModel() {
        return this.fireworkModel;
    }

    public boolean hasFireworkTexture() {
        return this.fireworkTexture != null;
    }

    public String getFireworkTexture() {
        return this.fireworkTexture;
    }

    public boolean hasPullingModels() {
        return this.pullingModels != null && !this.pullingModels.isEmpty();
    }

    public List<String> getPullingModels() {
        return this.pullingModels;
    }

    public boolean hasPullingTextures() {
        return this.pullingTextures != null && !this.pullingTextures.isEmpty();
    }

    public List<String> getPullingTextures() {
        return this.pullingTextures;
    }

    public boolean hasDamagedModels() {
        return this.damagedModels != null && !this.damagedModels.isEmpty();
    }

    public List<String> getDamagedModels() {
        return this.damagedModels;
    }

    public boolean hasDamagedTextures() {
        return this.damagedTextures != null && !this.damagedTextures.isEmpty();
    }

    public List<String> getDamagedTextures() {
        return this.damagedTextures;
    }

    public boolean hasLayers() {
        return this.layers != null && !this.layers.isEmpty();
    }

    public List<String> getLayers() {
        return this.layers != null ? this.layers : new ArrayList<String>();
    }

    public boolean hasLayersMap() {
        return this.layersMap != null && !this.layersMap.isEmpty();
    }

    public Map<String, String> getLayersMap() {
        return this.layersMap;
    }

    public String getParentModel() {
        return this.parentModel;
    }

    public String getGeneratedModelPath() {
        if (this.generatedModelPath.isEmpty()) {
            return this.generatedModelPath;
        }
        return this.generatedModelPath + (this.generatedModelPath.endsWith("/") ? "" : "/");
    }

    public boolean shouldGenerateModel() {
        return this.generate_model;
    }

    public boolean isNoUpdate() {
        return this.noUpdate;
    }

    public boolean isDisableEnchanting() {
        return this.disableEnchanting;
    }
}

