/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.api;

import com.jeff_media.morepersistentdatatypes.DataType;
import com.jeff_media.persistentdataserializer.PersistentDataSerializer;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.BlockLocation;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.storage.StorageMechanic;
import io.th0rgal.oraxen.mechanics.provided.misc.music_disc.MusicDiscListener;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.drops.Drop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.GameEvent;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Rotation;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraxenFurniture {
    public static Set<String> getFurnitureIDs() {
        return Arrays.stream(OraxenItems.getItemNames()).filter(OraxenFurniture::isFurniture).collect(Collectors.toSet());
    }

    public static boolean isFurniture(Block block) {
        BoundingBox blockBox = BoundingBox.of((Location)BlockHelpers.toCenterLocation(block.getLocation()), (double)0.5, (double)0.5, (double)0.5);
        return block.getType() == Material.BARRIER && OraxenFurniture.getFurnitureMechanic(block) != null || !block.getWorld().getNearbyEntities(blockBox).stream().filter(OraxenFurniture::isFurniture).toList().isEmpty();
    }

    public static boolean isFurniture(String itemID) {
        return FurnitureFactory.isEnabled() && !FurnitureFactory.getInstance().isNotImplementedIn(itemID);
    }

    public static boolean isFurniture(Entity entity) {
        return entity != null && OraxenFurniture.getFurnitureMechanic(entity) != null;
    }

    public static boolean isBaseEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(entity);
        return mechanic != null && (!OraxenPlugin.supportsDisplayEntities || entity.getType() != EntityType.INTERACTION);
    }

    public static boolean isInteractionEntity(@NotNull Entity entity) {
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(entity);
        return mechanic != null && OraxenPlugin.supportsDisplayEntities && entity.getType() == EntityType.INTERACTION;
    }

    @Nullable
    public static Entity place(String itemID, Location location, Rotation rotation, BlockFace blockFace) {
        return OraxenFurniture.place(itemID, location, FurnitureMechanic.rotationToYaw(rotation), blockFace);
    }

    @Nullable
    public static Entity place(String itemID, Location location, float yaw, BlockFace blockFace) {
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(itemID);
        if (mechanic == null) {
            return null;
        }
        return mechanic.place(location, Float.valueOf(yaw), blockFace);
    }

    @Deprecated(since="1.162.0", forRemoval=true)
    public static boolean place(Location location, String itemID, Rotation rotation, BlockFace blockFace) {
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(itemID);
        if (mechanic == null) {
            return false;
        }
        return mechanic.place(location, Float.valueOf(FurnitureMechanic.rotationToYaw(rotation)), blockFace) != null;
    }

    public static boolean remove(@NotNull Location location, @Nullable Player player) {
        return OraxenFurniture.remove(location, player, null);
    }

    public static boolean remove(@NotNull Location location, @Nullable Player player, @Nullable Drop drop) {
        ItemStack itemStack;
        if (!FurnitureFactory.isEnabled()) {
            return false;
        }
        if (!location.isWorldLoaded()) {
            return false;
        }
        assert (location.getWorld() != null);
        Entity entity = location.getWorld().getNearbyEntities(location, 0.5, 0.5, 0.5).stream().filter(OraxenFurniture::isFurniture).findFirst().orElse(null);
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(location.getBlock());
        mechanic = mechanic != null ? mechanic : (entity != null ? OraxenFurniture.getFurnitureMechanic(entity) : null);
        ItemStack itemStack2 = itemStack = player != null ? player.getInventory().getItemInMainHand() : new ItemStack(Material.AIR);
        if (mechanic == null) {
            return false;
        }
        assert (entity != null);
        Entity baseEntity = mechanic.getBaseEntity(location.getBlock());
        Entity entity2 = baseEntity = baseEntity != null ? baseEntity : mechanic.getBaseEntity(entity);
        if (baseEntity == null) {
            return false;
        }
        if (player != null) {
            StorageMechanic storage;
            if (player.getGameMode() != GameMode.CREATIVE) {
                (drop != null ? drop : mechanic.getDrop()).furnitureSpawns(baseEntity, itemStack);
            }
            if ((storage = mechanic.getStorage()) != null && (storage.isStorage() || storage.isShulker())) {
                storage.dropStorageContent(mechanic, baseEntity);
            }
            if (VersionUtil.isPaperServer()) {
                baseEntity.getWorld().sendGameEvent((Entity)player, GameEvent.BLOCK_DESTROY, baseEntity.getLocation().toVector());
            }
        }
        if (mechanic.hasBarriers()) {
            mechanic.removeSolid(baseEntity, baseEntity.getLocation(), FurnitureMechanic.getFurnitureYaw(baseEntity));
        } else {
            mechanic.removeNonSolidFurniture(baseEntity);
        }
        return true;
    }

    public static boolean remove(Entity baseEntity, @Nullable Player player) {
        return OraxenFurniture.remove(baseEntity, player, null);
    }

    public static boolean remove(Entity baseEntity, @Nullable Player player, @Nullable Drop drop) {
        if (!FurnitureFactory.isEnabled() || baseEntity == null) {
            return false;
        }
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(baseEntity);
        if (mechanic == null) {
            return false;
        }
        if (OraxenFurniture.isInteractionEntity(baseEntity)) {
            baseEntity = mechanic.getBaseEntity(baseEntity);
        }
        if (baseEntity == null) {
            return false;
        }
        if (player != null) {
            StorageMechanic storage;
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (player.getGameMode() != GameMode.CREATIVE) {
                (drop != null ? drop : mechanic.getDrop()).furnitureSpawns(baseEntity, itemStack);
            }
            if ((storage = mechanic.getStorage()) != null && (storage.isStorage() || storage.isShulker())) {
                storage.dropStorageContent(mechanic, baseEntity);
            }
            if (VersionUtil.isPaperServer()) {
                baseEntity.getWorld().sendGameEvent((Entity)player, GameEvent.BLOCK_DESTROY, baseEntity.getLocation().toVector());
            }
        }
        if (mechanic.hasBarriers(baseEntity)) {
            mechanic.removeSolid(baseEntity, baseEntity.getLocation(), FurnitureMechanic.getFurnitureYaw(baseEntity));
        } else {
            mechanic.removeNonSolidFurniture(baseEntity);
        }
        return true;
    }

    @Nullable
    public static FurnitureMechanic getFurnitureMechanic(Block block) {
        if (!FurnitureFactory.isEnabled() || block == null) {
            return null;
        }
        if (block.getType() != Material.BARRIER) {
            return null;
        }
        String mechanicID = (String)BlockHelpers.getPDC(block).get(FurnitureMechanic.FURNITURE_KEY, PersistentDataType.STRING);
        return FurnitureFactory.getInstance().getMechanic(mechanicID);
    }

    public static FurnitureMechanic getFurnitureMechanic(Entity entity) {
        if (!FurnitureFactory.isEnabled() || entity == null) {
            return null;
        }
        String itemID = (String)entity.getPersistentDataContainer().get(FurnitureMechanic.FURNITURE_KEY, PersistentDataType.STRING);
        if (!OraxenItems.exists(itemID)) {
            return null;
        }
        return FurnitureFactory.getInstance().getMechanic(itemID);
    }

    public static FurnitureMechanic getFurnitureMechanic(String itemID) {
        if (!FurnitureFactory.isEnabled() || !OraxenItems.exists(itemID)) {
            return null;
        }
        return FurnitureFactory.getInstance().getMechanic(itemID);
    }

    public static void updateFurniture(@NotNull Entity entity) {
        if (!FurnitureFactory.isEnabled()) {
            return;
        }
        if (!BlockHelpers.isLoaded(entity.getLocation())) {
            return;
        }
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(entity);
        if (mechanic == null) {
            return;
        }
        if ((entity = mechanic.getBaseEntity(entity)) == null) {
            return;
        }
        ItemStack oldItem = FurnitureMechanic.getFurnitureItem(entity);
        ItemStack newItem = ItemUpdater.updateItem(oldItem);
        FurnitureMechanic.setFurnitureItem(entity, newItem);
        if (Settings.EXPERIMENTAL_FURNITURE_TYPE_UPDATE.toBool().booleanValue()) {
            BlockFace oldFacing;
            PersistentDataContainer oldPdc = entity.getPersistentDataContainer();
            if (entity instanceof ItemFrame) {
                ItemFrame itemFrame = (ItemFrame)entity;
                v0 = itemFrame.getAttachedFace();
            } else {
                v0 = oldFacing = BlockFace.UP;
            }
            if (entity.getType() == mechanic.getFurnitureEntityType() && mechanic.getBarriers().equals(oldPdc.getOrDefault(FurnitureMechanic.BARRIER_KEY, (PersistentDataType)DataType.asList(BlockLocation.dataType), new ArrayList()))) {
                if (OraxenPlugin.supportsDisplayEntities) {
                    Interaction interaction = mechanic.getInteractionEntity(entity);
                    if (interaction != null && mechanic.hasHitbox() && interaction.getInteractionWidth() == mechanic.getHitbox().width() && interaction.getInteractionHeight() == mechanic.getHitbox().height() && oldPdc.has(FurnitureMechanic.SEAT_KEY, DataType.UUID) && mechanic.hasSeat() && mechanic.hasDisplayEntityProperties() && mechanic.getDisplayEntityProperties().ensureSameDisplayProperties(entity)) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if (!OraxenFurniture.remove(entity, null)) {
                return;
            }
            Entity newEntity = mechanic.place(entity.getLocation(), newItem, Float.valueOf(FurnitureMechanic.getFurnitureYaw(entity)), oldFacing, true);
            if (newEntity == null) {
                return;
            }
            List serializedPdc = PersistentDataSerializer.toMapList((PersistentDataContainer)oldPdc);
            serializedPdc.removeIf(map -> Stream.of(MusicDiscListener.MUSIC_DISC_KEY, FurnitureMechanic.EVOLUTION_KEY, StorageMechanic.STORAGE_KEY, StorageMechanic.PERSONAL_STORAGE_KEY).map(NamespacedKey::toString).noneMatch(map::containsValue));
            PersistentDataSerializer.fromMapList((List)serializedPdc, (PersistentDataContainer)newEntity.getPersistentDataContainer());
        }
    }
}

