/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.sound;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.intellij.lang.annotations.Pattern;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.sound.SoundEvent;
import team.unnamed.creative.sound.SoundRegistry;
import team.unnamed.creative.util.Keys;

final class SoundRegistryImpl
implements SoundRegistry {
    @Subst(value="minecraft")
    private final String namespace;
    private final Map<Key, SoundEvent> sounds;

    SoundRegistryImpl(@NotNull String namespace, @NotNull Collection<SoundEvent> sounds) {
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        Objects.requireNonNull(sounds, "sounds");
        this.sounds = new LinkedHashMap<Key, SoundEvent>();
        for (SoundEvent soundEvent : sounds) {
            this.sounds.put(soundEvent.key(), soundEvent);
        }
        this.validate();
    }

    private void validate() {
        Keys.validateNamespace(this.namespace);
        for (Key key : this.sounds.keySet()) {
            if (key.namespace().equals(this.namespace)) continue;
            throw new IllegalArgumentException("Sound events can't have a namespace different from the sound registry namespace!");
        }
    }

    @Override
    @Pattern(value="[a-z0-9_\\-.]+")
    @NotNull
    public String namespace() {
        return this.namespace;
    }

    @Override
    public @Unmodifiable @NotNull Collection<SoundEvent> sounds() {
        return this.sounds.values();
    }

    @Override
    @Nullable
    public SoundEvent sound(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.sounds.get(key);
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"namespace", (String)this.namespace), ExaminableProperty.of((String)"sounds", this.sounds));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoundRegistryImpl that = (SoundRegistryImpl)o;
        return this.namespace.equals(that.namespace) && this.sounds.equals(that.sounds);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.sounds);
    }

    static final class BuilderImpl
    implements SoundRegistry.Builder {
        private String namespace;
        private Set<SoundEvent> sounds;

        BuilderImpl() {
        }

        @Override
        @NotNull
        public SoundRegistry.Builder namespace(@NotNull String namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            return this;
        }

        @Override
        @NotNull
        public SoundRegistry.Builder sound(@NotNull SoundEvent event) {
            Objects.requireNonNull(event, "event");
            if (this.sounds == null) {
                this.sounds = new LinkedHashSet<SoundEvent>();
            }
            this.sounds.add(event);
            return this;
        }

        @Override
        @NotNull
        public SoundRegistry.Builder sounds(@NotNull Collection<? extends SoundEvent> sounds) {
            Objects.requireNonNull(sounds, "sounds");
            this.sounds = new LinkedHashSet<SoundEvent>(sounds);
            return this;
        }

        @Override
        @NotNull
        public SoundRegistry build() {
            return new SoundRegistryImpl(this.namespace, this.sounds);
        }
    }
}

