/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.overlay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.atlas.Atlas;
import team.unnamed.creative.atlas.AtlasSource;
import team.unnamed.creative.base.Writable;
import team.unnamed.creative.blockstate.BlockState;
import team.unnamed.creative.font.Font;
import team.unnamed.creative.font.FontProvider;
import team.unnamed.creative.lang.Language;
import team.unnamed.creative.model.ItemOverride;
import team.unnamed.creative.model.Model;
import team.unnamed.creative.overlay.ResourceContainer;
import team.unnamed.creative.resources.MergeException;
import team.unnamed.creative.resources.MergeStrategy;
import team.unnamed.creative.sound.Sound;
import team.unnamed.creative.sound.SoundEvent;
import team.unnamed.creative.sound.SoundRegistry;
import team.unnamed.creative.texture.Texture;

@ApiStatus.Internal
public class ResourceContainerImpl
implements ResourceContainer {
    private final Map<Key, Atlas> atlases = new LinkedHashMap<Key, Atlas>();
    private final Map<Key, BlockState> blockStates = new LinkedHashMap<Key, BlockState>();
    private final Map<Key, Font> fonts = new LinkedHashMap<Key, Font>();
    private final Map<Key, Language> languages = new LinkedHashMap<Key, Language>();
    private final Map<Key, Model> models = new LinkedHashMap<Key, Model>();
    private final Map<String, SoundRegistry> soundRegistries = new LinkedHashMap<String, SoundRegistry>();
    private final Map<Key, Sound> sounds = new LinkedHashMap<Key, Sound>();
    private final Map<Key, Texture> textures = new LinkedHashMap<Key, Texture>();
    private final Map<String, Writable> files = new LinkedHashMap<String, Writable>();

    @Override
    public void atlas(@NotNull Atlas atlas) {
        Objects.requireNonNull(atlas, "atlas");
        this.atlases.put(atlas.key(), atlas);
    }

    @Override
    @Nullable
    public Atlas atlas(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.atlases.get(key);
    }

    @Override
    public boolean removeAtlas(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.atlases.remove(key) != null;
    }

    @Override
    @NotNull
    public Collection<Atlas> atlases() {
        return this.atlases.values();
    }

    @Override
    public void blockState(@NotNull BlockState state) {
        Objects.requireNonNull(state, "state");
        this.blockStates.put(state.key(), state);
    }

    @Override
    @Nullable
    public BlockState blockState(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.blockStates.get(key);
    }

    @Override
    public boolean removeBlockState(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.blockStates.remove(key) != null;
    }

    @Override
    @NotNull
    public Collection<BlockState> blockStates() {
        return this.blockStates.values();
    }

    @Override
    public void font(@NotNull Font font) {
        Objects.requireNonNull(font, "font");
        this.fonts.put(font.key(), font);
    }

    @Override
    @Nullable
    public Font font(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.fonts.get(key);
    }

    @Override
    public boolean removeFont(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.fonts.remove(key) != null;
    }

    @Override
    @NotNull
    public Collection<Font> fonts() {
        return this.fonts.values();
    }

    @Override
    public void language(@NotNull Language language) {
        Objects.requireNonNull(language, "language");
        this.languages.put(language.key(), language);
    }

    @Override
    @Nullable
    public Language language(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.languages.get(key);
    }

    @Override
    public boolean removeLanguage(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.languages.remove(key) != null;
    }

    @Override
    @NotNull
    public Collection<Language> languages() {
        return this.languages.values();
    }

    @Override
    public void model(@NotNull Model model) {
        Objects.requireNonNull(model, "model");
        this.models.put(model.key(), model);
    }

    @Override
    @Nullable
    public Model model(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.models.get(key);
    }

    @Override
    public boolean removeModel(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.models.remove(key) != null;
    }

    @Override
    @NotNull
    public Collection<Model> models() {
        return this.models.values();
    }

    @Override
    public void soundRegistry(@NotNull SoundRegistry soundRegistry) {
        Objects.requireNonNull(soundRegistry, "soundRegistry");
        this.soundRegistries.put(soundRegistry.namespace(), soundRegistry);
    }

    @Override
    @Nullable
    public SoundRegistry soundRegistry(@NotNull String namespace) {
        Objects.requireNonNull(namespace, "namespace");
        return this.soundRegistries.get(namespace);
    }

    @Override
    public boolean removeSoundRegistry(@NotNull String namespace) {
        Objects.requireNonNull(namespace, "namespace");
        return this.soundRegistries.remove(namespace) != null;
    }

    @Override
    @NotNull
    public Collection<SoundRegistry> soundRegistries() {
        return this.soundRegistries.values();
    }

    @Override
    public void sound(@NotNull Sound sound) {
        Objects.requireNonNull(sound, "sound");
        this.sounds.put(sound.key(), sound);
    }

    @Override
    @Nullable
    public Sound sound(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.sounds.get(key);
    }

    @Override
    public boolean removeSound(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.sounds.remove(key) != null;
    }

    @Override
    @NotNull
    public Collection<Sound> sounds() {
        return this.sounds.values();
    }

    @Override
    public void texture(@NotNull Texture texture) {
        Objects.requireNonNull(texture, "textures");
        this.textures.put(texture.key(), texture);
    }

    @Override
    @Nullable
    public Texture texture(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.textures.get(key);
    }

    @Override
    public boolean removeTexture(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return this.textures.remove(key) != null;
    }

    @Override
    @NotNull
    public Collection<Texture> textures() {
        return this.textures.values();
    }

    @Override
    public void unknownFile(@NotNull String path, @NotNull Writable data) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(data, "data");
        this.files.put(path, data);
    }

    @Override
    @Nullable
    public Writable unknownFile(@NotNull String path) {
        Objects.requireNonNull(path, "path");
        return this.files.get(path);
    }

    @Override
    public boolean removeUnknownFile(@NotNull String path) {
        Objects.requireNonNull(path, "path");
        return this.files.remove(path) != null;
    }

    @Override
    @NotNull
    public Map<String, Writable> unknownFiles() {
        return this.files;
    }

    @Override
    public void merge(@NotNull ResourceContainer other, @NotNull MergeStrategy strategy) {
        boolean override = strategy == MergeStrategy.override();
        for (Atlas atlas : other.atlases()) {
            Atlas oldAtlas = this.atlases.get(atlas.key());
            if (oldAtlas == null || override) {
                this.atlases.put(atlas.key(), atlas);
                continue;
            }
            LinkedHashSet<AtlasSource> sources = new LinkedHashSet<AtlasSource>(oldAtlas.sources());
            sources.addAll(atlas.sources());
            this.atlases.put(atlas.key(), oldAtlas.toBuilder().sources(new ArrayList<AtlasSource>(sources)).build());
        }
        for (BlockState blockState : other.blockStates()) {
            if (this.blockStates.containsKey(blockState.key())) {
                if (strategy == MergeStrategy.override()) {
                    this.blockStates.put(blockState.key(), blockState);
                    continue;
                }
                if (strategy != MergeStrategy.mergeAndFailOnError()) continue;
                throw new MergeException("Duplicate block state '" + blockState.key() + "': exists in both resource containers");
            }
            this.blockStates.put(blockState.key(), blockState);
        }
        for (Font font : other.fonts()) {
            Font oldFont = this.fonts.get(font.key());
            if (oldFont == null || override) {
                this.fonts.put(font.key(), font);
                continue;
            }
            ArrayList<FontProvider> providers = new ArrayList<FontProvider>(oldFont.providers());
            providers.addAll(font.providers());
            this.fonts.put(font.key(), oldFont.providers(providers));
        }
        for (Language language : other.languages()) {
            Language oldLanguage = this.languages.get(language.key());
            if (oldLanguage == null || override) {
                this.languages.put(language.key(), language);
                continue;
            }
            LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>(oldLanguage.translations());
            for (Map.Entry<String, String> translation : language.translations().entrySet()) {
                String replaced = translations.put(translation.getKey(), translation.getValue());
                if (replaced == null || strategy != MergeStrategy.mergeAndFailOnError()) continue;
                throw new MergeException("Duplicated translation keys in language " + language.key() + ". Translation key: " + translation.getKey() + ". Exists in both resource containers.");
            }
            this.languages.put(language.key(), Language.language(language.key(), translations));
        }
        for (Model model : other.models()) {
            Model oldModel = this.models.get(model.key());
            if (oldModel == null || strategy == MergeStrategy.override()) {
                this.models.put(model.key(), model);
                continue;
            }
            Model.Builder oldModelBuilder = oldModel.toBuilder();
            for (ItemOverride itemOverride : model.overrides()) {
                oldModelBuilder.addOverride(itemOverride);
            }
            this.models.put(model.key(), oldModelBuilder.build());
        }
        for (SoundRegistry soundRegistry : other.soundRegistries()) {
            SoundRegistry oldSoundRegistry = this.soundRegistries.get(soundRegistry.namespace());
            if (oldSoundRegistry == null || override) {
                this.soundRegistries.put(soundRegistry.namespace(), soundRegistry);
                continue;
            }
            LinkedHashMap<Key, SoundEvent> soundEvents = new LinkedHashMap<Key, SoundEvent>();
            for (SoundEvent soundEvent : oldSoundRegistry.sounds()) {
                soundEvents.put(soundEvent.key(), soundEvent);
            }
            for (SoundEvent soundEvent : soundRegistry.sounds()) {
                SoundEvent replacedSoundEvent = soundEvents.put(soundEvent.key(), soundEvent);
                if (replacedSoundEvent == null || strategy != MergeStrategy.mergeAndFailOnError()) continue;
                throw new MergeException("Duplicated sound event '" + soundEvent + "': exists in both resource-packs");
            }
            this.soundRegistries.put(soundRegistry.namespace(), SoundRegistry.soundRegistry().namespace(soundRegistry.namespace()).sounds(soundEvents.values()).build());
        }
        for (Sound sound : other.sounds()) {
            if (this.sounds.containsKey(sound.key())) {
                if (override) {
                    this.sounds.put(sound.key(), sound);
                    continue;
                }
                if (strategy != MergeStrategy.mergeAndFailOnError()) continue;
                throw new MergeException("Duplicated sound '" + sound.key() + "': exists in both resource containers");
            }
            this.sounds.put(sound.key(), sound);
        }
        for (Texture texture : other.textures()) {
            if (this.textures.containsKey(texture.key())) {
                if (override) {
                    this.textures.put(texture.key(), texture);
                    continue;
                }
                if (strategy != MergeStrategy.mergeAndFailOnError()) continue;
                throw new MergeException("Duplicated texture '" + texture.key() + "': exists in both resource containers");
            }
            this.textures.put(texture.key(), texture);
        }
        for (Map.Entry entry : other.unknownFiles().entrySet()) {
            if (this.files.containsKey(entry.getKey())) {
                if (override) {
                    this.files.put((String)entry.getKey(), (Writable)entry.getValue());
                    continue;
                }
                if (strategy != MergeStrategy.mergeAndFailOnError()) continue;
                throw new MergeException("Duplicated unknown file: '" + (String)entry.getKey() + "': exists in both resource containers");
            }
            this.files.put((String)entry.getKey(), (Writable)entry.getValue());
        }
    }
}

