/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.language;

import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.metadata.language.LanguageEntry;

final class LanguageEntryImpl
implements LanguageEntry {
    private final String name;
    private final String region;
    private final boolean bidirectional;

    LanguageEntryImpl(@NotNull String name, @NotNull String region, boolean bidirectional) {
        this.name = Objects.requireNonNull(name, "name");
        this.region = Objects.requireNonNull(region, "region");
        this.bidirectional = bidirectional;
        this.validate();
    }

    private void validate() {
        if (this.name.isEmpty()) {
            throw new IllegalArgumentException("'name' is empty!");
        }
        if (this.region.isEmpty()) {
            throw new IllegalArgumentException("'region' is empty!");
        }
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public String region() {
        return this.region;
    }

    @Override
    public boolean bidirectional() {
        return this.bidirectional;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"name", (String)this.name), ExaminableProperty.of((String)"region", (String)this.region), ExaminableProperty.of((String)"bidirectional", (boolean)this.bidirectional));
    }

    @NotNull
    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageEntryImpl entry = (LanguageEntryImpl)o;
        return this.bidirectional == entry.bidirectional && this.name.equals(entry.name) && this.region.equals(entry.region);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.region, this.bidirectional);
    }

    static final class BuilderImpl
    implements LanguageEntry.Builder {
        private String name;
        private String region;
        private boolean bidirectional = false;

        BuilderImpl() {
        }

        @Override
        @NotNull
        public LanguageEntry.Builder name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @Override
        @NotNull
        public LanguageEntry.Builder region(@NotNull String region) {
            this.region = Objects.requireNonNull(region, "region");
            return this;
        }

        @Override
        @NotNull
        public LanguageEntry.Builder bidirectional(boolean bidirectional) {
            this.bidirectional = bidirectional;
            return this;
        }

        @Override
        @NotNull
        public LanguageEntry build() {
            return new LanguageEntryImpl(this.name, this.region, this.bidirectional);
        }
    }
}

