/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.protectionlib;

import io.th0rgal.protectionlib.ProtectionCompatibility;
import io.th0rgal.protectionlib.compatibilities.BentoBoxCompat;
import io.th0rgal.protectionlib.compatibilities.CrashClaimCompat;
import io.th0rgal.protectionlib.compatibilities.FactionsUuidCompat;
import io.th0rgal.protectionlib.compatibilities.GriefPreventionCompat;
import io.th0rgal.protectionlib.compatibilities.HuskClaimCompat;
import io.th0rgal.protectionlib.compatibilities.HuskTownsCompat;
import io.th0rgal.protectionlib.compatibilities.LandsCompat;
import io.th0rgal.protectionlib.compatibilities.PlotSquaredCompat;
import io.th0rgal.protectionlib.compatibilities.ResidenceCompat;
import io.th0rgal.protectionlib.compatibilities.TownyCompat;
import io.th0rgal.protectionlib.compatibilities.WorldGuardCompat;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ProtectionLib {
    private static final Set<ProtectionCompatibility> compatibilities = new HashSet<ProtectionCompatibility>();
    static boolean debug = false;

    public static void init(JavaPlugin plugin) {
        block32: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            block23: {
                                                block22: {
                                                    try {
                                                        ProtectionLib.handleCompatibility("WorldGuard", plugin, (m, p) -> new WorldGuardCompat(m, p));
                                                    }
                                                    catch (Exception | NoClassDefFoundError e) {
                                                        if (!debug) break block22;
                                                        e.printStackTrace();
                                                    }
                                                }
                                                try {
                                                    ProtectionLib.handleCompatibility("Towny", plugin, (m, p) -> new TownyCompat(m, p));
                                                }
                                                catch (Exception | NoClassDefFoundError e) {
                                                    if (!debug) break block23;
                                                    e.printStackTrace();
                                                }
                                            }
                                            try {
                                                ProtectionLib.handleCompatibility("Factions", plugin, (m, p) -> new FactionsUuidCompat(m, p));
                                            }
                                            catch (Exception | NoClassDefFoundError e) {
                                                if (!debug) break block24;
                                                e.printStackTrace();
                                            }
                                        }
                                        try {
                                            ProtectionLib.handleCompatibility("Lands", plugin, (m, p) -> new LandsCompat(m, p));
                                        }
                                        catch (Exception | NoClassDefFoundError e) {
                                            if (!debug) break block25;
                                            e.printStackTrace();
                                        }
                                    }
                                    try {
                                        ProtectionLib.handleCompatibility("PlotSquared", plugin, (m, p) -> new PlotSquaredCompat(m, p));
                                    }
                                    catch (Exception | NoClassDefFoundError e) {
                                        if (!debug) break block26;
                                        e.printStackTrace();
                                    }
                                }
                                try {
                                    ProtectionLib.handleCompatibility("CrashClaim", plugin, (m, p) -> new CrashClaimCompat(m, p));
                                }
                                catch (Exception | NoClassDefFoundError e) {
                                    if (!debug) break block27;
                                    e.printStackTrace();
                                }
                            }
                            try {
                                ProtectionLib.handleCompatibility("GriefPrevention", plugin, (m, p) -> new GriefPreventionCompat(m, p));
                            }
                            catch (Exception | NoClassDefFoundError e) {
                                if (!debug) break block28;
                                e.printStackTrace();
                            }
                        }
                        try {
                            ProtectionLib.handleCompatibility("HuskClaims", plugin, (m, p) -> new HuskClaimCompat(m, p));
                        }
                        catch (Exception | NoClassDefFoundError e) {
                            if (!debug) break block29;
                            e.printStackTrace();
                        }
                    }
                    try {
                        ProtectionLib.handleCompatibility("BentoBox", plugin, (m, p) -> new BentoBoxCompat(m, p));
                    }
                    catch (Exception | NoClassDefFoundError e) {
                        if (!debug) break block30;
                        e.printStackTrace();
                    }
                }
                try {
                    ProtectionLib.handleCompatibility("HuskTowns", plugin, (m, p) -> new HuskTownsCompat(m, p));
                }
                catch (Exception | NoClassDefFoundError e) {
                    if (!debug) break block31;
                    e.printStackTrace();
                }
            }
            try {
                ProtectionLib.handleCompatibility("Residence", plugin, (m, p) -> new ResidenceCompat(m, p));
            }
            catch (Exception | NoClassDefFoundError e) {
                if (!debug) break block32;
                e.printStackTrace();
            }
        }
    }

    public static void setDebug(boolean debug) {
        ProtectionLib.debug = debug;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static boolean canBuild(Player player, Location target) {
        try {
            return compatibilities.stream().allMatch(compatibility -> compatibility.canBuild(player, target));
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public static boolean canBreak(Player player, Location target) {
        try {
            return compatibilities.stream().allMatch(compatibility -> compatibility.canBreak(player, target));
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public static boolean canInteract(Player player, Location target) {
        try {
            return compatibilities.stream().allMatch(compatibility -> compatibility.canInteract(player, target));
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public static boolean canUse(Player player, Location target) {
        try {
            return compatibilities.stream().allMatch(compatibility -> compatibility.canUse(player, target));
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            return true;
        }
    }

    private static void handleCompatibility(String pluginName, JavaPlugin mainPlugin, CompatibilityConstructor constructor) {
        block4: {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (plugin != null) {
                if (pluginName.equals("Factions") && !ProtectionLib.checkFactionsCompat()) {
                    return;
                }
                try {
                    compatibilities.add(constructor.create(mainPlugin, plugin));
                }
                catch (Exception e) {
                    if (!debug) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean checkFactionsCompat() {
        try {
            Class.forName("com.massivecraft.factions.perms.PermissibleActions");
            return true;
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().warning("It seems a Factions plugin is installed, but it is not FactionsUUID.");
            Bukkit.getLogger().warning("ProtectionLib will not be able to handle Factions protection.");
            return false;
        }
    }

    @FunctionalInterface
    private static interface CompatibilityConstructor {
        public ProtectionCompatibility create(JavaPlugin var1, Plugin var2);
    }
}

