/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.block;

import com.google.gson.JsonObject;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.limitedplacing.LimitedPlacing;
import io.th0rgal.oraxen.utils.blocksounds.BlockSounds;
import io.th0rgal.oraxen.utils.drops.Drop;
import io.th0rgal.oraxen.utils.drops.Loot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.configuration.ConfigurationSection;

public class BlockMechanic
extends Mechanic {
    private String model;
    private final int customVariation;
    private final Drop drop;
    private final boolean canIgnite;
    private final LimitedPlacing limitedPlacing;
    private final BlockSounds blockSounds;

    public BlockMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        if (section.isString("model")) {
            this.model = section.getString("model");
        }
        this.customVariation = section.getInt("custom_variation");
        this.canIgnite = section.getBoolean("can_ignite", false);
        ArrayList<Loot> loots = new ArrayList<Loot>();
        ConfigurationSection drop = section.getConfigurationSection("drop");
        if (drop != null) {
            for (LinkedHashMap lootConfig : drop.getList("loots", new ArrayList())) {
                loots.add(new Loot(lootConfig, this.getItemID()));
            }
            if (drop.isString("minimal_type")) {
                BlockMechanicFactory mechanic = (BlockMechanicFactory)mechanicFactory;
                this.drop = new Drop(mechanic.toolTypes, loots, drop.getBoolean("silktouch"), drop.getBoolean("fortune"), this.getItemID(), drop.getString("minimal_type"), new ArrayList<String>());
            } else {
                this.drop = new Drop(loots, drop.getBoolean("silktouch"), drop.getBoolean("fortune"), this.getItemID());
            }
        } else {
            this.drop = null;
        }
        this.limitedPlacing = section.isConfigurationSection("limited_placing") ? new LimitedPlacing(Objects.requireNonNull(section.getConfigurationSection("limited_placing"))) : null;
        this.blockSounds = section.isConfigurationSection("block_sounds") ? new BlockSounds(Objects.requireNonNull(section.getConfigurationSection("block_sounds"))) : null;
    }

    public String getModel(ConfigurationSection section) {
        if (this.model != null) {
            return this.model;
        }
        return section.getString("Pack.model");
    }

    public boolean hasLimitedPlacing() {
        return this.limitedPlacing != null;
    }

    public LimitedPlacing getLimitedPlacing() {
        return this.limitedPlacing;
    }

    public boolean hasBlockSounds() {
        return this.blockSounds != null;
    }

    public BlockSounds getBlockSounds() {
        return this.blockSounds;
    }

    public int getCustomVariation() {
        return this.customVariation;
    }

    public Drop getDrop() {
        return this.drop;
    }

    public boolean canIgnite() {
        return this.canIgnite;
    }

    public static int getCode(Block block) {
        int sum = 0;
        if (block.getType() == Material.MUSHROOM_STEM) {
            MultipleFacing blockData = (MultipleFacing)block.getBlockData();
            List<BlockFace> properties = Arrays.asList(BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH, BlockFace.DOWN, BlockFace.UP);
            for (BlockFace blockFace : blockData.getFaces()) {
                sum += (int)Math.pow(2.0, properties.indexOf(blockFace));
            }
        }
        return sum;
    }

    public static JsonObject getBlockstateWhenFields(int code) {
        JsonObject whenJson = new JsonObject();
        String[] properties = new String[]{"up", "down", "north", "south", "west", "east"};
        for (int i = 0; i < properties.length; ++i) {
            whenJson.addProperty(properties[properties.length - 1 - i], Boolean.valueOf((code & 1 << i) != 0));
        }
        return whenJson;
    }

    public static void setBlockFacing(MultipleFacing blockData, int code) {
        BlockFace[] properties = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH, BlockFace.DOWN, BlockFace.UP};
        for (int i = 0; i < properties.length; ++i) {
            blockData.setFace(properties[i], (code & 1 << i) != 0);
        }
    }
}

