/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_17_0;

import com.github.stefvanschie.inventoryframework.abstraction.CartographyTableInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_17_0.util.CustomInventoryUtil;
import com.github.stefvanschie.inventoryframework.nms.v1_17_0.util.TextHolderUtil;
import java.lang.reflect.Field;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CartographyTableInventoryImpl
extends CartographyTableInventory {
    public CartographyTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a cartography table should be 3, but is '" + itemAmount + "'");
        }
        abs serverPlayer = this.getServerPlayer(player);
        ContainerCartographyTableImpl containerCartographyTable = new ContainerCartographyTableImpl(serverPlayer, items);
        serverPlayer.bV = containerCartographyTable;
        int id = containerCartographyTable.j;
        os message = TextHolderUtil.toComponent(title);
        serverPlayer.b.a((pk)new rg(id, bnn.w, message));
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        gs<bqp> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        abs serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((bkd)serverPlayer);
        this.getPlayerConnection(serverPlayer).a((pk)new qi(containerId, nmsItems));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        qk packet = new qk(-1, -1, bqp.b);
        this.getPlayerConnection(this.getServerPlayer(player)).a((pk)packet);
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull bkd nmsPlayer) {
        return nmsPlayer.bV.j;
    }

    @NotNull
    @Contract(pure=true)
    private acm getPlayerConnection(@NotNull abs serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private abs getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerCartographyTableImpl
    extends bmp {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field resultContainerField;

        public ContainerCartographyTableImpl(@Nullable abs serverPlayer, ItemStack[] items) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fj());
            this.player = serverPlayer.getBukkitEntity();
            try {
                this.resultContainerField = bmp.class.getDeclaredField("u");
                this.resultContainerField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            this.n.a(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.n.a(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            this.getResultInventory().a(0, CraftItemStack.asNMSCopy((ItemStack)items[2]));
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                CraftInventoryCartography inventory = new CraftInventoryCartography(this.n, this.getResultInventory()){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return CartographyTableInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (bmj)this);
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable bkd nmsPlayer) {
            return true;
        }

        public void a(art container) {
        }

        public void b(bkd nmsPlayer) {
        }

        @NotNull
        @Contract(pure=true)
        private art getResultInventory() {
            try {
                return (art)this.resultContainerField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

