/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_16_1;

import com.github.stefvanschie.inventoryframework.abstraction.AnvilInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_16_1.util.TextHolderUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_16_R1.BlockPosition;
import net.minecraft.server.v1_16_R1.Container;
import net.minecraft.server.v1_16_R1.ContainerAccess;
import net.minecraft.server.v1_16_R1.ContainerAnvil;
import net.minecraft.server.v1_16_R1.ContainerProperty;
import net.minecraft.server.v1_16_R1.Containers;
import net.minecraft.server.v1_16_R1.EntityHuman;
import net.minecraft.server.v1_16_R1.EntityPlayer;
import net.minecraft.server.v1_16_R1.IChatBaseComponent;
import net.minecraft.server.v1_16_R1.ICrafting;
import net.minecraft.server.v1_16_R1.IInventory;
import net.minecraft.server.v1_16_R1.IMaterial;
import net.minecraft.server.v1_16_R1.InventoryClickType;
import net.minecraft.server.v1_16_R1.Items;
import net.minecraft.server.v1_16_R1.NBTBase;
import net.minecraft.server.v1_16_R1.NBTTagCompound;
import net.minecraft.server.v1_16_R1.NBTTagLongArray;
import net.minecraft.server.v1_16_R1.NonNullList;
import net.minecraft.server.v1_16_R1.Packet;
import net.minecraft.server.v1_16_R1.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R1.PacketPlayOutSetSlot;
import net.minecraft.server.v1_16_R1.PacketPlayOutWindowItems;
import net.minecraft.server.v1_16_R1.PlayerConnection;
import net.minecraft.server.v1_16_R1.Slot;
import net.minecraft.server.v1_16_R1.World;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilInventoryImpl
extends AnvilInventory {
    public AnvilInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for an anvil should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        CraftEventFactory.handleInventoryCloseEvent((EntityHuman)entityPlayer);
        entityPlayer.activeContainer = entityPlayer.defaultContainer;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        ContainerAnvilImpl containerAnvil = new ContainerAnvilImpl(entityPlayer, message);
        Inventory inventory = containerAnvil.getBukkitView().getTopInventory();
        inventory.setItem(0, items[0]);
        inventory.setItem(1, items[1]);
        inventory.setItem(2, items[2]);
        int containerId = containerAnvil.getContainerId();
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(containerId, Containers.ANVIL, message));
        entityPlayer.activeContainer = containerAnvil;
        entityPlayer.syncInventory();
        return inventory;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        NonNullList nmsItems = NonNullList.a((Object)net.minecraft.server.v1_16_R1.ItemStack.b, (Object[])new net.minecraft.server.v1_16_R1.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1]), CraftItemStack.asNMSCopy((ItemStack)items[2])});
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutWindowItems(this.getWindowId(entityPlayer), nmsItems));
    }

    @Override
    public void sendFirstItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        net.minecraft.server.v1_16_R1.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(this.getWindowId(entityPlayer), 0, nmsItem));
    }

    @Override
    public void sendSecondItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        net.minecraft.server.v1_16_R1.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(this.getWindowId(entityPlayer), 1, nmsItem));
    }

    @Override
    public void sendResultItem(@NotNull Player player, @Nullable ItemStack item) {
        this.sendResultItem(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearResultItem(@NotNull Player player) {
        this.sendResultItem(player, net.minecraft.server.v1_16_R1.ItemStack.b);
    }

    @Override
    public void setCursor(@NotNull Player player, @NotNull ItemStack item) {
        this.setCursor(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        this.getPlayerConnection(this.getEntityPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, net.minecraft.server.v1_16_R1.ItemStack.b));
    }

    @Deprecated
    private void setCursor(@NotNull Player player, @NotNull net.minecraft.server.v1_16_R1.ItemStack item) {
        this.getPlayerConnection(this.getEntityPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, item));
    }

    @Deprecated
    private void sendResultItem(@NotNull Player player, @NotNull net.minecraft.server.v1_16_R1.ItemStack item) {
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(this.getWindowId(entityPlayer), 2, item));
    }

    @Deprecated
    @Contract(pure=true)
    private int getWindowId(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.activeContainer.windowId;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    private PlayerConnection getPlayerConnection(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.playerConnection;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getEntityPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerAnvilImpl
    extends ContainerAnvil {
        private static final int RESULT_SLOT_INDEX = 2;
        @NotNull
        private final net.minecraft.server.v1_16_R1.ItemStack uniqueItem;
        @NotNull
        private final Field listenersField;

        public ContainerAnvilImpl(@NotNull EntityPlayer entityPlayer, IChatBaseComponent title) {
            super(entityPlayer.nextContainerCounter(), entityPlayer.inventory, ContainerAccess.at((World)entityPlayer.getWorld(), (BlockPosition)new BlockPosition(0, 0, 0)));
            this.checkReachable = false;
            try {
                Field dField = Container.class.getDeclaredField("d");
                dField.setAccessible(true);
                ((List)dField.get((Object)this)).clear();
            }
            catch (IllegalAccessException | NoSuchFieldException exception) {
                throw new RuntimeException("Unable to access field 'd'", exception);
            }
            try {
                this.listenersField = Container.class.getDeclaredField("listeners");
                this.listenersField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException("Unable to access field 'listeners'", exception);
            }
            ContainerProperty levelCost = this.a(new ContainerProperty(){
                private int value;

                public int get() {
                    return this.value;
                }

                public void set(int value) {
                    this.value = value;
                }

                public boolean c() {
                    return true;
                }
            });
            levelCost.set((int)AnvilInventoryImpl.this.cost);
            this.setTitle(title);
            final Slot originalSlot = (Slot)this.slots.get(2);
            Slot newSlot = new Slot(originalSlot.inventory, originalSlot.index, originalSlot.e, originalSlot.f){

                public boolean isAllowed(net.minecraft.server.v1_16_R1.ItemStack itemStack) {
                    return true;
                }

                public boolean isAllowed(EntityHuman entityHuman) {
                    return true;
                }

                public net.minecraft.server.v1_16_R1.ItemStack a(EntityHuman entityHuman, @NotNull net.minecraft.server.v1_16_R1.ItemStack itemStack) {
                    return originalSlot.a(entityHuman, itemStack);
                }
            };
            this.slots.set(2, newSlot);
            this.uniqueItem = new net.minecraft.server.v1_16_R1.ItemStack((IMaterial)Items.COOKIE);
            UUID uuid = UUID.randomUUID();
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.set("uuid", (NBTBase)new NBTTagLongArray(new long[]{uuid.getLeastSignificantBits(), uuid.getMostSignificantBits()}));
            this.uniqueItem.setTag(nbtTagCompound);
        }

        public void a(@Nullable String name) {
            String string = name = name == null ? "" : name;
            if (!name.equals(AnvilInventoryImpl.this.observableText.get())) {
                AnvilInventoryImpl.this.observableText.set(name);
            }
            this.forceUpdate();
        }

        public void e() {
        }

        public void b(EntityHuman entityHuman) {
        }

        protected void a(EntityHuman entityHuman, World world, @NotNull IInventory inventory) {
        }

        protected net.minecraft.server.v1_16_R1.ItemStack a(EntityHuman entityHuman, @NotNull net.minecraft.server.v1_16_R1.ItemStack itemStack) {
            return itemStack;
        }

        public net.minecraft.server.v1_16_R1.ItemStack a(int i, int j, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
            net.minecraft.server.v1_16_R1.ItemStack itemStack = super.a(i, j, inventoryclicktype, entityhuman);
            this.forceUpdate();
            return itemStack;
        }

        public int getContainerId() {
            return this.windowId;
        }

        public void forceUpdate() {
            List listeners;
            Collections.fill(this.items, this.uniqueItem);
            this.c();
            try {
                listeners = (List)this.listenersField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException("Unable to access field 'listeners'", exception);
            }
            for (ICrafting listener : listeners) {
                if (!(listener instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)listener;
                player.e = false;
                player.broadcastCarriedItem();
            }
        }
    }
}

