/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.misc;

import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;

public class MiscMechanic
extends Mechanic {
    private final boolean cactusBreaks;
    private final boolean burnsInFire;
    private final boolean burnsInLava;
    private final boolean disableVanillaInteractions;
    private final boolean canStripLogs;
    private final boolean piglinsIgnoreWhenEquipped;
    private final boolean compostable;
    private final boolean allowInVanillaRecipes;

    public MiscMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        this.cactusBreaks = section.getBoolean("breaks_from_cactus", true);
        this.burnsInFire = section.getBoolean("burns_in_fire", true);
        this.burnsInLava = section.getBoolean("burns_in_lava", true);
        this.disableVanillaInteractions = section.getBoolean("disable_vanilla_interactions", false);
        this.canStripLogs = section.getBoolean("can_strip_logs", false);
        this.piglinsIgnoreWhenEquipped = section.getBoolean("piglins_ignore_when_equipped", false);
        this.compostable = section.getBoolean("compostable", false);
        this.allowInVanillaRecipes = section.getBoolean("allow_in_vanilla_recipes", false);
        if (VersionUtil.atOrAbove("1.20.5") && (this.burnsInFire || this.burnsInLava)) {
            Logs.logWarning(this.getItemID() + " seems to be using " + (this.burnsInFire ? "burns_in_fire" : "burns_in_lava") + " which is deprecated....");
            Logs.logWarning("It is heavily advised to swap to the new fire_resistant-property on all 1.20.5+ servers");
        }
    }

    public boolean breaksFromCactus() {
        return this.cactusBreaks;
    }

    public boolean burnsInFire() {
        return this.burnsInFire;
    }

    public boolean burnsInLava() {
        return this.burnsInLava;
    }

    public boolean isVanillaInteractionDisabled() {
        return this.disableVanillaInteractions;
    }

    public boolean canStripLogs() {
        return this.canStripLogs;
    }

    public boolean piglinIgnoreWhenEquipped() {
        return this.piglinsIgnoreWhenEquipped;
    }

    public boolean isCompostable() {
        return this.compostable;
    }

    public boolean isAllowedInVanillaRecipes() {
        return this.allowInVanillaRecipes;
    }
}

