/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.commands.AdminCommand;
import io.th0rgal.oraxen.commands.BlockInfoCommand;
import io.th0rgal.oraxen.commands.DebugCommand;
import io.th0rgal.oraxen.commands.GlyphCommand;
import io.th0rgal.oraxen.commands.GlyphInfoCommand;
import io.th0rgal.oraxen.commands.HudCommand;
import io.th0rgal.oraxen.commands.ItemInfoCommand;
import io.th0rgal.oraxen.commands.LogDumpCommand;
import io.th0rgal.oraxen.commands.ModelDataCommand;
import io.th0rgal.oraxen.commands.PackCommand;
import io.th0rgal.oraxen.commands.RecipesCommand;
import io.th0rgal.oraxen.commands.ReloadCommand;
import io.th0rgal.oraxen.commands.RepairCommand;
import io.th0rgal.oraxen.commands.UpdateCommand;
import io.th0rgal.oraxen.commands.VersionCommand;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.ItemUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Color;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandsManager {
    public void loadCommands() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("oraxen").withAliases(new String[]{"o", "oxn"})).withPermission("oraxen.command")).withSubcommands((AbstractCommandAPICommand[])new CommandAPICommand[]{this.getDyeCommand(), this.getInvCommand(), this.getSimpleGiveCommand(), this.getGiveCommand(), this.getTakeCommand(), new PackCommand().getPackCommand(), new UpdateCommand().getUpdateCommand(), new RepairCommand().getRepairCommand(), new RecipesCommand().getRecipesCommand(), new ReloadCommand().getReloadCommand(), new DebugCommand().getDebugCommand(), new ModelDataCommand().getHighestModelDataCommand(), new GlyphCommand().getGlyphCommand(), new GlyphInfoCommand().getGlyphInfoCommand(), new ItemInfoCommand().getItemInfoCommand(), new BlockInfoCommand().getBlockInfoCommand(), new HudCommand().getHudCommand(), new LogDumpCommand().getLogDumpCommand(), new VersionCommand().getVersionCommand(), new AdminCommand().getAdminCommand()})).executes((sender, args) -> Message.COMMAND_HELP.send(sender, new TagResolver[0]), new ExecutorType[0])).register();
    }

    private Color hex2Rgb(String colorStr) throws NumberFormatException {
        return Color.fromRGB((int)Integer.valueOf(colorStr.substring(1, 3), 16), (int)Integer.valueOf(colorStr.substring(3, 5), 16), (int)Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    private CommandAPICommand getDyeCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("dye").withPermission("oraxen.command.dye")).withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("color")})).executes((sender, args) -> {
            if (sender instanceof Player) {
                Color hexColor;
                Player player = (Player)sender;
                try {
                    hexColor = this.hex2Rgb((String)args.get("color"));
                }
                catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                    Message.DYE_WRONG_COLOR.send(sender, new TagResolver[0]);
                    return;
                }
                ItemUtils.dyeItem(player.getInventory().getItemInMainHand(), hexColor);
                Message.DYE_SUCCESS.send(sender, new TagResolver[0]);
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getInvCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("inventory").withAliases(new String[]{"inv"})).withPermission("oraxen.command.inventory.view")).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                OraxenPlugin.get().getInvManager().getItemsView(player).open((HumanEntity)player);
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getGiveCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("give").withPermission("oraxen.command.give")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyPlayers("targets"), (Argument)new TextArgument("item").replaceSuggestions(ArgumentSuggestions.strings((String[])OraxenItems.getItemNames())), new IntegerArgument("amount")})).executes((sender, args) -> {
            Collection targets = (Collection)args.get(0);
            String itemID = (String)args.get(1);
            ItemBuilder itemBuilder = OraxenItems.getItemById(itemID);
            if (itemBuilder == null) {
                Message.ITEM_NOT_FOUND.send(sender, AdventureUtils.tagResolver("item", itemID));
                return;
            }
            int amount = (Integer)args.get(2);
            int max = itemBuilder.hasMaxStackSize() ? itemBuilder.getMaxStackSize().intValue() : itemBuilder.getType().getMaxStackSize();
            int slots = amount / max + (max % amount > 0 ? 1 : 0);
            ItemStack[] items = itemBuilder.buildArray(slots > 36 ? (amount = max * 36) : amount);
            for (Player target : targets) {
                HashMap output = target.getInventory().addItem(items);
                for (ItemStack stack : output.values()) {
                    target.getWorld().dropItem(target.getLocation(), stack);
                }
            }
            if (targets.size() == 1) {
                Message.GIVE_PLAYER.send(sender, AdventureUtils.tagResolver("player", ((Player)targets.iterator().next()).getName()), AdventureUtils.tagResolver("amount", String.valueOf(amount)), AdventureUtils.tagResolver("item", itemID));
            } else {
                Message.GIVE_PLAYERS.send(sender, AdventureUtils.tagResolver("count", String.valueOf(targets.size())), AdventureUtils.tagResolver("amount", String.valueOf(amount)), AdventureUtils.tagResolver("item", itemID));
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getSimpleGiveCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("give").withPermission("oraxen.command.give")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyPlayers("targets"), (Argument)new TextArgument("item").replaceSuggestions(ArgumentSuggestions.strings(info -> OraxenItems.getItemNames()))})).executes((sender, args) -> {
            Collection targets = (Collection)args.get(0);
            String itemID = (String)args.get(1);
            ItemBuilder itemBuilder = OraxenItems.getItemById(itemID);
            if (itemBuilder == null) {
                Message.ITEM_NOT_FOUND.send(sender, AdventureUtils.tagResolver("item", itemID));
                return;
            }
            for (Player target : targets) {
                target.getInventory().addItem(new ItemStack[]{ItemUpdater.updateItem(itemBuilder.build())});
            }
            if (targets.size() == 1) {
                Message.GIVE_PLAYER.send(sender, AdventureUtils.tagResolver("player", ((Player)targets.iterator().next()).getName()), AdventureUtils.tagResolver("amount", String.valueOf(1)), AdventureUtils.tagResolver("item", itemID));
            } else {
                Message.GIVE_PLAYERS.send(sender, AdventureUtils.tagResolver("count", String.valueOf(targets.size())), AdventureUtils.tagResolver("amount", String.valueOf(1)), AdventureUtils.tagResolver("item", itemID));
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getTakeCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("take").withPermission("oraxen.command.take")).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyPlayers("targets"), (Argument)new TextArgument("item").replaceSuggestions(ArgumentSuggestions.strings((String[])OraxenItems.getItemNames())), (Argument)new IntegerArgument("amount").setOptional(true)})).executes((sender, args) -> {
            Collection targets = (Collection)args.get("targets");
            String itemID = (String)args.getOrDefault("item", (Object)"");
            Optional amount = args.getOptionalByClass("amount", Integer.class);
            if (!OraxenItems.exists(itemID)) {
                Message.ITEM_NOT_FOUND.send(sender, AdventureUtils.tagResolver("item", itemID));
            } else {
                block0: for (Player target : targets) {
                    if (amount.isEmpty()) {
                        for (ItemStack itemStack : target.getInventory().getContents()) {
                            if (ItemUtils.isEmpty(itemStack) || !itemID.equals(OraxenItems.getIdByItem(itemStack))) continue;
                            target.getInventory().remove(itemStack);
                        }
                        continue;
                    }
                    int toRemove = (Integer)amount.get();
                    while (toRemove > 0) {
                        ItemStack[] items = target.getInventory().getStorageContents();
                        for (int i = 0; i < items.length; ++i) {
                            ItemStack itemStack;
                            itemStack = items[i];
                            if (ItemUtils.isEmpty(itemStack) || !itemID.equals(OraxenItems.getIdByItem(itemStack))) continue;
                            if (itemStack.getAmount() <= toRemove) {
                                toRemove -= itemStack.getAmount();
                                target.getInventory().clear(i);
                            } else {
                                itemStack.setAmount(itemStack.getAmount() - toRemove);
                                toRemove = 0;
                            }
                            if (toRemove == 0) break;
                        }
                        if (toRemove <= 0) continue;
                        continue block0;
                    }
                }
            }
        }, new ExecutorType[0]);
    }
}

