/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.sound;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.sound.SoundEntry;
import team.unnamed.creative.sound.SoundEvent;
import team.unnamed.creative.util.MoreCollections;

final class SoundEventImpl
implements SoundEvent {
    private final Key key;
    private final boolean replace;
    private final String subtitle;
    private final List<SoundEntry> sounds;

    SoundEventImpl(@NotNull Key key, boolean replace, @Nullable String subtitle, @NotNull List<SoundEntry> sounds) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(sounds, "sounds");
        this.key = key;
        this.replace = replace;
        this.subtitle = subtitle;
        this.sounds = MoreCollections.immutableListOf(sounds);
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public boolean replace() {
        return this.replace;
    }

    @Override
    @Nullable
    public String subtitle() {
        return this.subtitle;
    }

    @Override
    public @Unmodifiable @NotNull List<SoundEntry> sounds() {
        return this.sounds;
    }

    @Override
    @NotNull
    public SoundEvent.Builder toBuilder() {
        return SoundEvent.soundEvent().key(this.key).replace(this.replace).subtitle(this.subtitle).sounds(this.sounds);
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"replace", (boolean)this.replace), ExaminableProperty.of((String)"subtitle", (String)this.subtitle), ExaminableProperty.of((String)"sounds", this.sounds));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoundEventImpl that = (SoundEventImpl)o;
        return Objects.equals(this.key, that.key) && this.replace == that.replace && Objects.equals(this.subtitle, that.subtitle) && Objects.equals(this.sounds, that.sounds);
    }

    public int hashCode() {
        return Objects.hash(this.replace, this.subtitle, this.sounds);
    }

    static final class BuilderImpl
    implements SoundEvent.Builder {
        private Key key;
        private boolean replace = false;
        private String subtitle;
        private List<SoundEntry> sounds = new ArrayList<SoundEntry>();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public SoundEvent.Builder key(@NotNull Key key) {
            this.key = Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        @NotNull
        public SoundEvent.Builder replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        @Override
        @NotNull
        public SoundEvent.Builder subtitle(@Nullable String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @Override
        @NotNull
        public SoundEvent.Builder sounds(@NotNull List<SoundEntry> sounds) {
            Objects.requireNonNull(sounds, "sounds");
            this.sounds = new ArrayList<SoundEntry>(sounds);
            return this;
        }

        @Override
        @NotNull
        public SoundEvent.Builder addSound(@NotNull SoundEntry soundEntry) {
            Objects.requireNonNull(soundEntry, "soundEntry");
            this.sounds.add(soundEntry);
            return this;
        }

        @Override
        @NotNull
        public SoundEvent build() {
            return new SoundEventImpl(this.key, this.replace, this.subtitle, this.sounds);
        }
    }
}

