/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.overlays;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.metadata.overlays.OverlayEntry;
import team.unnamed.creative.metadata.pack.PackFormat;

final class OverlayEntryImpl
implements OverlayEntry {
    @RegExp
    static final String DIRECTORY_PATTERN = "[a-z0-9-_]+";
    private static final Pattern DIRECTORY_COMPILED_PATTERN = Pattern.compile("[a-z0-9-_]+");
    private final PackFormat formats;
    private final String directory;

    OverlayEntryImpl(@NotNull PackFormat formats, @NotNull @OverlayEntry.Directory String directory) {
        this.formats = Objects.requireNonNull(formats, "formats");
        this.directory = Objects.requireNonNull(directory, "directory");
        if (!DIRECTORY_COMPILED_PATTERN.matcher(directory).matches()) {
            throw new IllegalArgumentException("Invalid directory name: '" + directory + "' must match pattern: " + DIRECTORY_PATTERN);
        }
    }

    @Override
    @NotNull
    public PackFormat formats() {
        return this.formats;
    }

    @Override
    @NotNull
    public String directory() {
        return this.directory;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"formats", (Object)this.formats), ExaminableProperty.of((String)"directory", (String)this.directory));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverlayEntryImpl that = (OverlayEntryImpl)o;
        if (!this.formats.equals(that.formats)) {
            return false;
        }
        return this.directory.equals(that.directory);
    }

    public int hashCode() {
        int result = this.formats.hashCode();
        result = 31 * result + this.directory.hashCode();
        return result;
    }
}

