/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.animation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.metadata.MetadataPart;
import team.unnamed.creative.metadata.animation.AnimationFrame;
import team.unnamed.creative.metadata.animation.AnimationMeta;
import team.unnamed.creative.util.MoreCollections;

final class AnimationMetaImpl
implements AnimationMeta {
    private final boolean interpolate;
    private final int width;
    private final int height;
    private final int frameTime;
    private final List<AnimationFrame> frames;

    AnimationMetaImpl(boolean interpolate, int width, int height, int frameTime, @NotNull List<AnimationFrame> frames) {
        this.interpolate = interpolate;
        this.width = width;
        this.height = height;
        this.frameTime = frameTime;
        this.frames = MoreCollections.immutableListOf(Objects.requireNonNull(frames, "frames"));
    }

    @Override
    @NotNull
    public Class<? extends MetadataPart> type() {
        return AnimationMeta.class;
    }

    @Override
    public boolean interpolate() {
        return this.interpolate;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public int frameTime() {
        return this.frameTime;
    }

    @Override
    @NotNull
    public @Unmodifiable List<AnimationFrame> frames() {
        return this.frames;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"interpolate", (boolean)this.interpolate), ExaminableProperty.of((String)"width", (int)this.width), ExaminableProperty.of((String)"height", (int)this.height), ExaminableProperty.of((String)"frameTime", (int)this.frameTime), ExaminableProperty.of((String)"frames", this.frames));
    }

    @NotNull
    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnimationMetaImpl that = (AnimationMetaImpl)o;
        return this.interpolate == that.interpolate && this.width == that.width && this.height == that.height && this.frameTime == that.frameTime && this.frames.equals(that.frames);
    }

    public int hashCode() {
        return Objects.hash(this.interpolate, this.width, this.height, this.frameTime, this.frames);
    }

    static final class BuilderImpl
    implements AnimationMeta.Builder {
        private boolean interpolate = false;
        private int width = -1;
        private int height = -1;
        private int frameTime = 1;
        private List<AnimationFrame> frames = Collections.emptyList();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public AnimationMeta.Builder interpolate(boolean interpolate) {
            this.interpolate = interpolate;
            return this;
        }

        @Override
        @NotNull
        public AnimationMeta.Builder width(int width) {
            this.width = width;
            return this;
        }

        @Override
        @NotNull
        public AnimationMeta.Builder height(int height) {
            this.height = height;
            return this;
        }

        @Override
        @NotNull
        public AnimationMeta.Builder frameTime(int frameTime) {
            this.frameTime = frameTime;
            return this;
        }

        @Override
        @NotNull
        public AnimationMeta.Builder frames(@NotNull List<AnimationFrame> frames) {
            Objects.requireNonNull(frames, "frames");
            this.frames = new ArrayList<AnimationFrame>(frames);
            return this;
        }

        @Override
        @NotNull
        public AnimationMeta.Builder addFrame(@NotNull AnimationFrame frame) {
            Objects.requireNonNull(frame, "frame");
            this.frames.add(frame);
            return this;
        }

        @Override
        @NotNull
        public AnimationMeta build() {
            return new AnimationMetaImpl(this.interpolate, this.width, this.height, this.frameTime, this.frames);
        }
    }
}

