/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.font;

import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.examination.Examinable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.font.BitMapFontProvider;
import team.unnamed.creative.font.BitMapFontProviderImpl;
import team.unnamed.creative.font.Font;
import team.unnamed.creative.font.LegacyUnicodeFontProvider;
import team.unnamed.creative.font.ReferenceFontProvider;
import team.unnamed.creative.font.ReferenceFontProviderImpl;
import team.unnamed.creative.font.SpaceFontProvider;
import team.unnamed.creative.font.TrueTypeFontProvider;
import team.unnamed.creative.font.UnihexFontProvider;
import team.unnamed.creative.font.UnihexFontProviderImpl;

public interface FontProvider
extends Examinable {
    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static BitMapFontProvider bitMap(@NotNull Key file, int height, int ascent, @NotNull List<String> characters) {
        return new BitMapFontProviderImpl(file, height, ascent, characters);
    }

    @Contract(value="-> new")
    public static BitMapFontProvider.Builder bitMap() {
        return new BitMapFontProviderImpl.BuilderImpl();
    }

    @Deprecated
    public static LegacyUnicodeFontProvider legacyUnicode(Key sizes, String template) {
        return new LegacyUnicodeFontProvider(sizes, template);
    }

    public static SpaceFontProvider.Builder space() {
        return new SpaceFontProvider.Builder();
    }

    public static SpaceFontProvider space(Map<String, Integer> advances) {
        return new SpaceFontProvider(advances);
    }

    public static TrueTypeFontProvider.Builder trueType() {
        return new TrueTypeFontProvider.Builder();
    }

    @NotNull
    public static ReferenceFontProvider reference(@NotNull Key id) {
        return new ReferenceFontProviderImpl(id);
    }

    @NotNull
    public static ReferenceFontProvider reference(@NotNull Font font) {
        return FontProvider.reference(font.key());
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static UnihexFontProvider unihex(@NotNull Key file, @NotNull List<UnihexFontProvider.SizeOverride> sizes) {
        return new UnihexFontProviderImpl(file, sizes);
    }

    @Contract(value="-> new")
    @NotNull
    public static UnihexFontProvider.Builder unihex() {
        return new UnihexFontProviderImpl.BuilderImpl();
    }
}

