/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.atlas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.atlas.Atlas;
import team.unnamed.creative.atlas.AtlasSource;
import team.unnamed.creative.util.MoreCollections;

final class AtlasImpl
implements Atlas {
    private final Key key;
    private final List<AtlasSource> sources;

    AtlasImpl(@NotNull Key key, @NotNull List<AtlasSource> sources) {
        this.key = Objects.requireNonNull(key, "key");
        this.sources = MoreCollections.immutableListOf(Objects.requireNonNull(sources, "sources"));
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public @Unmodifiable @NotNull List<AtlasSource> sources() {
        return this.sources;
    }

    @Override
    @NotNull
    public Atlas.Builder toBuilder() {
        return Atlas.atlas().key(this.key).sources(this.sources);
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"key", (Object)this.key), ExaminableProperty.of((String)"sources", this.sources));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlasImpl atlas = (AtlasImpl)o;
        if (!this.key.equals(atlas.key)) {
            return false;
        }
        return this.sources.equals(atlas.sources);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.sources.hashCode();
        return result;
    }

    static class BuilderImpl
    implements Atlas.Builder {
        private Key key;
        private List<AtlasSource> sources;

        BuilderImpl() {
        }

        @Override
        @Nullable
        public Key key() {
            return this.key;
        }

        @Override
        @NotNull
        public Atlas.Builder key(@NotNull Key key) {
            this.key = Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        @Nullable
        public List<AtlasSource> sources() {
            return this.sources;
        }

        @Override
        @NotNull
        public Atlas.Builder sources(@NotNull List<AtlasSource> sources) {
            Objects.requireNonNull(sources, "sources");
            this.sources = new ArrayList<AtlasSource>(sources);
            return this;
        }

        @Override
        @NotNull
        public Atlas.Builder sources(AtlasSource ... sources) {
            Objects.requireNonNull(sources, "sources");
            this.sources = new ArrayList<AtlasSource>(Arrays.asList(sources));
            return this;
        }

        @Override
        @NotNull
        public Atlas.Builder addSource(@NotNull AtlasSource source) {
            Objects.requireNonNull(source, "source");
            if (this.sources == null) {
                this.sources = new ArrayList<AtlasSource>();
            }
            this.sources.add(source);
            return this;
        }

        @Override
        @NotNull
        public Atlas build() {
            return new AtlasImpl(this.key, this.sources);
        }
    }
}

