/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.receive;

import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.commands.CommandsParser;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class PackAction {
    private final int delay;
    private String soundType;
    private float soundVolume;
    private float soundPitch;
    private String messageType;
    private Component messageContent;
    private final CommandsParser commandsParser;

    public PackAction(ConfigurationSection configurationSection, TagResolver tagResolver) {
        this.delay = configurationSection.getInt("delay", 0);
        if (configurationSection.isConfigurationSection("sound")) {
            ConfigurationSection soundSection = configurationSection.getConfigurationSection("sound");
            assert (soundSection != null);
            this.soundType = !soundSection.getBoolean("enabled", true) ? null : soundSection.getString("type");
            this.soundVolume = (float)soundSection.getDouble("volume");
            this.soundPitch = (float)soundSection.getDouble("pitch");
        }
        if (configurationSection.isConfigurationSection("message")) {
            ConfigurationSection messageSection = configurationSection.getConfigurationSection("message");
            assert (messageSection != null);
            this.messageType = messageSection.getString("type");
            if (messageSection.getBoolean("enabled", true)) {
                this.messageContent = AdventureUtils.MINI_MESSAGE.deserialize(messageSection.getString("content", ""), tagResolver);
            }
        }
        this.commandsParser = new CommandsParser(configurationSection.getConfigurationSection("commands"), tagResolver);
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean hasSound() {
        return this.soundType != null;
    }

    public void playSound(Player player, Location location) {
        player.playSound(location, this.soundType, this.soundVolume, this.soundPitch);
    }

    public boolean hasMessage() {
        return this.messageContent != null;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public Component getMessageContent() {
        return this.messageContent;
    }

    public CommandsParser getCommandsParser() {
        return this.commandsParser;
    }
}

