/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.utils.VersionUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class InventoryUtils {
    private static final Map<String, Method> methodCache = new HashMap<String, Method>();

    public static Component titleFromView(InventoryEvent event) {
        if (VersionUtil.atOrAbove("1.21")) {
            return event.getView().title();
        }
        InventoryView view = event.getView();
        try {
            return (Component)methodCache.computeIfAbsent("title", title -> {
                try {
                    Method method = view.getClass().getMethod("title", new Class[0]);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException e) {
                    if (Settings.DEBUG.toBool().booleanValue()) {
                        e.printStackTrace();
                    }
                    return null;
                }
            }).invoke((Object)view, new Object[0]);
        }
        catch (Exception e) {
            if (Settings.DEBUG.toBool().booleanValue()) {
                e.printStackTrace();
            }
            return Component.empty();
        }
    }

    public static Player playerFromView(InventoryEvent event) {
        if (VersionUtil.atOrAbove("1.21")) {
            return (Player)event.getView().getPlayer();
        }
        InventoryView view = event.getView();
        try {
            return (Player)methodCache.computeIfAbsent("getPlayer", player -> {
                try {
                    Method method = view.getClass().getMethod("getPlayer", new Class[0]);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException e) {
                    if (Settings.DEBUG.toBool().booleanValue()) {
                        e.printStackTrace();
                    }
                    return null;
                }
            }).invoke((Object)view, new Object[0]);
        }
        catch (Exception e) {
            if (Settings.DEBUG.toBool().booleanValue()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static String getTitleFromView(InventoryEvent event) {
        if (VersionUtil.atOrAbove("1.21")) {
            return event.getView().getTitle();
        }
        InventoryView view = event.getView();
        try {
            return (String)methodCache.computeIfAbsent("getTitle", title -> {
                try {
                    Method method = view.getClass().getMethod("getTitle", new Class[0]);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException e) {
                    if (Settings.DEBUG.toBool().booleanValue()) {
                        e.printStackTrace();
                    }
                    return null;
                }
            }).invoke((Object)view, new Object[0]);
        }
        catch (Exception e) {
            if (Settings.DEBUG.toBool().booleanValue()) {
                e.printStackTrace();
            }
            return "";
        }
    }

    public static Inventory topInventoryForPlayer(Player player) {
        if (VersionUtil.atOrAbove("1.21")) {
            return player.getOpenInventory().getTopInventory();
        }
        InventoryView view = player.getOpenInventory();
        try {
            return (Inventory)methodCache.computeIfAbsent("getTopInventory", topInv -> {
                try {
                    Method method = view.getClass().getMethod("getTopInventory", new Class[0]);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException e) {
                    if (Settings.DEBUG.toBool().booleanValue()) {
                        e.printStackTrace();
                    }
                    return null;
                }
            }).invoke((Object)view, new Object[0]);
        }
        catch (Exception e) {
            if (Settings.DEBUG.toBool().booleanValue()) {
                e.printStackTrace();
            }
            return player.getInventory();
        }
    }
}

