/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.overlay;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.atlas.Atlas;
import team.unnamed.creative.base.Writable;
import team.unnamed.creative.blockstate.BlockState;
import team.unnamed.creative.font.Font;
import team.unnamed.creative.font.FontProvider;
import team.unnamed.creative.lang.Language;
import team.unnamed.creative.metadata.Metadata;
import team.unnamed.creative.model.Model;
import team.unnamed.creative.part.ResourcePackPart;
import team.unnamed.creative.resources.MergeStrategy;
import team.unnamed.creative.sound.Sound;
import team.unnamed.creative.sound.SoundEvent;
import team.unnamed.creative.sound.SoundRegistry;
import team.unnamed.creative.texture.Texture;

@ApiStatus.NonExtendable
public interface ResourceContainer {
    public void atlas(@NotNull Atlas var1);

    @Nullable
    public Atlas atlas(@NotNull Key var1);

    public boolean removeAtlas(@NotNull Key var1);

    @NotNull
    public Collection<Atlas> atlases();

    public void blockState(@NotNull BlockState var1);

    @Nullable
    public BlockState blockState(@NotNull Key var1);

    public boolean removeBlockState(@NotNull Key var1);

    @NotNull
    public Collection<BlockState> blockStates();

    public void font(@NotNull Font var1);

    @Nullable
    public Font font(@NotNull Key var1);

    public boolean removeFont(@NotNull Key var1);

    @NotNull
    public Collection<Font> fonts();

    default public void font(@NotNull Key key, FontProvider ... providers) {
        this.font(Font.font(key, providers));
    }

    default public void font(@NotNull Key key, @NotNull List<FontProvider> providers) {
        this.font(Font.font(key, providers));
    }

    public void language(@NotNull Language var1);

    @Nullable
    public Language language(@NotNull Key var1);

    public boolean removeLanguage(@NotNull Key var1);

    @NotNull
    public Collection<Language> languages();

    public void model(@NotNull Model var1);

    @Nullable
    public Model model(@NotNull Key var1);

    public boolean removeModel(@NotNull Key var1);

    @NotNull
    public Collection<Model> models();

    public void soundRegistry(@NotNull SoundRegistry var1);

    @Nullable
    public SoundRegistry soundRegistry(@NotNull String var1);

    public boolean removeSoundRegistry(@NotNull String var1);

    @NotNull
    public Collection<SoundRegistry> soundRegistries();

    default public void soundEvent(@NotNull SoundEvent soundEvent) {
        Objects.requireNonNull(soundEvent, "soundEvent");
        String namespace = soundEvent.key().namespace();
        SoundRegistry soundRegistry = this.soundRegistry(namespace);
        HashSet<SoundEvent> soundEvents = soundRegistry == null ? new HashSet<SoundEvent>() : new HashSet<SoundEvent>(soundRegistry.sounds());
        soundEvents.add(soundEvent);
        this.soundRegistry(SoundRegistry.soundRegistry(namespace, soundEvents));
    }

    @Nullable
    default public SoundEvent soundEvent(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        SoundRegistry registry = this.soundRegistry(key.namespace());
        if (registry == null) {
            return null;
        }
        return registry.sound(key);
    }

    default public boolean removeSoundEvent(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        SoundRegistry registry = this.soundRegistry(key.namespace());
        if (registry == null) {
            return false;
        }
        HashSet<SoundEvent> sounds = new HashSet<SoundEvent>(registry.sounds());
        boolean removed = sounds.removeIf(sound -> sound.key().equals(key));
        this.soundRegistry(SoundRegistry.soundRegistry(key.namespace(), sounds));
        return removed;
    }

    @NotNull
    default public Collection<SoundEvent> soundEvents() {
        HashSet<SoundEvent> soundEvents = new HashSet<SoundEvent>();
        for (SoundRegistry soundRegistry : this.soundRegistries()) {
            soundEvents.addAll(soundRegistry.sounds());
        }
        return soundEvents;
    }

    public void sound(@NotNull Sound var1);

    @Nullable
    public Sound sound(@NotNull Key var1);

    public boolean removeSound(@NotNull Key var1);

    @NotNull
    public Collection<Sound> sounds();

    default public void sound(@NotNull Key key, @NotNull Writable data) {
        this.sound(Sound.sound(key, data));
    }

    public void texture(@NotNull Texture var1);

    @Nullable
    public Texture texture(@NotNull Key var1);

    public boolean removeTexture(@NotNull Key var1);

    @NotNull
    public Collection<Texture> textures();

    default public void texture(@NotNull Key key, @NotNull Writable data) {
        this.texture(Texture.texture(key, data));
    }

    default public void texture(@NotNull Key key, @NotNull Writable data, @NotNull Metadata meta) {
        this.texture(Texture.texture(key, data, meta));
    }

    default public void part(@NotNull ResourcePackPart part) {
        Objects.requireNonNull(part, "part");
        part.addTo(this);
    }

    public void unknownFile(@NotNull String var1, @NotNull Writable var2);

    @Nullable
    public Writable unknownFile(@NotNull String var1);

    public boolean removeUnknownFile(@NotNull String var1);

    @NotNull
    public Map<String, Writable> unknownFiles();

    public void merge(@NotNull ResourceContainer var1, @NotNull MergeStrategy var2);
}

