/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.pack;

import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.metadata.MetadataPart;
import team.unnamed.creative.metadata.pack.PackFormat;
import team.unnamed.creative.metadata.pack.PackMeta;

final class PackMetaImpl
implements PackMeta {
    private final PackFormat format;
    private final Component description;
    private String legacyDescription;

    PackMetaImpl(@NotNull PackFormat format, @NotNull Component description) {
        this.format = Objects.requireNonNull(format, "format");
        this.description = Objects.requireNonNull(description, "description");
    }

    @Override
    @NotNull
    public Class<? extends MetadataPart> type() {
        return PackMeta.class;
    }

    @Override
    @Deprecated
    public int format() {
        return this.format.format();
    }

    @Override
    @NotNull
    public PackFormat formats() {
        return this.format;
    }

    @Override
    @NotNull
    public String description() {
        if (this.legacyDescription != null) {
            return this.legacyDescription;
        }
        this.legacyDescription = LegacyComponentSerializer.legacySection().serialize(this.description);
        return this.legacyDescription;
    }

    @Override
    @NotNull
    public Component description0() {
        return this.description;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"format", (Object)this.format), ExaminableProperty.of((String)"description", (Object)this.description));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackMetaImpl packMeta = (PackMetaImpl)o;
        return this.format.equals(packMeta.format) && this.description.equals(packMeta.description);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.description);
    }
}

