/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.breaker;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.api.events.furniture.OraxenFurnitureDamageEvent;
import io.th0rgal.oraxen.api.events.noteblock.OraxenNoteBlockDamageEvent;
import io.th0rgal.oraxen.api.events.stringblock.OraxenStringBlockDamageEvent;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.ItemUtils;
import io.th0rgal.oraxen.utils.PotionUtils;
import io.th0rgal.oraxen.utils.blocksounds.BlockSounds;
import io.th0rgal.oraxen.utils.breaker.HardnessModifier;
import io.th0rgal.oraxen.utils.drops.Drop;
import io.th0rgal.oraxen.utils.wrappers.EnchantmentWrapper;
import io.th0rgal.protectionlib.ProtectionLib;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class BreakerSystem {
    public static final List<HardnessModifier> MODIFIERS = new ArrayList<HardnessModifier>();
    private final Map<Location, BukkitScheduler> breakerPerLocation = new HashMap<Location, BukkitScheduler>();
    private final Map<Location, BukkitTask> breakerPlaySound = new HashMap<Location, BukkitTask>();
    private final PacketAdapter listener = new PacketAdapter((Plugin)OraxenPlugin.get(), ListenerPriority.LOW, new PacketType[]{PacketType.Play.Client.BLOCK_DIG}){

        public void onPacketReceiving(PacketEvent event) {
            EnumWrappers.PlayerDigType type;
            PacketContainer packet = event.getPacket();
            final Player player = event.getPlayer();
            final ItemStack item = player.getInventory().getItemInMainHand();
            if (player.getGameMode() == GameMode.CREATIVE) {
                return;
            }
            StructureModifier dataTemp = packet.getBlockPositionModifier();
            StructureModifier dataDirection = packet.getDirections();
            StructureModifier data = packet.getEnumModifier(EnumWrappers.PlayerDigType.class, 2);
            try {
                type = (EnumWrappers.PlayerDigType)data.getValues().getFirst();
            }
            catch (IllegalArgumentException exception) {
                type = EnumWrappers.PlayerDigType.SWAP_HELD_ITEMS;
            }
            BlockPosition pos = (BlockPosition)dataTemp.getValues().getFirst();
            final World world = player.getWorld();
            final Block block = world.getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            final Location location = block.getLocation();
            BlockFace blockFace = dataDirection.size() > 0 ? BlockFace.valueOf((String)((EnumWrappers.Direction)dataDirection.read(0)).name()) : BlockFace.UP;
            HardnessModifier triggeredModifier = null;
            for (HardnessModifier modifier : MODIFIERS) {
                if (!modifier.isTriggered(player, block, item)) continue;
                triggeredModifier = modifier;
                break;
            }
            if (triggeredModifier == null) {
                return;
            }
            long period = triggeredModifier.getPeriod(player, block, item);
            if (period == 0L) {
                return;
            }
            NoteBlockMechanic noteMechanic = OraxenBlocks.getNoteBlockMechanic(block);
            StringBlockMechanic stringMechanic = OraxenBlocks.getStringMechanic(block);
            final FurnitureMechanic furnitureMechanic = OraxenFurniture.getFurnitureMechanic(block);
            if (block.getType() == Material.NOTE_BLOCK && noteMechanic == null) {
                return;
            }
            if (block.getType() == Material.TRIPWIRE && stringMechanic == null) {
                return;
            }
            if (block.getType() == Material.BARRIER && furnitureMechanic == null) {
                return;
            }
            event.setCancelled(true);
            if (type == EnumWrappers.PlayerDigType.START_DESTROY_BLOCK) {
                final Drop drop = furnitureMechanic != null ? (furnitureMechanic.getDrop() != null ? furnitureMechanic.getDrop() : Drop.emptyDrop()) : (noteMechanic != null ? (noteMechanic.getDrop() != null ? noteMechanic.getDrop() : Drop.emptyDrop()) : (stringMechanic != null ? (stringMechanic.getDrop() != null ? stringMechanic.getDrop() : Drop.emptyDrop()) : null));
                Bukkit.getScheduler().runTask((Plugin)OraxenPlugin.get(), () -> player.addPotionEffect(new PotionEffect(PotionUtils.getEffectType("mining_fatigue"), (int)(period * 11L), Integer.MAX_VALUE, false, false, false)));
                if (BreakerSystem.this.breakerPerLocation.containsKey(location)) {
                    BreakerSystem.this.breakerPerLocation.get(location).cancelTasks((Plugin)OraxenPlugin.get());
                }
                final BukkitScheduler scheduler = Bukkit.getScheduler();
                PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(player, Action.LEFT_CLICK_BLOCK, player.getInventory().getItemInMainHand(), block, blockFace, EquipmentSlot.HAND);
                scheduler.runTask((Plugin)OraxenPlugin.get(), () -> Bukkit.getPluginManager().callEvent((Event)playerInteractEvent));
                BreakerSystem.this.breakerPerLocation.put(location, scheduler);
                if (BreakerSystem.this.blockDamageEventCancelled(block, player)) {
                    BreakerSystem.this.stopBlockBreaker(location);
                    return;
                }
                final List<Location> furnitureBarrierLocations = BreakerSystem.this.furnitureBarrierLocations(furnitureMechanic, block);
                final HardnessModifier modifier = triggeredModifier;
                BreakerSystem.this.startBlockHitSound(location);
                scheduler.runTaskTimer((Plugin)OraxenPlugin.get(), (Consumer)new Consumer<BukkitTask>(){
                    int value = 0;

                    @Override
                    public void accept(BukkitTask bukkitTask) {
                        Player viewer;
                        if (!BreakerSystem.this.breakerPerLocation.containsKey(location)) {
                            bukkitTask.cancel();
                            BreakerSystem.this.stopBlockHitSound(location);
                            return;
                        }
                        if (item.getEnchantmentLevel(EnchantmentWrapper.EFFICIENCY) >= 5) {
                            this.value = 10;
                        }
                        for (Entity entity : world.getNearbyEntities(location, 16.0, 16.0, 16.0)) {
                            if (!(entity instanceof Player)) continue;
                            viewer = (Player)entity;
                            if (furnitureMechanic != null) {
                                for (Location barrierLoc : furnitureBarrierLocations) {
                                    BreakerSystem.this.sendBlockBreak(viewer, barrierLoc, this.value);
                                }
                                continue;
                            }
                            BreakerSystem.this.sendBlockBreak(viewer, location, this.value);
                        }
                        if (this.value++ < 10) {
                            return;
                        }
                        if (EventUtils.callEvent((Event)new BlockBreakEvent(block, player)) && ProtectionLib.canBreak(player, location)) {
                            ItemUtils.damageItem(player, drop, item);
                            modifier.breakBlock(player, block, item);
                        } else {
                            BreakerSystem.this.stopBlockHitSound(location);
                        }
                        scheduler.runTask((Plugin)OraxenPlugin.get(), () -> player.removePotionEffect(PotionUtils.getEffectType("mining_fatigue")));
                        BreakerSystem.this.stopBlockBreaker(location);
                        BreakerSystem.this.stopBlockHitSound(location);
                        for (Entity entity : world.getNearbyEntities(location, 16.0, 16.0, 16.0)) {
                            if (!(entity instanceof Player)) continue;
                            viewer = (Player)entity;
                            if (furnitureMechanic != null) {
                                for (Location barrierLoc : furnitureBarrierLocations) {
                                    BreakerSystem.this.sendBlockBreak(viewer, barrierLoc, this.value);
                                }
                                continue;
                            }
                            BreakerSystem.this.sendBlockBreak(viewer, location, this.value);
                        }
                        bukkitTask.cancel();
                    }
                }, period, period);
            } else {
                Bukkit.getScheduler().runTask((Plugin)OraxenPlugin.get(), () -> {
                    player.removePotionEffect(PotionUtils.getEffectType("mining_fatigue"));
                    if (!ProtectionLib.canBreak(player, location)) {
                        player.sendBlockChange(location, block.getBlockData());
                    }
                    for (Entity entity : world.getNearbyEntities(location, 16.0, 16.0, 16.0)) {
                        if (!(entity instanceof Player)) continue;
                        Player viewer = (Player)entity;
                        BreakerSystem.this.sendBlockBreak(viewer, location, 10);
                    }
                    BreakerSystem.this.stopBlockBreaker(location);
                    BreakerSystem.this.stopBlockHitSound(location);
                });
            }
        }
    };

    private List<Location> furnitureBarrierLocations(FurnitureMechanic furnitureMechanic, Block block) {
        BukkitScheduler scheduler = this.breakerPerLocation.get(block.getLocation());
        if (scheduler == null) {
            return List.of(block.getLocation());
        }
        AtomicReference furnitureBaseEntity = new AtomicReference();
        scheduler.runTask((Plugin)OraxenPlugin.get(), () -> furnitureBaseEntity.set(furnitureMechanic != null ? furnitureMechanic.getBaseEntity(block) : null));
        return furnitureMechanic != null && furnitureBaseEntity.get() != null ? furnitureMechanic.getLocations(FurnitureMechanic.getFurnitureYaw((Entity)furnitureBaseEntity.get()), ((Entity)furnitureBaseEntity.get()).getLocation(), furnitureMechanic.getBarriers()) : Collections.singletonList(block.getLocation());
    }

    private boolean blockDamageEventCancelled(Block block, Player player) {
        BukkitScheduler scheduler = this.breakerPerLocation.get(block.getLocation());
        if (scheduler == null) {
            return false;
        }
        switch (block.getType()) {
            case NOTE_BLOCK: {
                NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
                if (mechanic == null) {
                    return true;
                }
                OraxenNoteBlockDamageEvent event = new OraxenNoteBlockDamageEvent(mechanic, block, player);
                scheduler.runTask((Plugin)OraxenPlugin.get(), () -> Bukkit.getPluginManager().callEvent((Event)event));
                return event.isCancelled();
            }
            case TRIPWIRE: {
                StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(block);
                if (mechanic == null) {
                    return true;
                }
                OraxenStringBlockDamageEvent event = new OraxenStringBlockDamageEvent(mechanic, block, player);
                scheduler.runTask((Plugin)OraxenPlugin.get(), () -> Bukkit.getPluginManager().callEvent((Event)event));
                return event.isCancelled();
            }
            case BARRIER: {
                try {
                    return (Boolean)scheduler.callSyncMethod((Plugin)OraxenPlugin.get(), () -> {
                        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(block);
                        if (mechanic == null) {
                            return true;
                        }
                        Entity baseEntity = mechanic.getBaseEntity(block);
                        if (baseEntity == null) {
                            return true;
                        }
                        OraxenFurnitureDamageEvent event = new OraxenFurnitureDamageEvent(mechanic, baseEntity, player, block);
                        scheduler.runTask((Plugin)OraxenPlugin.get(), () -> Bukkit.getPluginManager().callEvent((Event)event));
                        return event.isCancelled();
                    }).get();
                }
                catch (Exception e) {
                    return false;
                }
            }
            case BEDROCK: {
                return false;
            }
        }
        return true;
    }

    private void sendBlockBreak(Player player, Location location, int stage) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.BLOCK_BREAK_ANIMATION);
        packet.getIntegers().write(0, (Object)location.hashCode()).write(1, (Object)stage);
        packet.getBlockPositionModifier().write(0, (Object)new BlockPosition(location.toVector()));
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    private void stopBlockBreaker(Location location) {
        if (this.breakerPerLocation.containsKey(location)) {
            this.breakerPerLocation.get(location).cancelTasks((Plugin)OraxenPlugin.get());
            this.breakerPerLocation.remove(location);
        }
    }

    private void startBlockHitSound(Location location) {
        BukkitScheduler scheduler = this.breakerPerLocation.get(location);
        BlockSounds blockSounds = this.getBlockSounds(location.getBlock());
        if (scheduler == null || blockSounds == null || !blockSounds.hasHitSound()) {
            this.stopBlockHitSound(location);
            return;
        }
        this.breakerPlaySound.put(location, scheduler.runTaskTimer((Plugin)OraxenPlugin.get(), () -> BlockHelpers.playCustomBlockSound(location, this.getHitSound(location.getBlock()), blockSounds.getHitVolume(), blockSounds.getHitPitch()), 0L, 4L));
    }

    private void stopBlockHitSound(Location location) {
        Optional.ofNullable(this.breakerPlaySound.get(location)).ifPresent(BukkitTask::cancel);
        this.breakerPlaySound.remove(location);
    }

    public void registerListener() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.listener);
    }

    private BlockSounds getBlockSounds(Block block) {
        ConfigurationSection soundSection = OraxenPlugin.get().getConfigsManager().getMechanics().getConfigurationSection("custom_block_sounds");
        if (soundSection == null) {
            return null;
        }
        switch (block.getType()) {
            case NOTE_BLOCK: {
                NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
                if (mechanic == null || !mechanic.hasBlockSounds()) {
                    return null;
                }
                if (!soundSection.getBoolean("noteblock_and_block")) {
                    return null;
                }
                return mechanic.getBlockSounds();
            }
            case MUSHROOM_STEM: {
                BlockMechanic mechanic = BlockMechanicFactory.getBlockMechanic(block);
                if (mechanic == null || !mechanic.hasBlockSounds()) {
                    return null;
                }
                if (!soundSection.getBoolean("noteblock_and_block")) {
                    return null;
                }
                return mechanic.getBlockSounds();
            }
            case TRIPWIRE: {
                StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(block);
                if (mechanic == null || !mechanic.hasBlockSounds()) {
                    return null;
                }
                if (!soundSection.getBoolean("stringblock_and_furniture")) {
                    return null;
                }
                return mechanic.getBlockSounds();
            }
            case BARRIER: {
                FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(block);
                if (mechanic == null || !mechanic.hasBlockSounds()) {
                    return null;
                }
                if (!soundSection.getBoolean("stringblock_and_furniture")) {
                    return null;
                }
                return mechanic.getBlockSounds();
            }
        }
        return null;
    }

    private String getHitSound(Block block) {
        ConfigurationSection soundSection = OraxenPlugin.get().getConfigsManager().getMechanics().getConfigurationSection("custom_block_sounds");
        if (soundSection == null) {
            return null;
        }
        BlockSounds sounds = this.getBlockSounds(block);
        if (sounds == null) {
            return null;
        }
        return switch (block.getType()) {
            case Material.NOTE_BLOCK, Material.MUSHROOM_STEM -> {
                if (sounds.hasHitSound()) {
                    yield sounds.getHitSound();
                }
                yield "required.wood.hit";
            }
            case Material.TRIPWIRE -> {
                if (sounds.hasHitSound()) {
                    yield sounds.getHitSound();
                }
                yield "block.tripwire.detach";
            }
            case Material.BARRIER -> {
                if (sounds.hasHitSound()) {
                    yield sounds.getHitSound();
                }
                yield "required.stone.hit";
            }
            default -> block.getBlockData().getSoundGroup().getHitSound().getKey().toString();
        };
    }
}

