/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.container;

import dev.triumphteam.gui.click.handler.ClickHandler;
import dev.triumphteam.gui.container.GuiContainer;
import dev.triumphteam.gui.container.type.GuiContainerType;
import dev.triumphteam.gui.item.GuiItem;
import dev.triumphteam.gui.item.RenderedGuiItem;
import dev.triumphteam.gui.slot.Slot;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class MapBackedContainer<P, I>
implements GuiContainer<P, I> {
    private final Map<Integer, RenderedGuiItem<P, I>> backing = new HashMap<Integer, RenderedGuiItem<P, I>>(100);
    private final ClickHandler<P> clickHandler;
    private final GuiContainerType containerType;

    public MapBackedContainer(@NotNull ClickHandler<P> clickHandler, @NotNull GuiContainerType containerType) {
        this.clickHandler = clickHandler;
        this.containerType = containerType;
    }

    @Override
    @NotNull
    public GuiContainerType containerType() {
        return null;
    }

    @Override
    public void set(int row, int column, @NotNull @NotNull GuiItem<@NotNull P, @NotNull I> guiItem) {
        this.set(this.containerType.mapSlot(Slot.of(row, column)), guiItem);
    }

    @Override
    public void set(@NotNull Slot slot, @NotNull @NotNull GuiItem<@NotNull P, @NotNull I> guiItem) {
        this.set(this.containerType.mapSlot(slot), guiItem);
    }

    @Override
    public void set(int slot, @NotNull @NotNull GuiItem<@NotNull P, @NotNull I> guiItem) {
        RenderedGuiItem<P, I> renderedItem = new RenderedGuiItem<P, I>(guiItem.render(), this.clickHandler, guiItem.getClickAction());
        this.backing.put(slot, renderedItem);
    }

    @NotNull
    public Map<Integer, RenderedGuiItem<P, I>> complete() {
        return Collections.unmodifiableMap(this.backing);
    }
}

