/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.Flippable;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.Rotatable;
import com.github.stefvanschie.inventoryframework.pane.util.Pattern;
import com.github.stefvanschie.inventoryframework.pane.util.Slot;
import com.github.stefvanschie.inventoryframework.util.GeometryUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PatternPane
extends Pane
implements Flippable,
Rotatable {
    @NotNull
    private Pattern pattern;
    @NotNull
    private final Map<Integer, GuiItem> bindings = new HashMap<Integer, GuiItem>();
    private int rotation;
    private boolean flippedHorizontally;
    private boolean flippedVertically;

    public PatternPane(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority, @NotNull Pattern pattern) {
        super(slot, length, height, priority);
        if (pattern.getLength() != length || pattern.getHeight() != height) {
            throw new IllegalArgumentException("Dimensions of the provided pattern do not match the dimensions of the pane");
        }
        this.pattern = pattern;
    }

    public PatternPane(int x, int y, int length, int height, @NotNull Pane.Priority priority, @NotNull Pattern pattern) {
        this(Slot.fromXY(x, y), length, height, priority, pattern);
    }

    public PatternPane(int length, int height, @NotNull Pattern pattern) {
        this(0, 0, length, height, pattern);
    }

    public PatternPane(@NotNull Slot slot, int length, int height, @NotNull Pattern pattern) {
        this(slot, length, height, Pane.Priority.NORMAL, pattern);
    }

    public PatternPane(int x, int y, int length, int height, @NotNull Pattern pattern) {
        this(x, y, length, height, Pane.Priority.NORMAL, pattern);
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        for (int x = 0; x < length; ++x) {
            for (int y = 0; y < height; ++y) {
                GuiItem item = this.bindings.get(this.pattern.getCharacter(x, y));
                if (item == null || !item.isVisible()) continue;
                int newX = x;
                int newY = y;
                if (this.isFlippedHorizontally()) {
                    newX = length - x - 1;
                }
                if (this.isFlippedVertically()) {
                    newY = height - y - 1;
                }
                Map.Entry<Integer, Integer> coordinates = GeometryUtil.processClockwiseRotation(newX, newY, length, height, this.rotation);
                newX = coordinates.getKey();
                newY = coordinates.getValue();
                Slot slot = this.getSlot();
                int finalRow = slot.getY(maxLength) + newY + paneOffsetY;
                int finalColumn = slot.getX(maxLength) + newX + paneOffsetX;
                inventoryComponent.setItem(item, finalColumn, finalRow);
            }
        }
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        Slot paneSlot = this.getSlot();
        int xPosition = paneSlot.getX(maxLength);
        int yPosition = paneSlot.getY(maxLength);
        int totalLength = inventoryComponent.getLength();
        int adjustedSlot = slot - (xPosition + paneOffsetX) - totalLength * (yPosition + paneOffsetY);
        int x = adjustedSlot % totalLength;
        int y = adjustedSlot / totalLength;
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        this.callOnClick(event);
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return false;
        }
        GuiItem clickedItem = PatternPane.findMatchingItem(this.getItems(), itemStack);
        if (clickedItem == null) {
            return false;
        }
        clickedItem.callAction(event);
        return true;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public PatternPane copy() {
        PatternPane patternPane = new PatternPane(this.getSlot(), this.getLength(), this.getHeight(), this.getPriority(), this.getPattern());
        patternPane.setVisible(this.isVisible());
        patternPane.onClick = this.onClick;
        patternPane.uuid = this.uuid;
        patternPane.setRotation(this.getRotation());
        patternPane.flipHorizontally(this.isFlippedHorizontally());
        patternPane.flipVertically(this.isFlippedVertically());
        return patternPane;
    }

    @Override
    public void setRotation(int rotation) {
        if (this.getLength() != this.getHeight()) {
            throw new IllegalArgumentException("Rotations can only be applied to square panes");
        }
        if (rotation >= 0 && rotation % 90 != 0) {
            throw new IllegalArgumentException("Rotation must be non-negative and be a multiple of 90");
        }
        this.rotation = rotation % 360;
    }

    @Override
    @NotNull
    public Collection<GuiItem> getItems() {
        HashSet<GuiItem> items = new HashSet<GuiItem>();
        for (Map.Entry<Integer, GuiItem> binding : this.bindings.entrySet()) {
            if (!this.pattern.contains(binding.getKey())) continue;
            items.add(binding.getValue());
        }
        return Collections.unmodifiableCollection(items);
    }

    public void setPattern(@NotNull Pattern pattern) {
        if (pattern.getLength() != this.getLength() || pattern.getHeight() != this.getHeight()) {
            throw new IllegalArgumentException("Dimensions of the provided pattern do not match the dimensions of the pane");
        }
        this.pattern = pattern;
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.pattern = this.pattern.setHeight(height);
    }

    @Override
    public void setLength(int length) {
        super.setLength(length);
        this.pattern = this.pattern.setLength(length);
    }

    public void bindItem(char character, @NotNull GuiItem item) {
        this.bindings.put(Integer.valueOf(character), item);
    }

    public void bindItem(int character, @NotNull GuiItem item) {
        this.bindings.put(character, item);
    }

    @Override
    public void clear() {
        this.bindings.clear();
    }

    @Override
    public void flipHorizontally(boolean flipHorizontally) {
        this.flippedHorizontally = flipHorizontally;
    }

    @Override
    public void flipVertically(boolean flipVertically) {
        this.flippedVertically = flipVertically;
    }

    @Override
    @NotNull
    public Collection<Pane> getPanes() {
        return Collections.emptySet();
    }

    @NotNull
    @Contract(pure=true)
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isFlippedHorizontally() {
        return this.flippedHorizontally;
    }

    @Override
    public boolean isFlippedVertically() {
        return this.flippedVertically;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @NotNull
    public static PatternPane load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        try {
            NodeList childNodes = element.getChildNodes();
            Pattern pattern = null;
            HashMap<Integer, GuiItem> bindings = new HashMap<Integer, GuiItem>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1) continue;
                Element child = (Element)item;
                String name = item.getNodeName();
                if (name.equals("pattern")) {
                    pattern = Pattern.load(child);
                    continue;
                }
                if (name.equals("binding")) {
                    String character = child.getAttribute("char");
                    if (character == null) {
                        throw new XMLLoadException("Missing char attribute on binding");
                    }
                    if (character.codePointCount(0, character.length()) != 1) {
                        throw new XMLLoadException("Char attribute doesn't have one character");
                    }
                    NodeList children = child.getChildNodes();
                    GuiItem guiItem = null;
                    for (int index = 0; index < children.getLength(); ++index) {
                        Node guiItemNode = children.item(index);
                        if (guiItemNode.getNodeType() != 1) continue;
                        if (guiItem != null) {
                            throw new XMLLoadException("Binding has multiple inner tags, one expected");
                        }
                        guiItem = Pane.loadItem(instance, (Element)guiItemNode, plugin);
                    }
                    bindings.put(character.codePoints().toArray()[0], guiItem);
                    continue;
                }
                throw new XMLLoadException("Unknown tag " + name + " in pattern pane");
            }
            if (pattern == null) {
                throw new XMLLoadException("Pattern pane doesn't have a pattern");
            }
            PatternPane patternPane = new PatternPane(Integer.parseInt(element.getAttribute("length")), Integer.parseInt(element.getAttribute("height")), pattern);
            Pane.load(patternPane, instance, element);
            Flippable.load(patternPane, element);
            Rotatable.load(patternPane, element);
            if (!element.hasAttribute("populate")) {
                for (Map.Entry entry : bindings.entrySet()) {
                    patternPane.bindItem((Integer)entry.getKey(), (GuiItem)entry.getValue());
                }
            }
            return patternPane;
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
    }

    @Deprecated
    @NotNull
    public static PatternPane load(@NotNull Object instance, @NotNull Element element) {
        return PatternPane.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(PatternPane.class));
    }
}

