/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.sound;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSound {
    private final String name;
    private final SoundCategory category;
    private final String subtitle;
    private final boolean replace;
    private final List<String> sounds = new ArrayList<String>();

    public CustomSound(@NotNull String name, @NotNull List<String> sounds, SoundCategory category, boolean replace, String subtitle) {
        this.name = name;
        ArrayList<String> temp = new ArrayList<String>();
        for (String sound : sounds) {
            if (sound == null) continue;
            temp.add(sound.replace(".ogg", ""));
        }
        this.sounds.addAll(temp);
        this.category = category == null ? SoundCategory.MASTER : category;
        this.replace = replace;
        this.subtitle = subtitle;
    }

    public void play(@NotNull Player player, @NotNull Location location) {
        this.play(player, location, 1.0f, 1.0f);
    }

    public void play(@NotNull Player player, @NotNull Location location, float volume, float pitch) {
        this.play(player, location, this.category, volume, pitch);
    }

    public void play(@NotNull Player player, @NotNull Location location, @NotNull SoundCategory category, float volume, float pitch) {
        player.playSound(location, this.name, category, volume, pitch);
    }

    public void stop(@NotNull Player player) {
        this.stop(player, null);
    }

    public void stop(@NotNull Player player, @Nullable SoundCategory category) {
        player.stopSound(this.name, category);
    }

    public String getName() {
        return this.name;
    }

    public SoundCategory getCategory() {
        return this.category;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public List<String> getSounds() {
        return new ArrayList<String>(this.sounds);
    }

    public JsonObject toJson() {
        JsonObject output = new JsonObject();
        if (this.category != null) {
            output.addProperty("category", this.category.toString().toLowerCase(Locale.ROOT));
        }
        if (this.replace) {
            output.addProperty("replace", Boolean.valueOf(true));
        }
        if (this.subtitle != null) {
            output.addProperty("subtitle", this.subtitle);
        }
        JsonArray sounds = new JsonArray();
        if (this.sounds.isEmpty()) {
            sounds.getAsJsonArray();
        } else {
            for (String sound : this.sounds) {
                sounds.add(sound);
            }
        }
        output.add("sounds", (JsonElement)sounds);
        return output;
    }
}

