/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.items;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.compatibilities.provided.ecoitems.WrappedEcoItem;
import io.th0rgal.oraxen.compatibilities.provided.mmoitems.WrappedMMOItem;
import io.th0rgal.oraxen.compatibilities.provided.mythiccrucible.WrappedCrucibleItem;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.items.ItemTemplate;
import io.th0rgal.oraxen.items.ModelData;
import io.th0rgal.oraxen.items.OraxenMeta;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.PotionUtils;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemParser {
    public static final Map<String, ModelData> MODEL_DATAS_BY_ID = new HashMap<String, ModelData>();
    private final OraxenMeta oraxenMeta;
    private final ConfigurationSection section;
    private final Material type;
    private WrappedMMOItem mmoItem;
    private WrappedCrucibleItem crucibleItem;
    private WrappedEcoItem ecoItem;
    private ItemParser templateItem;
    private boolean configUpdated = false;

    public ItemParser(ConfigurationSection section) {
        this.section = section;
        if (section.isString("template")) {
            this.templateItem = ItemTemplate.getParserTemplate(section.getString("template"));
        }
        ConfigurationSection crucibleSection = section.getConfigurationSection("crucible");
        ConfigurationSection mmoSection = section.getConfigurationSection("mmoitem");
        ConfigurationSection ecoItemSection = section.getConfigurationSection("ecoitem");
        if (crucibleSection != null) {
            this.crucibleItem = new WrappedCrucibleItem(crucibleSection);
        } else if (section.isString("crucible_id")) {
            this.crucibleItem = new WrappedCrucibleItem(section.getString("crucible_id"));
        } else if (ecoItemSection != null) {
            this.ecoItem = new WrappedEcoItem(ecoItemSection);
        } else if (section.isString("ecoitem_id")) {
            this.ecoItem = new WrappedEcoItem(section.getString("ecoitem_id"));
        } else if (mmoSection != null) {
            this.mmoItem = new WrappedMMOItem(mmoSection);
        }
        Material material = Material.getMaterial((String)section.getString("material", ""));
        if (material == null) {
            material = this.usesTemplate() ? this.templateItem.type : Material.PAPER;
        }
        this.type = material;
        this.oraxenMeta = new OraxenMeta();
        if (section.isConfigurationSection("Pack")) {
            ConfigurationSection packSection = section.getConfigurationSection("Pack");
            this.oraxenMeta.setPackInfos(packSection);
            assert (packSection != null);
            if (packSection.isInt("custom_model_data")) {
                MODEL_DATAS_BY_ID.put(section.getName(), new ModelData(this.type, this.oraxenMeta.getModelName(), packSection.getInt("custom_model_data")));
            }
        }
    }

    public boolean usesMMOItems() {
        return this.crucibleItem == null && this.ecoItem == null && this.mmoItem != null && this.mmoItem.build() != null;
    }

    public boolean usesCrucibleItems() {
        return this.mmoItem == null && this.ecoItem == null && this.crucibleItem != null && this.crucibleItem.build() != null;
    }

    public boolean usesEcoItems() {
        return this.mmoItem == null && this.crucibleItem == null && this.ecoItem != null && this.ecoItem.build() != null;
    }

    public boolean usesTemplate() {
        return this.templateItem != null;
    }

    public ItemBuilder buildItem() {
        ItemBuilder item = this.usesCrucibleItems() ? new ItemBuilder(this.crucibleItem) : (this.usesMMOItems() ? new ItemBuilder(this.mmoItem) : (this.usesEcoItems() ? new ItemBuilder(this.ecoItem) : new ItemBuilder(this.type)));
        return this.applyConfig(this.usesTemplate() ? this.templateItem.applyConfig(item) : item);
    }

    private ItemBuilder applyConfig(ItemBuilder item) {
        if (!VersionUtil.atOrAbove("1.20.5") && this.section.contains("displayname")) {
            item.setDisplayName(this.section.getString("displayname", ""));
        }
        if (this.section.contains("lore")) {
            item.setLore(this.section.getStringList("lore").stream().map(AdventureUtils::parseMiniMessage).toList());
        }
        if (this.section.contains("unbreakable")) {
            item.setUnbreakable(this.section.getBoolean("unbreakable", false));
        }
        if (this.section.contains("unstackable")) {
            item.setUnstackable(this.section.getBoolean("unstackable", false));
        }
        if (this.section.contains("color")) {
            item.setColor(Utils.toColor(this.section.getString("color", "#FFFFFF")));
        }
        if (this.section.contains("trim_pattern")) {
            item.setTrimPattern(Key.key((String)this.section.getString("trim_pattern", "")));
        }
        this.parseDataComponents(item);
        this.parseMiscOptions(item);
        this.parseVanillaSections(item);
        this.parseOraxenSections(item);
        item.setOraxenMeta(this.oraxenMeta);
        return item;
    }

    private void parseDataComponents(ItemBuilder item) {
        ConfigurationSection foodSection;
        if (this.section.contains("itemname") && VersionUtil.atOrAbove("1.20.5")) {
            item.setItemName(this.section.getString("itemname"));
        } else if (this.section.contains("displayname")) {
            item.setItemName(this.section.getString("displayname"));
        }
        ConfigurationSection components = this.section.getConfigurationSection("Components");
        if (components == null || !VersionUtil.atOrAbove("1.20.5")) {
            return;
        }
        if (components.contains("max_stack_size")) {
            item.setMaxStackSize(Math.clamp((long)components.getInt("max_stack_size"), 1, 99));
        }
        if (components.contains("enchantment_glint_override")) {
            item.setEnchantmentGlindOverride(components.getBoolean("enchantment_glint_override"));
        }
        if (components.contains("durability")) {
            item.setDamagedOnBlockBreak(components.getBoolean("durability.damage_block_break"));
            item.setDamagedOnEntityHit(components.getBoolean("durability.damage_entity_hit"));
            item.setDurability(Math.max(components.getInt("durability.value"), components.getInt("durability", 1)));
        }
        if (components.contains("rarity")) {
            item.setRarity(ItemRarity.valueOf((String)components.getString("rarity")));
        }
        if (components.contains("fire_resistant")) {
            item.setFireResistant(components.getBoolean("fire_resistant"));
        }
        if (components.contains("hide_tooltips")) {
            item.setHideToolTips(components.getBoolean("hide_tooltips"));
        }
        if ((foodSection = components.getConfigurationSection("food")) != null) {
            FoodComponent foodComponent = new ItemStack(Material.PAPER).getItemMeta().getFood();
            foodComponent.setNutrition(foodSection.getInt("nutrition"));
            foodComponent.setSaturation((float)foodSection.getDouble("saturation", 0.0));
            foodComponent.setCanAlwaysEat(foodSection.getBoolean("can_always_eat"));
            foodComponent.setEatSeconds((float)foodSection.getDouble("eat_seconds", 1.6));
            ConfigurationSection effectsSection = foodSection.getConfigurationSection("effects");
            if (effectsSection != null) {
                for (String effect : effectsSection.getKeys(false)) {
                    PotionEffectType effectType = PotionUtils.getEffectType(effect);
                    if (effectType == null) {
                        Logs.logError("Invalid potion effect: " + effect + ", in " + StringUtils.substringBefore((String)effectsSection.getCurrentPath(), (String)".") + " food-property!");
                        continue;
                    }
                    foodComponent.addEffect(new PotionEffect(effectType, foodSection.getInt("duration", 1) * 20, foodSection.getInt("amplifier", 0), foodSection.getBoolean("ambient", true), foodSection.getBoolean("show_particles", true), foodSection.getBoolean("show_icon", true)), (float)foodSection.getDouble("probability", 1.0));
                }
            }
            item.setFoodComponent(foodComponent);
        }
        if (!VersionUtil.atOrAbove("1.21")) {
            return;
        }
        ConfigurationSection jukeboxSection = components.getConfigurationSection("jukebox_playable");
        if (jukeboxSection != null) {
            JukeboxPlayableComponent jukeboxPlayable = new ItemStack(Material.MUSIC_DISC_CREATOR).getItemMeta().getJukeboxPlayable();
            jukeboxPlayable.setShowInTooltip(jukeboxSection.getBoolean("show_in_tooltip"));
            jukeboxPlayable.setSongKey(NamespacedKey.fromString((String)jukeboxSection.getString("song_key")));
            item.setJukeboxPlayable(jukeboxPlayable);
        }
    }

    private void parseMiscOptions(ItemBuilder item) {
        this.oraxenMeta.setNoUpdate(this.section.getBoolean("no_auto_update", false));
        this.oraxenMeta.setDisableEnchanting(this.section.getBoolean("disable_enchanting", false));
        this.oraxenMeta.setExcludedFromInventory(this.section.getBoolean("excludeFromInventory", false));
        this.oraxenMeta.setExcludedFromCommands(this.section.getBoolean("excludeFromCommands", false));
        if (this.section.getBoolean("injectId", true)) {
            item.setCustomTag(OraxenItems.ITEM_ID, PersistentDataType.STRING, this.section.getName());
        }
    }

    private void parseVanillaSections(ItemBuilder item) {
        ConfigurationSection enchantSection;
        List attributes;
        if (this.section.contains("ItemFlags")) {
            List itemFlags = this.section.getStringList("ItemFlags");
            for (String itemFlag : itemFlags) {
                item.addItemFlags(ItemFlag.valueOf((String)itemFlag));
            }
        }
        if (this.section.contains("PotionEffects")) {
            List potionEffects = this.section.getList("PotionEffects");
            if (potionEffects == null) {
                return;
            }
            for (Map serializedPotionEffect : potionEffects) {
                PotionEffectType effect = PotionUtils.getEffectType(serializedPotionEffect.getOrDefault("type", ""));
                if (effect == null) {
                    return;
                }
                int duration = serializedPotionEffect.getOrDefault("duration", 60);
                int amplifier = serializedPotionEffect.getOrDefault("amplifier", 0);
                boolean ambient = serializedPotionEffect.getOrDefault("ambient", true);
                boolean particles = serializedPotionEffect.getOrDefault("particles", true);
                boolean icon = serializedPotionEffect.getOrDefault("icon", true);
                item.addPotionEffect(new PotionEffect(effect, duration, amplifier, ambient, particles, icon));
            }
        }
        if (this.section.contains("PersistentData")) {
            try {
                List dataHolder = this.section.getList("PersistentData");
                for (LinkedHashMap attributeJson : dataHolder) {
                    String[] keyContent = ((String)attributeJson.get("key")).split(":");
                    Object persistentDataType = PersistentDataType.class.getDeclaredField((String)attributeJson.get("type")).get(null);
                    item.addCustomTag(new NamespacedKey(keyContent[0], keyContent[1]), (PersistentDataType)persistentDataType, attributeJson.get("value"));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (this.section.contains("AttributeModifiers") && (attributes = this.section.getList("AttributeModifiers")) != null) {
            for (LinkedHashMap attributeJson : attributes) {
                attributeJson.putIfAbsent("uuid", UUID.randomUUID().toString());
                attributeJson.putIfAbsent("name", "oraxen:modifier");
                attributeJson.putIfAbsent("key", "oraxen:modifier");
                AttributeModifier attributeModifier = AttributeModifier.deserialize((Map)attributeJson);
                Attribute attribute = Attribute.valueOf((String)((String)attributeJson.get("attribute")));
                item.addAttributeModifiers(attribute, attributeModifier);
            }
        }
        if (this.section.contains("Enchantments") && (enchantSection = this.section.getConfigurationSection("Enchantments")) != null) {
            for (String enchant : enchantSection.getKeys(false)) {
                item.addEnchant(EnchantmentWrapper.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchant)), enchantSection.getInt(enchant));
            }
        }
    }

    private void parseOraxenSections(ItemBuilder item) {
        ConfigurationSection mechanicsSection = this.section.getConfigurationSection("Mechanics");
        if (mechanicsSection != null) {
            for (String mechanicID : mechanicsSection.getKeys(false)) {
                Mechanic mechanic;
                ConfigurationSection mechanicSection;
                MechanicFactory factory = MechanicsManager.getMechanicFactory(mechanicID);
                if (factory == null || (mechanicSection = mechanicsSection.getConfigurationSection(mechanicID)) == null || (mechanic = factory.parse(mechanicSection)) == null) continue;
                for (Function<ItemBuilder, ItemBuilder> itemModifier : mechanic.getItemModifiers()) {
                    item = itemModifier.apply(item);
                }
            }
        }
        if (this.oraxenMeta.hasPackInfos()) {
            int customModelData;
            if (MODEL_DATAS_BY_ID.containsKey(this.section.getName())) {
                customModelData = MODEL_DATAS_BY_ID.get(this.section.getName()).getModelData();
            } else {
                customModelData = ModelData.generateId(this.oraxenMeta.getModelName(), this.type);
                this.configUpdated = true;
                if (!Settings.DISABLE_AUTOMATIC_MODEL_DATA.toBool().booleanValue()) {
                    this.section.getConfigurationSection("Pack").set("custom_model_data", (Object)customModelData);
                }
            }
            item.setCustomModelData(customModelData);
            this.oraxenMeta.setCustomModelData(customModelData);
        }
    }

    public boolean isConfigUpdated() {
        return this.configUpdated;
    }
}

