/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.api;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.items.ItemParser;
import io.th0rgal.oraxen.items.ModelData;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.pack.generation.DuplicationHandler;
import io.th0rgal.oraxen.utils.AdventureUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.math.NumberUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class OraxenItems {
    public static final NamespacedKey ITEM_ID = new NamespacedKey((Plugin)OraxenPlugin.get(), "id");
    private static Map<File, Map<String, ItemBuilder>> map;
    private static Set<String> items;

    public static void loadItems() {
        ItemParser.MODEL_DATAS_BY_ID.clear();
        ModelData.DATAS.clear();
        OraxenPlugin.get().getConfigsManager().assignAllUsedModelDatas();
        OraxenPlugin.get().getConfigsManager().parseAllItemTemplates();
        DuplicationHandler.convertOldMigrateItemConfig();
        map = OraxenPlugin.get().getConfigsManager().parseItemConfig();
        items = new HashSet<String>();
        for (Map<String, ItemBuilder> subMap : map.values()) {
            items.addAll(subMap.keySet());
        }
    }

    public static String getIdByItem(ItemBuilder item) {
        return (String)item.getCustomTag(ITEM_ID, PersistentDataType.STRING);
    }

    public static String getIdByItem(ItemStack item) {
        return item == null || item.getItemMeta() == null || item.getItemMeta().getPersistentDataContainer().isEmpty() ? null : (String)item.getItemMeta().getPersistentDataContainer().get(ITEM_ID, PersistentDataType.STRING);
    }

    public static boolean exists(String itemId) {
        return items.contains(itemId);
    }

    public static boolean exists(ItemStack itemStack) {
        return items.contains(OraxenItems.getIdByItem(itemStack));
    }

    public static Optional<ItemBuilder> getOptionalItemById(String id) {
        return OraxenItems.entryStream().filter(entry -> ((String)entry.getKey()).equals(id)).findFirst().map(Map.Entry::getValue);
    }

    public static ItemBuilder getItemById(String id) {
        return OraxenItems.getOptionalItemById(id).orElse(null);
    }

    public static ItemBuilder getBuilderByItem(ItemStack item) {
        return OraxenItems.getItemById(OraxenItems.getIdByItem(item));
    }

    public static List<ItemBuilder> getUnexcludedItems() {
        return OraxenItems.itemStream().filter(item -> !item.getOraxenMeta().isExcludedFromInventory()).toList();
    }

    public static List<ItemBuilder> getUnexcludedItems(File file) {
        return map.get(file).values().stream().filter(item -> !item.getOraxenMeta().isExcludedFromInventory()).toList();
    }

    public static List<ItemStack> getItemStacksByName(List<List<String>> lists) {
        return lists.stream().flatMap(list -> {
            ItemStack[] itemStack = new ItemStack[]{new ItemStack(Material.AIR)};
            list.stream().map(line -> line.split(":")).forEach(param -> {
                switch (param[0].toLowerCase(Locale.ROOT)) {
                    case "type": {
                        if (OraxenItems.exists(param[1])) {
                            itemStack[0] = OraxenItems.getItemById(param[1]).build().clone();
                            break;
                        }
                        Message.ITEM_NOT_FOUND.log(AdventureUtils.tagResolver("item", param[1]));
                        break;
                    }
                    case "amount": {
                        itemStack[0].setAmount(NumberUtils.toInt((String)param[1], (int)1));
                    }
                }
            });
            return Stream.of(itemStack[0]);
        }).toList();
    }

    public static boolean hasMechanic(String itemID, String mechanicID) {
        MechanicFactory factory = MechanicsManager.getMechanicFactory(mechanicID);
        return factory != null && factory.getMechanic(itemID) != null;
    }

    public static Map<File, Map<String, ItemBuilder>> getMap() {
        return map != null ? map : new HashMap();
    }

    public static Map<String, ItemBuilder> getEntriesAsMap() {
        return OraxenItems.entryStream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Set<Map.Entry<String, ItemBuilder>> getEntries() {
        return OraxenItems.entryStream().collect(Collectors.toSet());
    }

    public static Collection<ItemBuilder> getItems() {
        return OraxenItems.itemStream().toList();
    }

    @Deprecated
    public static Set<String> getSectionsNames() {
        return OraxenItems.getNames();
    }

    public static Set<String> getNames() {
        return OraxenItems.nameStream().collect(Collectors.toSet());
    }

    public static String[] nameArray() {
        return (String[])OraxenItems.nameStream().toArray(String[]::new);
    }

    public static Stream<String> nameStream() {
        return OraxenItems.entryStream().map(Map.Entry::getKey);
    }

    public static Stream<ItemBuilder> itemStream() {
        return OraxenItems.entryStream().map(Map.Entry::getValue);
    }

    public static Stream<Map.Entry<String, ItemBuilder>> entryStream() {
        return OraxenItems.map.values().stream().flatMap(map -> map.entrySet().stream());
    }

    public static String[] getItemNames() {
        return (String[])items.stream().filter(item -> {
            ItemBuilder builder = OraxenItems.getItemById(item);
            return builder != null && builder.hasOraxenMeta() && !builder.getOraxenMeta().isExcludedFromCommands();
        }).toArray(String[]::new);
    }
}

