/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import dev.jorel.commandapi.wrappers.IntegerRange;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;

public class Utils {
    private Utils() {
    }

    public static Color toColor(String string) {
        if (string.startsWith("#") || string.startsWith("0x")) {
            return Color.fromRGB((int)Integer.parseInt(string.substring(1), 16));
        }
        if (string.contains(",")) {
            String[] newString = string.replace(", ", ",").split(",", 3);
            try {
                int r = Integer.parseInt(newString[0]);
                int g = Integer.parseInt(newString[1]);
                int b = Integer.parseInt(newString[2]);
                return Color.fromRGB((int)r, (int)g, (int)b);
            }
            catch (NumberFormatException e) {
                return Color.WHITE;
            }
        }
        return Color.WHITE;
    }

    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length());
        }
        return string;
    }

    public static List<String> toLowercaseList(String ... values) {
        ArrayList<String> list = new ArrayList<String>();
        for (String value : values) {
            list.add(value.toLowerCase(Locale.ROOT));
        }
        return list;
    }

    public static String[] toLowercase(String ... values) {
        for (int index = 0; index < values.length; ++index) {
            values[index] = values[index].toLowerCase(Locale.ROOT);
        }
        return values;
    }

    public static long getVersion(String format) {
        return Long.parseLong(OffsetDateTime.now().format(DateTimeFormatter.ofPattern(format)));
    }

    public static String getParentDirs(String string) {
        return Utils.getStringBeforeLastInSplit(string, "/");
    }

    public static String removeParentDirs(String s) {
        return Utils.getLastStringInSplit(s, "/");
    }

    public static String removeExtension(String s) {
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = s.lastIndexOf(separator);
        String filename = lastSeparatorIndex == -1 ? s : s.substring(lastSeparatorIndex + 1);
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }

    public static String removeExtensionOnly(String s) {
        int extensionIndex = s.lastIndexOf(".");
        if (extensionIndex == -1) {
            return s;
        }
        return s.substring(0, extensionIndex);
    }

    public static String getFileNameOnly(String s) {
        s = Utils.removeParentDirs(s);
        s = Utils.removeExtensionOnly(s);
        return s;
    }

    public static String getLastStringInSplit(String string, String split) {
        String[] splitString = string.split(split);
        return splitString.length > 0 ? splitString[splitString.length - 1] : "";
    }

    public static String getStringBeforeLastInSplit(String string, String split) {
        String[] splitString = string.split(split);
        if (splitString.length == 0) {
            return string;
        }
        return string.replace(splitString[splitString.length - 1], "");
    }

    public static void writeStringToFile(File file, String content) {
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static char firstEmpty(Map<String, Character> map, int min) {
        List<Integer> newMap = map.values().stream().map(c -> c.charValue()).sorted().toList();
        while (newMap.contains(min)) {
            ++min;
        }
        return (char)min;
    }

    public static void swingHand(Player player, EquipmentSlot hand) {
        if (hand == EquipmentSlot.HAND) {
            player.swingMainHand();
        } else {
            player.swingOffHand();
        }
    }

    public static float customRound(double value, float step) {
        float roundedValue = (float)Math.round(value / (double)step) * step;
        float remainder = (float)(value % (double)step);
        if (remainder > step / 2.0f) {
            roundedValue += step;
        }
        return Float.parseFloat(String.format("%.2f", Float.valueOf(roundedValue)).replace(",", "."));
    }

    public static IntegerRange parseToRange(String string) {
        return Utils.parseToRange(string, new IntegerRange(1, 1));
    }

    public static IntegerRange parseToRange(String string, IntegerRange integerRange) {
        int maxAmount;
        int minAmount;
        try {
            minAmount = Integer.parseInt(StringUtils.substringBefore((String)string, (String)".."));
        }
        catch (NumberFormatException e) {
            minAmount = 1;
        }
        try {
            maxAmount = Integer.parseInt(StringUtils.substringAfter((String)string, (String)".."));
        }
        catch (NumberFormatException e) {
            maxAmount = Math.max(minAmount, 1);
        }
        minAmount = Math.max(0, minAmount);
        maxAmount = Math.max(0, maxAmount);
        return new IntegerRange(minAmount, maxAmount);
    }
}

