/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import com.google.common.collect.Sets;
import com.jeff_media.customblockdata.CustomBlockData;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.nms.NMSHandlers;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.VersionUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.Range;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.Attachable;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.CoralWallFan;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Ladder;
import org.bukkit.block.data.type.Lantern;
import org.bukkit.block.data.type.Lectern;
import org.bukkit.block.data.type.Repeater;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.block.data.type.SculkVein;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.block.data.type.Tripwire;
import org.bukkit.block.data.type.TripwireHook;
import org.bukkit.block.data.type.WallHangingSign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public class BlockHelpers {
    public static final Set<Material> UNBREAKABLE_BLOCKS = Sets.newHashSet((Object[])new Material[]{Material.BEDROCK, Material.BARRIER, Material.NETHER_PORTAL, Material.END_PORTAL_FRAME, Material.END_PORTAL, Material.END_GATEWAY});
    public static final List<Material> REPLACEABLE_BLOCKS;

    @Nullable
    public static Block getBlockStandingOn(Entity entity) {
        Block block = entity.getLocation().getBlock();
        Block blockBelow = block.getRelative(BlockFace.DOWN);
        if (!block.getType().isAir() && block.getType() != Material.LIGHT) {
            return block;
        }
        if (!blockBelow.getType().isAir()) {
            return blockBelow;
        }
        BoundingBox entityBox = entity.getBoundingBox().expand(0.3);
        for (BlockFace face : BlockFace.values()) {
            Block relative;
            if (!face.isCartesian() || face.getModY() != 0 || (relative = blockBelow.getRelative(face)).getType() == Material.AIR || !relative.getBoundingBox().overlaps(entityBox)) continue;
            return relative;
        }
        return null;
    }

    public static void playCustomBlockSound(Location location, String sound, float volume, float pitch) {
        BlockHelpers.playCustomBlockSound(BlockHelpers.toCenterLocation(location), sound, SoundCategory.BLOCKS, volume, pitch);
    }

    public static void playCustomBlockSound(Location location, String sound, SoundCategory category, float volume, float pitch) {
        if (sound == null || location == null || location.getWorld() == null || category == null) {
            return;
        }
        location.getWorld().playSound(location, BlockHelpers.validateReplacedSounds(sound), category, volume, pitch);
    }

    public static String validateReplacedSounds(String sound) {
        ConfigurationSection mechanics = OraxenPlugin.get().getConfigsManager().getMechanics().getConfigurationSection("custom_block_sounds");
        if (mechanics == null) {
            return sound;
        }
        if ((sound = sound.replace("minecraft:", "")).startsWith("block.wood") && mechanics.getBoolean("noteblock_and_block")) {
            return sound.replace("block.wood", "required.wood");
        }
        if (sound.startsWith("block.stone") && mechanics.getBoolean("stringblock_and_furniture")) {
            return sound.replace("block.stone", "required.stone");
        }
        return sound;
    }

    public static Location toBlockLocation(Location location) {
        Location blockLoc = location.clone();
        blockLoc.setX((double)location.getBlockX());
        blockLoc.setY((double)location.getBlockY());
        blockLoc.setZ((double)location.getBlockZ());
        return blockLoc;
    }

    public static Location toCenterLocation(Location location) {
        Location centerLoc = location.clone();
        centerLoc.setX((double)location.getBlockX() + 0.5);
        centerLoc.setY((double)location.getBlockY() + 0.5);
        centerLoc.setZ((double)location.getBlockZ() + 0.5);
        return centerLoc;
    }

    public static Location toCenterBlockLocation(Location location) {
        return BlockHelpers.toCenterLocation(location).subtract(0.0, 0.5, 0.0);
    }

    public static boolean isStandingInside(Player player, Block block) {
        if (player == null || block == null) {
            return false;
        }
        BoundingBox blockBox = BoundingBox.of((Location)BlockHelpers.toCenterLocation(block.getLocation()), (double)0.5, (double)0.5, (double)0.5);
        return !block.getWorld().getNearbyEntities(blockBox).stream().filter(e -> {
            Player p;
            return e instanceof LivingEntity && (!(e instanceof Player) || (p = (Player)e).getGameMode() != GameMode.SPECTATOR);
        }).toList().isEmpty();
    }

    public static PersistentDataContainer getPDC(Block block) {
        return BlockHelpers.getPDC(block, OraxenPlugin.get());
    }

    public static PersistentDataContainer getPDC(Block block, JavaPlugin plugin) {
        return new CustomBlockData(block, (Plugin)plugin);
    }

    public static boolean isReplaceable(Block block) {
        return REPLACEABLE_BLOCKS.contains(block.getType());
    }

    public static boolean isReplaceable(BlockData blockData) {
        return REPLACEABLE_BLOCKS.contains(blockData.getMaterial());
    }

    public static boolean isReplaceable(Material material) {
        return REPLACEABLE_BLOCKS.contains(material);
    }

    public static boolean isInteractable(Block placedAgainst) {
        if (placedAgainst == null) {
            return false;
        }
        NoteBlockMechanic noteBlockMechanic = OraxenBlocks.getNoteBlockMechanic(placedAgainst);
        FurnitureMechanic furnitureMechanic = OraxenFurniture.getFurnitureMechanic(placedAgainst);
        Material type = placedAgainst.getType();
        if (noteBlockMechanic != null) {
            return false;
        }
        if (furnitureMechanic != null) {
            return furnitureMechanic.isInteractable();
        }
        if (Tag.STAIRS.isTagged((Keyed)type)) {
            return false;
        }
        if (Tag.FENCES.isTagged((Keyed)type)) {
            return false;
        }
        if (!type.isInteractable()) {
            return false;
        }
        return switch (type) {
            case Material.PUMPKIN, Material.MOVING_PISTON, Material.REDSTONE_ORE, Material.REDSTONE_WIRE -> false;
            default -> true;
        };
    }

    public static void correctAllBlockStates(Block placedAgainst, Player player, EquipmentSlot hand, BlockFace face, ItemStack item, BlockData newData) {
        Block target = placedAgainst.getRelative(face);
        if (NMSHandlers.getHandler() != null && BlockCorrection.useNMS()) {
            if (Tag.ITEMS_BOATS.isTagged((Keyed)item.getType())) {
                return;
            }
            NMSHandlers.getHandler().correctBlockStates(player, hand, item);
        } else {
            if (newData == null) {
                return;
            }
            BlockData oldData = target.getBlockData();
            target.setBlockData(newData);
            BlockData correctedData = BlockHelpers.oldCorrectBlockData(placedAgainst.getRelative(face), player, face, item);
            if (correctedData == null) {
                target.setBlockData(oldData);
            }
            if (player.getGameMode() != GameMode.CREATIVE) {
                item.setAmount(item.getAmount() - 1);
            }
            Utils.swingHand(player, hand);
        }
        BlockState blockState = target.getState();
        if (blockState instanceof Sign) {
            Sign sign = (Sign)blockState;
            player.openSign(sign);
        }
    }

    private static BlockData oldCorrectBlockData(Block block, Player player, BlockFace face, ItemStack item) {
        BlockState blockState;
        BlockData data = block.getBlockData();
        BlockState state = block.getState();
        Material type = block.getType();
        if (type == Material.SEAGRASS) {
            return null;
        }
        if (data instanceof Tripwire) {
            return data;
        }
        if (data instanceof Sapling && face != BlockFace.UP) {
            return null;
        }
        if (data instanceof Ladder && (face == BlockFace.UP || face == BlockFace.DOWN)) {
            return null;
        }
        if (type == Material.HANGING_ROOTS && face != BlockFace.DOWN) {
            return null;
        }
        if (type.toString().endsWith("TORCH") && face == BlockFace.DOWN) {
            return null;
        }
        if (type.toString().endsWith("HANGING_SIGN") && face == BlockFace.UP) {
            return null;
        }
        if ((state instanceof Sign && !type.toString().endsWith("HANGING_SIGN") || state instanceof Banner) && face == BlockFace.DOWN) {
            return null;
        }
        if (data instanceof Ageable) {
            return !BlockHelpers.handleAgeableBlocks(block, face) ? data : null;
        }
        if (!(data instanceof Door) && (data instanceof Bisected || data instanceof Slab)) {
            BlockHelpers.handleHalfBlocks(block, player);
        }
        if (data instanceof Rotatable) {
            BlockHelpers.handleRotatableBlocks(block, player);
        }
        if (type.toString().contains("CORAL") && !type.toString().endsWith("CORAL_BLOCK") && face == BlockFace.DOWN) {
            return null;
        }
        if (type.toString().endsWith("CORAL") && block.getRelative(BlockFace.DOWN).getType() == Material.AIR) {
            return null;
        }
        if (type.toString().endsWith("_CORAL_FAN") && face != BlockFace.UP) {
            block.setType(Material.valueOf((String)type.toString().replace("_CORAL_FAN", "_CORAL_WALL_FAN")));
        }
        if (data instanceof Waterlogged) {
            BlockHelpers.handleWaterlogged(block, face);
        }
        if ((data instanceof Bed || data instanceof Chest || data instanceof Bisected) && !(data instanceof Stairs) && !(data instanceof TrapDoor) && !BlockHelpers.handleDoubleBlocks(block, player)) {
            return null;
        }
        if ((state instanceof Skull || state instanceof Sign || state instanceof Banner || type.toString().contains("TORCH")) && face != BlockFace.DOWN && face != BlockFace.UP) {
            BlockHelpers.handleWallAttachable(block, face);
        }
        if (!(data instanceof Stairs) && !type.toString().endsWith("HANGING_SIGN") && (data instanceof Directional || data instanceof FaceAttachable || data instanceof MultipleFacing || data instanceof Attachable)) {
            if (!(data instanceof SculkVein) && data instanceof MultipleFacing && face == BlockFace.UP) {
                return null;
            }
            if (data instanceof CoralWallFan && face == BlockFace.DOWN) {
                return null;
            }
            BlockHelpers.handleDirectionalBlocks(block, face);
        }
        if (data instanceof Orientable) {
            Orientable orientable = (Orientable)data;
            if (face == BlockFace.UP || face == BlockFace.DOWN) {
                orientable.setAxis(Axis.Y);
            } else if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                orientable.setAxis(Axis.Z);
            } else if (face == BlockFace.WEST || face == BlockFace.EAST) {
                orientable.setAxis(Axis.X);
            } else {
                orientable.setAxis(Axis.Y);
            }
        }
        if (data instanceof Lantern) {
            Lantern lantern = (Lantern)data;
            lantern.setHanging(face == BlockFace.DOWN);
        }
        if (data instanceof Lectern) {
            Lectern lectern = (Lectern)data;
            lectern.setFacing(player.getFacing().getOppositeFace());
        }
        if (type.toString().endsWith("ANVIL")) {
            if (face == BlockFace.UP || face == BlockFace.DOWN) {
                ((Directional)data).setFacing(BlockHelpers.getAnvilFacing(player.getFacing().getOppositeFace()));
            } else {
                ((Directional)data).setFacing(BlockHelpers.getAnvilFacing(face));
            }
        }
        if (state instanceof BlockInventoryHolder) {
            BlockInventoryHolder invHolder = (BlockInventoryHolder)state;
            if (item.hasItemMeta() && (blockState = item.getItemMeta()) instanceof BlockStateMeta) {
                BlockStateMeta blockStateMeta = (BlockStateMeta)blockState;
                Inventory inv = ((BlockInventoryHolder)blockStateMeta.getBlockState()).getInventory();
                invHolder.getInventory().setContents(inv.getContents());
            }
        }
        if (data instanceof Repeater) {
            Repeater repeater = (Repeater)data;
            repeater.setFacing(player.getFacing().getOppositeFace());
        }
        if ((blockState = block.getState()) instanceof Banner) {
            Banner banner = (Banner)blockState;
            if (item.hasItemMeta() && (blockState = item.getItemMeta()) instanceof BannerMeta) {
                BannerMeta bannerItem = (BannerMeta)blockState;
                banner.setPatterns(bannerItem.getPatterns());
                if (!banner.update(false, false)) {
                    return null;
                }
            }
        }
        if (data instanceof TripwireHook) {
            TripwireHook hook = (TripwireHook)data;
            if (block.getRelative(player.getFacing()).getType().isSolid()) {
                hook.setFacing(player.getFacing().getOppositeFace());
            } else {
                List<BlockFace> solidFaces = hook.getFaces().stream().filter(f -> block.getRelative(f).getType().isSolid()).toList();
                if (solidFaces.isEmpty()) {
                    return null;
                }
                hook.setFacing(solidFaces.get(0).getOppositeFace());
            }
        }
        return data;
    }

    private static void handleWaterlogged(Block block, BlockFace face) {
        BlockData data = block.getBlockData();
        if (data instanceof Waterlogged) {
            Directional directional;
            Waterlogged waterlogged = (Waterlogged)data;
            if (data instanceof Directional && (directional = (Directional)data).getFaces().contains(face) && !(data instanceof Stairs)) {
                directional.setFacing(face);
            }
            waterlogged.setWaterlogged(false);
        }
        block.setBlockData(data, false);
    }

    private static void handleWallAttachable(Block block, BlockFace face) {
        Material type = block.getType();
        if (type.toString().endsWith("_BANNER")) {
            block.setType(Material.valueOf((String)type.toString().replace("_BANNER", "_WALL_BANNER")));
        } else if (type.toString().endsWith("TORCH")) {
            block.setType(Material.valueOf((String)type.toString().replace("TORCH", "WALL_TORCH")));
        } else if (type.toString().endsWith("HANGING_SIGN")) {
            block.setType(Material.valueOf((String)type.toString().replace("_HANGING_SIGN", "_WALL_HANGING_SIGN")));
        } else if (type.toString().endsWith("SIGN")) {
            block.setType(Material.valueOf((String)type.toString().replace("_SIGN", "_WALL_SIGN")));
        } else if (type.toString().endsWith("SKULL")) {
            block.setType(Material.valueOf((String)type.toString().replace("_SKULL", "_WALL_SKULL")));
        } else {
            block.setType(Material.valueOf((String)type.toString().replace("_HEAD", "_WALL_HEAD")));
        }
        BlockData data = block.getBlockData();
        if (data instanceof Directional) {
            Directional directional = (Directional)data;
            directional.setFacing(face);
        }
        if (data.getMaterial().toString().endsWith("WALL_HANGING_SIGN")) {
            assert (data instanceof WallHangingSign);
            ((WallHangingSign)data).setFacing(BlockHelpers.getWallHangingSignFacing(face.getOppositeFace()));
        }
        block.setBlockData(data, false);
    }

    private static boolean handleDoubleBlocks(Block block, Player player) {
        BlockData data = block.getBlockData();
        Block up = block.getRelative(BlockFace.UP);
        if (data instanceof Door) {
            Door door = (Door)data;
            if (up.getType().isSolid() || !REPLACEABLE_BLOCKS.contains(up.getType())) {
                return false;
            }
            if (BlockHelpers.getLeftBlock(block, player).getBlockData() instanceof Door) {
                door.setHinge(Door.Hinge.RIGHT);
            } else {
                door.setHinge(Door.Hinge.LEFT);
            }
            door.setFacing(player.getFacing());
            door.setHalf(Bisected.Half.TOP);
            block.getRelative(BlockFace.UP).setBlockData((BlockData)door, false);
            door.setHalf(Bisected.Half.BOTTOM);
            block.setBlockData((BlockData)door, false);
        } else if (data instanceof Bed) {
            Bed bed = (Bed)data;
            Block nextBlock = block.getRelative(player.getFacing());
            if (nextBlock.getType().isSolid() || !REPLACEABLE_BLOCKS.contains(nextBlock.getType())) {
                return false;
            }
            nextBlock.setType(block.getType(), false);
            Bed nextData = (Bed)nextBlock.getBlockData();
            block.getRelative(player.getFacing()).setBlockData((BlockData)bed, false);
            bed.setPart(Bed.Part.FOOT);
            nextData.setPart(Bed.Part.HEAD);
            bed.setFacing(player.getFacing());
            nextData.setFacing(player.getFacing());
            nextBlock.setBlockData((BlockData)nextData, false);
            block.setBlockData((BlockData)bed, false);
        } else if (data instanceof Chest) {
            Chest chest = (Chest)data;
            if (BlockHelpers.getLeftBlock(block, player).getBlockData() instanceof Chest) {
                chest.setType(Chest.Type.LEFT);
            } else if (BlockHelpers.getRightBlock(block, player).getBlockData() instanceof Chest) {
                chest.setType(Chest.Type.RIGHT);
            } else {
                chest.setType(Chest.Type.SINGLE);
            }
            chest.setFacing(player.getFacing().getOppositeFace());
            block.setBlockData((BlockData)chest, true);
        } else if (data instanceof Bisected) {
            Bisected bisected = (Bisected)data;
            if (up.getType().isSolid() || !REPLACEABLE_BLOCKS.contains(up.getType())) {
                return false;
            }
            bisected.setHalf(Bisected.Half.TOP);
            block.getRelative(BlockFace.UP).setBlockData((BlockData)bisected, false);
            bisected.setHalf(Bisected.Half.BOTTOM);
            block.setBlockData((BlockData)bisected, false);
        } else {
            block.setBlockData(Bukkit.createBlockData((Material)Material.AIR), false);
            return false;
        }
        return true;
    }

    public static void handleHalfBlocks(Block block, Player player) {
        RayTraceResult eye = player.rayTraceBlocks(5.0, FluidCollisionMode.NEVER);
        BlockData data = block.getBlockData();
        if (eye == null) {
            return;
        }
        Block hitBlock = eye.getHitBlock();
        BlockFace hitFace = eye.getHitBlockFace();
        Location hitLoc = eye.getHitPosition().toLocation(block.getWorld());
        if (hitBlock == null || hitFace == null) {
            return;
        }
        if (data instanceof TrapDoor) {
            TrapDoor trapDoor = (TrapDoor)data;
            trapDoor.setFacing(player.getFacing().getOppositeFace());
            if (eye.getHitBlockFace() == BlockFace.UP) {
                trapDoor.setHalf(Bisected.Half.BOTTOM);
            } else if (hitFace == BlockFace.DOWN) {
                trapDoor.setHalf(Bisected.Half.TOP);
            } else if (hitLoc.getY() <= BlockHelpers.toBlockLocation(hitBlock.getLocation()).getY()) {
                trapDoor.setHalf(Bisected.Half.BOTTOM);
            } else {
                trapDoor.setHalf(Bisected.Half.TOP);
            }
        } else if (data instanceof Stairs) {
            Stairs stairs = (Stairs)data;
            stairs.setFacing(player.getFacing());
            if (hitFace == BlockFace.UP) {
                stairs.setHalf(Bisected.Half.BOTTOM);
            } else if (hitFace == BlockFace.DOWN) {
                stairs.setHalf(Bisected.Half.TOP);
            } else if (hitLoc.getY() <= BlockHelpers.toCenterLocation(hitBlock.getLocation()).getY()) {
                stairs.setHalf(Bisected.Half.BOTTOM);
            } else {
                stairs.setHalf(Bisected.Half.TOP);
            }
        } else if (data instanceof Slab) {
            Slab slab = (Slab)data;
            if (hitFace == BlockFace.UP) {
                slab.setType(Slab.Type.BOTTOM);
            } else if (hitFace == BlockFace.DOWN) {
                slab.setType(Slab.Type.TOP);
            } else if (hitLoc.getY() <= BlockHelpers.toCenterLocation(hitBlock.getLocation()).getY()) {
                slab.setType(Slab.Type.BOTTOM);
            } else {
                slab.setType(Slab.Type.TOP);
            }
        }
        block.setBlockData(data, false);
    }

    private static void handleRotatableBlocks(Block block, Player player) {
        Rotatable data = (Rotatable)block.getBlockData();
        if (block.getType().toString().contains("SKULL") || block.getType().toString().contains("HEAD")) {
            data.setRotation(BlockHelpers.getRelativeFacing(player));
        } else {
            data.setRotation(BlockHelpers.getRelativeFacing(player).getOppositeFace());
        }
        block.setBlockData((BlockData)data, false);
    }

    private static void handleDirectionalBlocks(Block block, BlockFace face) {
        BlockData data = block.getBlockData();
        if (data instanceof Directional) {
            Directional directional = (Directional)data;
            if (data instanceof FaceAttachable) {
                FaceAttachable faceAttachable = (FaceAttachable)data;
                if (face == BlockFace.UP) {
                    faceAttachable.setAttachedFace(FaceAttachable.AttachedFace.FLOOR);
                } else if (face == BlockFace.DOWN) {
                    faceAttachable.setAttachedFace(FaceAttachable.AttachedFace.CEILING);
                } else {
                    directional.setFacing(face);
                }
            } else if (directional.getFaces().contains(face)) {
                directional.setFacing(face);
            }
        } else if (data instanceof SculkVein) {
            SculkVein sculkVein = (SculkVein)data;
            sculkVein.setFace(face.getOppositeFace(), block.getRelative(face.getOppositeFace()).getType().isSolid());
        } else if (data instanceof MultipleFacing) {
            MultipleFacing multipleFacing = (MultipleFacing)data;
            for (BlockFace blockFace : multipleFacing.getAllowedFaces()) {
                multipleFacing.setFace(blockFace, block.getRelative(blockFace).getType().isSolid());
            }
        } else if (data instanceof Attachable) {
            Attachable attachable = (Attachable)data;
            attachable.setAttached(true);
        }
        block.setBlockData(data, false);
    }

    private static boolean handleAgeableBlocks(Block block, BlockFace face) {
        Material type = block.getType();
        if (type.toString().contains("WEEPING_VINES")) {
            return face == BlockFace.DOWN;
        }
        if (type.toString().contains("TWISTING_VINES")) {
            return face == BlockFace.UP;
        }
        return false;
    }

    private static Block getLeftBlock(Block block, Player player) {
        Chest chest;
        BlockFace playerFacing = player.getFacing();
        Block leftBlock = switch (playerFacing) {
            case BlockFace.NORTH -> block.getRelative(BlockFace.WEST);
            case BlockFace.SOUTH -> block.getRelative(BlockFace.EAST);
            case BlockFace.WEST -> block.getRelative(BlockFace.SOUTH);
            case BlockFace.EAST -> block.getRelative(BlockFace.NORTH);
            default -> block;
        };
        BlockData blockData = leftBlock.getBlockData();
        boolean isChest = blockData instanceof Chest && (chest = (Chest)blockData).getFacing() != player.getFacing().getOppositeFace();
        return isChest ? block : leftBlock;
    }

    private static Block getRightBlock(Block block, Player player) {
        Chest chest;
        BlockFace playerFacing = player.getFacing();
        Block rightBlock = switch (playerFacing) {
            case BlockFace.NORTH -> block.getRelative(BlockFace.EAST);
            case BlockFace.SOUTH -> block.getRelative(BlockFace.WEST);
            case BlockFace.WEST -> block.getRelative(BlockFace.NORTH);
            case BlockFace.EAST -> block.getRelative(BlockFace.SOUTH);
            default -> block;
        };
        BlockData blockData = rightBlock.getBlockData();
        boolean isChest = blockData instanceof Chest && (chest = (Chest)blockData).getFacing() != playerFacing.getOppositeFace();
        return isChest ? block : rightBlock;
    }

    private static BlockFace getRelativeFacing(Player player) {
        double yaw = player.getLocation().getYaw();
        BlockFace face = BlockFace.SELF;
        if (Range.between((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(22.5)).contains((Object)yaw) || yaw >= 337.5 || yaw >= -22.5 && yaw <= 0.0 || yaw <= -337.5) {
            face = BlockFace.SOUTH;
        } else if (Range.between((Comparable)Double.valueOf(22.5), (Comparable)Double.valueOf(67.5)).contains((Object)yaw) || Range.between((Comparable)Double.valueOf(-337.5), (Comparable)Double.valueOf(-292.5)).contains((Object)yaw)) {
            face = BlockFace.WEST;
        } else if (Range.between((Comparable)Double.valueOf(67.5), (Comparable)Double.valueOf(112.5)).contains((Object)yaw) || Range.between((Comparable)Double.valueOf(-292.5), (Comparable)Double.valueOf(-247.5)).contains((Object)yaw)) {
            face = BlockFace.SOUTH_WEST;
        } else if (Range.between((Comparable)Double.valueOf(112.5), (Comparable)Double.valueOf(157.5)).contains((Object)yaw) || Range.between((Comparable)Double.valueOf(-247.5), (Comparable)Double.valueOf(-202.5)).contains((Object)yaw)) {
            face = BlockFace.NORTH_WEST;
        } else if (Range.between((Comparable)Double.valueOf(157.5), (Comparable)Double.valueOf(202.5)).contains((Object)yaw) || Range.between((Comparable)Double.valueOf(-202.5), (Comparable)Double.valueOf(-157.5)).contains((Object)yaw)) {
            face = BlockFace.NORTH;
        } else if (Range.between((Comparable)Double.valueOf(202.5), (Comparable)Double.valueOf(247.5)).contains((Object)yaw) || Range.between((Comparable)Double.valueOf(-157.5), (Comparable)Double.valueOf(-112.5)).contains((Object)yaw)) {
            face = BlockFace.NORTH_EAST;
        } else if (Range.between((Comparable)Double.valueOf(247.5), (Comparable)Double.valueOf(292.5)).contains((Object)yaw) || Range.between((Comparable)Double.valueOf(-112.5), (Comparable)Double.valueOf(-67.5)).contains((Object)yaw)) {
            face = BlockFace.EAST;
        } else if (Range.between((Comparable)Double.valueOf(292.5), (Comparable)Double.valueOf(337.5)).contains((Object)yaw) || Range.between((Comparable)Double.valueOf(-67.5), (Comparable)Double.valueOf(-22.5)).contains((Object)yaw)) {
            face = BlockFace.SOUTH_EAST;
        }
        return face;
    }

    public static BlockFace getAnvilFacing(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.EAST;
            case BlockFace.SOUTH -> BlockFace.WEST;
            case BlockFace.WEST -> BlockFace.SOUTH;
            default -> BlockFace.NORTH;
        };
    }

    private static BlockFace getWallHangingSignFacing(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.WEST;
            case BlockFace.SOUTH -> BlockFace.EAST;
            case BlockFace.WEST -> BlockFace.SOUTH;
            default -> BlockFace.NORTH;
        };
    }

    public static boolean isLoaded(World world, Location loc) {
        return world.isChunkLoaded(loc.getBlockX() >> 4, loc.getBlockZ() >> 4);
    }

    public static boolean isLoaded(Location loc) {
        return loc.getWorld() != null && BlockHelpers.isLoaded(loc.getWorld(), loc);
    }

    static {
        if (VersionUtil.atOrAbove("1.19")) {
            UNBREAKABLE_BLOCKS.add(Material.REINFORCED_DEEPSLATE);
        }
        REPLACEABLE_BLOCKS = VersionUtil.atOrAbove("1.20") ? Tag.REPLACEABLE.getValues().stream().toList() : Arrays.asList(Material.SNOW, Material.VINE, Material.valueOf((String)"GRASS"), Material.TALL_GRASS, Material.SEAGRASS, Material.FERN, Material.LARGE_FERN, Material.AIR, Material.WATER, Material.LAVA, Material.LIGHT);
    }

    public static enum BlockCorrection {
        NMS,
        LEGACY;


        public static boolean useNMS() {
            return BlockCorrection.get() == NMS;
        }

        public static BlockCorrection get() {
            return Objects.equals(Settings.BLOCK_CORRECTION.toString(), "NMS") ? NMS : LEGACY;
        }
    }
}

