/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.furniture;

import com.jeff_media.customblockdata.CustomBlockData;
import com.jeff_media.morepersistentdatatypes.DataType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.BlockLocation;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FurnitureUpdater
implements Listener {
    public FurnitureUpdater() {
        if (!Settings.UPDATE_FURNITURE.toBool().booleanValue()) {
            return;
        }
        if (Settings.UPDATE_FURNITURE_ON_LOAD.toBool().booleanValue()) {
            Bukkit.getPluginManager().registerEvent(EntitiesLoadEvent.class, (Listener)this, EventPriority.NORMAL, (listener, event) -> ((EntitiesLoadEvent)event).getEntities().stream().filter(OraxenFurniture::isBaseEntity).forEach(OraxenFurniture::updateFurniture), (Plugin)OraxenPlugin.get());
        }
        if (Settings.EXPERIMENTAL_FIX_BROKEN_FURNITURE.toBool().booleanValue()) {
            Bukkit.getPluginManager().registerEvent(ChunkLoadEvent.class, (Listener)this, EventPriority.NORMAL, (listener, event) -> {
                for (Block block : CustomBlockData.getBlocksWithCustomData((Plugin)OraxenPlugin.get(), ((ChunkLoadEvent)event).getChunk())) {
                    FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(block);
                    if (mechanic == null) {
                        return;
                    }
                    Entity baseEntity = mechanic.getBaseEntity(block);
                    if (baseEntity != null) {
                        return;
                    }
                    Location rootLoc = new BlockLocation((String)BlockHelpers.getPDC(block).getOrDefault(FurnitureMechanic.ROOT_KEY, DataType.STRING, (Object)"")).toLocation(block.getWorld());
                    float yaw = ((Float)BlockHelpers.getPDC(block).getOrDefault(FurnitureMechanic.ORIENTATION_KEY, PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f))).floatValue();
                    if (rootLoc == null) {
                        return;
                    }
                    mechanic.getLocations(yaw, rootLoc, mechanic.getBarriers()).forEach(loc -> {
                        loc.getBlock().setType(Material.AIR);
                        new CustomBlockData(loc.getBlock(), (Plugin)OraxenPlugin.get()).clear();
                    });
                    mechanic.place(rootLoc, Float.valueOf(yaw), BlockFace.UP);
                }
            }, (Plugin)OraxenPlugin.get());
        }
    }
}

