/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.durability;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.utils.ItemUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@Deprecated(forRemoval=true, since="1.20.6")
public class DurabilityMechanic
extends Mechanic {
    private final int itemDurability;
    public static final NamespacedKey DURABILITY_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "durability");

    public DurabilityMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, item -> item.setCustomTag(DURABILITY_KEY, PersistentDataType.INTEGER, section.getInt("value")));
        this.itemDurability = section.getInt("value");
    }

    public int getItemMaxDurability() {
        return this.itemDurability;
    }

    public int getItemDurability(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof Damageable)) {
            return 0;
        }
        Damageable damageable = (Damageable)itemMeta;
        return (Integer)damageable.getPersistentDataContainer().getOrDefault(DURABILITY_KEY, PersistentDataType.INTEGER, (Object)0);
    }

    public boolean changeDurability(ItemStack item, int amount) {
        DurabilityMechanic durabilityMechanic = this;
        AtomicBoolean check = new AtomicBoolean(false);
        ItemUtils.editItemMeta(item, itemMeta -> {
            PersistentDataContainer pdc = itemMeta.getPersistentDataContainer();
            check.set(pdc.has(DURABILITY_KEY, PersistentDataType.INTEGER));
            if (check.get()) {
                if (!(itemMeta instanceof Damageable)) {
                    check.set(true);
                } else {
                    Damageable damageable = (Damageable)itemMeta;
                    short baseMaxDurab = item.getType().getMaxDurability();
                    int realMaxDurab = durabilityMechanic.getItemMaxDurability();
                    int realDurabRemain = (Integer)pdc.getOrDefault(DURABILITY_KEY, PersistentDataType.INTEGER, (Object)realMaxDurab);
                    if (damageable.hasDamage() && realDurabRemain == realMaxDurab) {
                        pdc.set(DURABILITY_KEY, PersistentDataType.INTEGER, (Object)((int)((double)realMaxDurab - (double)damageable.getDamage() / (double)baseMaxDurab * (double)realMaxDurab)));
                        item.setItemMeta(itemMeta);
                        this.changeDurability(item, amount);
                    } else if ((realDurabRemain += amount) > 0) {
                        pdc.set(DURABILITY_KEY, PersistentDataType.INTEGER, (Object)realDurabRemain);
                        damageable.setDamage((int)((double)baseMaxDurab - (double)realDurabRemain / (double)realMaxDurab * (double)baseMaxDurab));
                    } else {
                        item.setAmount(0);
                    }
                }
            }
        });
        return check.get();
    }
}

