/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.Executable;
import dev.jorel.commandapi.Execution;
import dev.jorel.commandapi.arguments.AbstractArgument;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractArgumentTree<Impl extends AbstractArgumentTree<Impl, Argument, CommandSender>, Argument extends AbstractArgument<?, ?, Argument, CommandSender>, CommandSender>
extends Executable<Impl, CommandSender> {
    final List<AbstractArgumentTree<?, Argument, CommandSender>> arguments = new ArrayList();
    final Argument argument;

    protected AbstractArgumentTree() {
        if (!(this instanceof AbstractArgument)) {
            throw new IllegalArgumentException("Implicit inherited constructor must be from Argument");
        }
        this.argument = (AbstractArgument)this;
    }

    protected AbstractArgumentTree(Argument argument) {
        this.argument = argument;
        this.executor = ((AbstractArgument)argument).executor;
    }

    public Impl then(AbstractArgumentTree<?, Argument, CommandSender> tree) {
        this.arguments.add(tree);
        return (Impl)((AbstractArgumentTree)this.instance());
    }

    List<Execution<CommandSender, Argument>> getExecutions() {
        ArrayList<Execution<CommandSender, Argument>> executions = new ArrayList<Execution<CommandSender, Argument>>();
        if (this.executor.hasAnyExecutors()) {
            executions.add(new Execution(List.of(this.argument), this.executor));
        }
        for (AbstractArgumentTree<?, Argument, CommandSender> tree : this.arguments) {
            for (Execution<CommandSender, Argument> execution : tree.getExecutions()) {
                executions.add(execution.prependedBy(this.argument));
            }
        }
        return executions;
    }
}

