/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.utils;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FieldUtils {
    private static final Map<Class<?>, ConcurrentHashMap<String, Field>> fieldMap = new ConcurrentHashMap();

    public static void unlockField(Class<?> clazz, String field) {
        try {
            Field f = clazz.getDeclaredField(field);
            f.setAccessible(true);
            ConcurrentHashMap<String, Field> map = fieldMap.get(clazz);
            if (map == null) {
                map = new ConcurrentHashMap();
            }
            map.put(field, f);
            fieldMap.put(clazz, map);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public static Field getField(Class<?> clazz, String field) {
        if (!fieldMap.containsKey(clazz) || !fieldMap.get(clazz).containsKey(field)) {
            FieldUtils.unlockField(clazz, field);
        }
        return fieldMap.get(clazz).get(field);
    }
}

