/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.inventories;

import dev.triumphteam.gui.builder.gui.PaginatedBuilder;
import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.GuiItem;
import dev.triumphteam.gui.guis.PaginatedGui;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.items.ItemParser;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.ItemUtils;
import io.th0rgal.oraxen.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class ItemsView {
    private final YamlConfiguration settings = OraxenPlugin.get().getResourceManager().getSettings();
    PaginatedGui mainGui;

    public PaginatedGui create() {
        HashMap<File, PaginatedGui> files = new HashMap<File, PaginatedGui>();
        for (File file : OraxenItems.getMap().keySet()) {
            List<ItemBuilder> unexcludedItems = OraxenItems.getUnexcludedItems(file);
            if (unexcludedItems.isEmpty()) continue;
            files.put(file, this.createSubGUI(file.getName(), unexcludedItems));
        }
        int rows = (Integer)Settings.ORAXEN_INV_ROWS.getValue();
        int highestUsedSlot = files.keySet().stream().map(this::getGuiItemSlot).map(GuiItemSlot::slot).max(Comparator.naturalOrder()).map(slot -> Math.max(slot, files.keySet().size() - 1)).orElse(files.keySet().size() - 1);
        GuiItem emptyGuiItem = new GuiItem(Material.AIR);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>(Collections.nCopies(highestUsedSlot + 1, emptyGuiItem));
        for (Map.Entry entry : files.entrySet()) {
            int slot2 = this.getGuiItemSlot((File)entry.getKey()).slot();
            if (slot2 == -1) continue;
            guiItems.set(slot2, new GuiItem(this.getGuiItemSlot((File)((File)entry.getKey())).itemStack, e -> ((PaginatedGui)entry.getValue()).open(e.getWhoClicked())));
        }
        for (Map.Entry entry : files.entrySet()) {
            GuiItemSlot guiItemSlot = this.getGuiItemSlot((File)entry.getKey());
            if (guiItemSlot.slot != -1) continue;
            guiItems.set(guiItems.indexOf(emptyGuiItem), new GuiItem(guiItemSlot.itemStack(), e -> ((PaginatedGui)entry.getValue()).open(e.getWhoClicked())));
        }
        this.mainGui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().rows(rows)).pageSize(((Integer)Settings.ORAXEN_INV_SIZE.getValue()).intValue()).title(Settings.ORAXEN_INV_TITLE.toComponent())).create();
        this.mainGui.addItem(guiItems.toArray(new GuiItem[0]));
        ItemStack previousPage = (Settings.ORAXEN_INV_PREVIOUS_ICON.getValue() == null ? new ItemBuilder(Material.ARROW).setDisplayName("Previous Page") : OraxenItems.getItemById(Settings.ORAXEN_INV_PREVIOUS_ICON.toString())).build();
        this.mainGui.setItem(6, 2, new GuiItem(previousPage, event -> {
            this.mainGui.previous();
            event.setCancelled(true);
        }));
        ItemStack nextPage = (Settings.ORAXEN_INV_NEXT_ICON.getValue() == null ? new ItemBuilder(Material.ARROW).setDisplayName("Next Page") : OraxenItems.getItemById(Settings.ORAXEN_INV_NEXT_ICON.toString())).build();
        this.mainGui.setItem(6, 8, new GuiItem(nextPage, event -> {
            this.mainGui.next();
            event.setCancelled(true);
        }));
        ItemStack exitIcon = (Settings.ORAXEN_INV_EXIT.getValue() == null ? new ItemBuilder(Material.BARRIER).setDisplayName("Exit") : OraxenItems.getItemById(Settings.ORAXEN_INV_EXIT.toString())).build();
        this.mainGui.setItem(6, 5, new GuiItem(exitIcon, event -> this.mainGui.open(event.getWhoClicked())));
        return this.mainGui;
    }

    private PaginatedGui createSubGUI(String fileName, List<ItemBuilder> items) {
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().rows(6)).pageSize(45).title(AdventureUtils.MINI_MESSAGE.deserialize((Object)this.settings.getString(String.format("oraxen_inventory.menu_layout.%s.title", Utils.removeExtension(fileName)), Settings.ORAXEN_INV_TITLE.toString()).replace("<main_menu_title>", Settings.ORAXEN_INV_TITLE.toString())))).create();
        gui.disableAllInteractions();
        for (ItemBuilder builder : items) {
            ItemStack itemStack;
            if (builder == null || ItemUtils.isEmpty(itemStack = builder.build())) continue;
            gui.addItem(new GuiItem(itemStack, e -> e.getWhoClicked().getInventory().addItem(new ItemStack[]{ItemUpdater.updateItem(e.getCurrentItem().clone())})));
        }
        ItemStack nextPage = (Settings.ORAXEN_INV_NEXT_ICON.getValue() == null ? new ItemBuilder(Material.ARROW) : OraxenItems.getItemById(Settings.ORAXEN_INV_NEXT_ICON.toString())).setDisplayName("Next Page").build();
        ItemStack previousPage = (Settings.ORAXEN_INV_PREVIOUS_ICON.getValue() == null ? new ItemBuilder(Material.ARROW) : OraxenItems.getItemById(Settings.ORAXEN_INV_PREVIOUS_ICON.toString())).setDisplayName("Previous Page").build();
        ItemStack exitIcon = (Settings.ORAXEN_INV_EXIT.getValue() == null ? new ItemBuilder(Material.BARRIER) : OraxenItems.getItemById(Settings.ORAXEN_INV_EXIT.toString())).setDisplayName("Exit").build();
        if (gui.getPagesNum() > 1) {
            gui.setItem(6, 2, new GuiItem(previousPage, event -> gui.previous()));
            gui.setItem(6, 8, new GuiItem(nextPage, event -> gui.next()));
        }
        gui.setItem(6, 5, new GuiItem(exitIcon, event -> this.mainGui.open(event.getWhoClicked())));
        return gui;
    }

    private GuiItemSlot getGuiItemSlot(File file) {
        String fileName = Utils.removeExtension(file.getName());
        Optional<String> icon = Optional.ofNullable(this.settings.getString(String.format("oraxen_inventory.menu_layout.%s.icon", fileName)));
        String displayName = ItemParser.parseComponentItemName(this.settings.getString(String.format("oraxen_inventory.menu_layout.%s.displayname", fileName), "<green>" + file.getName()));
        ItemStack itemStack = icon.map(OraxenItems::getItemById).map(ItemBuilder::clone).orElse(OraxenItems.getMap().get(file).values().stream().findFirst().orElse(new ItemBuilder(Material.PAPER))).clone().addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setDisplayName(displayName).setLore(new ArrayList<String>()).build();
        if (itemStack == null) {
            itemStack = new ItemBuilder(Material.PAPER).setDisplayName(displayName).build();
        }
        int slot = this.settings.getInt(String.format("oraxen_inventory.menu_layout.%s.slot", Utils.removeExtension(file.getName())), 0) - 1;
        return new GuiItemSlot(itemStack, slot);
    }

    private record GuiItemSlot(ItemStack itemStack, Integer slot) {
    }
}

