/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.drops.Drop;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.NotNull;

public class ItemUtils {
    public static boolean isEmpty(ItemStack itemStack) {
        return itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() == 0;
    }

    public static void subtract(ItemStack itemStack, int amount) {
        itemStack.setAmount(Math.max(0, itemStack.getAmount() - amount));
    }

    public static void dyeItem(ItemStack itemStack, Color color) {
        ItemUtils.editItemMeta(itemStack, meta -> {
            if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)meta;
                leatherArmorMeta.setColor(color);
            } else if (meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                potionMeta.setColor(color);
            } else if (meta instanceof MapMeta) {
                MapMeta mapMeta = (MapMeta)meta;
                mapMeta.setColor(color);
            }
        });
    }

    public static ItemStack editItemMeta(ItemStack itemStack, Consumer<ItemMeta> function) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return itemStack;
        }
        function.accept(meta);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack damageItem(Player player, Drop drop, ItemStack itemStack) {
        if (drop == null) {
            return itemStack;
        }
        boolean isToolEnough = drop.isToolEnough(itemStack);
        int damage = isToolEnough ? 1 : 2;
        int n = damage = ItemUtils.isTool(itemStack) ? damage : 0;
        if (damage == 0) {
            return itemStack;
        }
        if (VersionUtil.isPaperServer() && VersionUtil.atOrAbove("1.19")) {
            return player.damageItemStack(itemStack, damage);
        }
        int finalDamage = damage;
        return ItemUtils.editItemMeta(itemStack, meta -> {
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                if (EventUtils.callEvent((Event)new PlayerItemDamageEvent(player, itemStack, finalDamage))) {
                    damageable.setDamage(damageable.getDamage() + 1);
                }
            }
        });
    }

    public static boolean isTool(@NotNull ItemStack itemStack) {
        return ItemUtils.isTool(itemStack.getType());
    }

    public static boolean isTool(@NotNull Material material) {
        if (VersionUtil.atOrAbove("1.19.4") && !VersionUtil.atOrAbove("1.20.5")) {
            return Tag.ITEMS_TOOLS.isTagged((Keyed)material);
        }
        return material.toString().endsWith("_AXE") || material.toString().endsWith("_PICKAXE") || material.toString().endsWith("_SHOVEL") || material.toString().endsWith("_HOE") || material.toString().endsWith("_SWORD") || material == Material.TRIDENT;
    }

    public static boolean isSkull(Material material) {
        return switch (material) {
            case Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD, Material.SKELETON_SKULL, Material.SKELETON_WALL_SKULL, Material.WITHER_SKELETON_SKULL, Material.WITHER_SKELETON_WALL_SKULL, Material.ZOMBIE_HEAD, Material.ZOMBIE_WALL_HEAD, Material.CREEPER_HEAD, Material.CREEPER_WALL_HEAD, Material.DRAGON_HEAD, Material.DRAGON_WALL_HEAD, Material.PIGLIN_HEAD, Material.PIGLIN_WALL_HEAD -> true;
            default -> false;
        };
    }

    public static boolean hasInventoryParent(Material material) {
        return Tag.WALLS.isTagged((Keyed)material) || Tag.FENCES.isTagged((Keyed)material) || Tag.BUTTONS.isTagged((Keyed)material) || material == Material.PISTON || material == Material.STICKY_PISTON || VersionUtil.atOrAbove("1.20") && material == Material.CHISELED_BOOKSHELF || material == Material.BROWN_MUSHROOM_BLOCK || material == Material.RED_MUSHROOM_BLOCK || material == Material.MUSHROOM_STEM;
    }
}

